/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.execute;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.async.app.task.AsyncOrderTaskUtil;
import com.kingdee.eas.csinterface.async.app.task.IAsyncTaskExecutor;
import com.kingdee.eas.csinterface.async.app.task.model.ResultInfo;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPHttpClient;
import com.kingdee.eas.csinterface.eipserviceplugin.model.base.IERPModel;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import java.util.Map;
import org.apache.log4j.Logger;

public class SendDirectExecuterImpl
extends IERPExecute
implements IAsyncTaskExecutor {
    private static Logger logger = Logger.getLogger(SendDirectExecuterImpl.class);
    private static final String DATA = "data";
    private static final String MODEL = "model";
    private static final String ACTION = "action";

    public static ResultInfo orderTask4API(Context ctx, String adaptorNumber, String action, String bosTypeStr, String data, Boolean sync) throws BOSException {
        ResultInfo result = new ResultInfo();
        try {
            IERPModel model = IERPModel.getAdaptorModel(ctx, adaptorNumber);
            if (model == null) {
                throw new BOSException("\u627e\u5230\u6307\u5b9a\u7684\u62e6\u622a\u670d\u52a1\u65b9\u6848\uff0c\u7f16\u7801\u4e3a\uff1a" + adaptorNumber);
            }
            if (StringUtils.isEmpty(bosTypeStr)) {
                BOSObjectType bosType = BOSObjectType.create((String)bosTypeStr);
                model.setBosType(bosTypeStr);
            }
            if (sync != null) {
                model.setSync(sync);
            } else {
                sync = model.isSync();
            }
            String solution = model.getSolution();
            String loginService = model.getLoginservice();
            WSServiceInfo serviceInfo = SendDirectExecuterImpl.getWSServiceInfo(ctx, loginService, model.getNumber());
            FieldDefineModel fieldModel = IERPHttpClient.getPKFieldCache(ctx, serviceInfo, solution);
            JSONObject dataObj = new JSONObject();
            dataObj.put(DATA, (Object)data);
            dataObj.put(MODEL, (Object)model);
            dataObj.put(ACTION, (Object)action);
            String description = "\u65b9\u6848\uff1a" + model.getNumber() + "(" + model.getName() + ")\uff0c\u6267\u884c\u64cd\u4f5c(" + action + ")";
            if (sync.booleanValue()) {
                SendDirectExecuterImpl executor = new SendDirectExecuterImpl();
                result = executor.execute(ctx, null, dataObj.toJSONString(), null);
            } else {
                AsyncOrderTaskUtil.orderTask(ctx, "EIPSendDirect", dataObj.toJSONString(), null, description);
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            logger.error((Object)"\u4e1a\u52a1\u4e8c\u5f00\u89e6\u53d1\u6570\u636e\u540c\u6b65\u5f02\u5e38", e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            result.setException(new Exception(e));
        }
        return result;
    }

    public static void orderTask(Context ctx, IERPModel model, IServiceContext serviceContext, String action, String data) throws BOSException {
        JSONObject dataObj = new JSONObject();
        dataObj.put(DATA, (Object)data);
        dataObj.put(MODEL, (Object)model);
        dataObj.put(ACTION, (Object)action);
        String description = "\u65b9\u6848\uff1a" + model.getNumber() + "(" + model.getName() + ")\uff0c\u6267\u884c\u64cd\u4f5c(" + action + ")";
        AsyncOrderTaskUtil.orderTask(ctx, "EIPAdaptorService", dataObj.toJSONString(), null, description);
    }

    @Override
    public ResultInfo execute(Context ctx, Job job, String taskData, ResultInfo result) throws BOSException {
        result = new ResultInfo();
        JSONObject dataObj = JSONObject.parseObject((String)taskData);
        String sendData = dataObj.getString(DATA);
        IERPModel model = IERPModel.deSerialize(ctx, dataObj.getString(MODEL));
        String action = dataObj.getString(ACTION);
        String actualAction = model.getActualAction(action);
        String loginService = model.getLoginservice();
        boolean isSync = model.isSync();
        WSServiceInfo serviceInfo = SendDirectExecuterImpl.getWSServiceInfo(ctx, loginService, model.getNumber());
        String solution = model.getSolution();
        Map resultMap = IERPHttpClient.post(ctx, serviceInfo, actualAction, model.getAfterAction(action), solution, sendData, isSync, model.getPublishId());
        return result;
    }
}

