/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.BufferedBillDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.AbstractSubMonitorLogControllerBean;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubMonitorLogControllerBean
extends AbstractSubMonitorLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.monitor.app.SubMonitorLogControllerBean");

    @Override
    protected IObjectValue _getByMonitorAndTable(Context ctx, String monitorLogId, String tableName) throws BOSException, EASBizException {
        String oql = "where monitorLogId='" + monitorLogId + "' and tablename= '" + tableName + "'";
        SubMonitorLogCollection coll = this.getSubMonitorLogCollection(ctx, oql);
        return SubMonitorLogControllerBean.mergeColl2Info((IObjectCollection)coll);
    }

    @Override
    protected Map _getDetailByMonitor(Context ctx, String monitorLogId) throws BOSException, EASBizException {
        SubMonitorLogCollection coll = new SubMonitorLogCollection();
        SubMonitorLogInfo info = new SubMonitorLogInfo();
        HashMap<String, Integer> mapSuccessCount = new HashMap<String, Integer>();
        HashMap<String, Integer> mapFailCount = new HashMap<String, Integer>();
        HashMap<String, Integer> mapExistCount = new HashMap<String, Integer>();
        HashMap<String, String> mapSubLogId = new HashMap<String, String>();
        HashMap map = new HashMap();
        EntityViewInfo view1 = new EntityViewInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("PLANNUMBER"));
        sic1.add(new SelectorItemInfo("TABLENAME"));
        sic1.add(new SelectorItemInfo("CMD"));
        sic1.add(new SelectorItemInfo("SUCCESSCOUNT"));
        sic1.add(new SelectorItemInfo("FAILURECOUNT"));
        sic1.add(new SelectorItemInfo("EXISTCOUNT"));
        sic1.add(new SelectorItemInfo("ID"));
        view1.setSelector(sic1);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("monitorLogId", (Object)monitorLogId, CompareType.EQUALS));
        view1.setFilter(filter1);
        SubMonitorLogCollection coll1 = SubMonitorLogFactory.getLocalInstance(ctx).getSubMonitorLogCollection(view1);
        for (int i = 0; i < coll1.size(); ++i) {
            SubMonitorLogInfo info1 = coll1.get(i);
            String key = info1.getTableName() + info1.getPlanNumber() + info1.getCmd();
            if (StringUtils.isEmpty((String)key)) continue;
            if (info1.getSuccessCount() > 0) {
                if (mapSuccessCount.get(key) != null) {
                    int sucCount = mapSuccessCount.get(key) == null ? 0 : (Integer)mapSuccessCount.get(key);
                    mapSuccessCount.put(key, sucCount + info1.getSuccessCount());
                } else {
                    mapSuccessCount.put(key, info1.getSuccessCount());
                }
            } else if (info1.getFailureCount() > 0) {
                if (mapFailCount.get(key) != null) {
                    int failCount = mapFailCount.get(key) == null ? 0 : (Integer)mapFailCount.get(key);
                    mapFailCount.put(key, failCount + info1.getFailureCount());
                } else {
                    mapFailCount.put(key, info1.getFailureCount());
                }
            } else if (info1.getExistCount() > 0) {
                if (mapExistCount.get(key) != null) {
                    int existCount = mapExistCount.get(key) == null ? 0 : (Integer)mapExistCount.get(key);
                    mapExistCount.put(key, existCount + info1.getExistCount());
                } else {
                    mapExistCount.put(key, info1.getExistCount());
                }
            }
            if (mapSubLogId.containsValue(key)) continue;
            mapSubLogId.put(info1.getId().toString(), key);
        }
        EntityViewInfo view2 = new EntityViewInfo();
        SelectorItemCollection sic2 = new SelectorItemCollection();
        sic2.add(new SelectorItemInfo("SUCCESS"));
        sic2.add(new SelectorItemInfo("PLANNUMBER"));
        sic2.add(new SelectorItemInfo("TABLENAME"));
        sic2.add(new SelectorItemInfo("MAINTABLE"));
        sic2.add(new SelectorItemInfo("CMD"));
        view2.setSelector(sic2);
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("id", mapSubLogId.keySet(), CompareType.INCLUDE));
        view2.setFilter(filter2);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("PLANNUMBER"));
        view2.setSorter(sorts);
        SubMonitorLogCollection filterColl = SubMonitorLogFactory.getLocalInstance(ctx).getSubMonitorLogCollection(view2);
        Iterator subIte = filterColl.iterator();
        SubMonitorLogInfo subLogInfo = null;
        String subLogId = null;
        String subKey = null;
        while (subIte.hasNext()) {
            subLogInfo = (SubMonitorLogInfo)subIte.next();
            subLogId = subLogInfo.getId().toString();
            subKey = (String)mapSubLogId.get(subLogId);
            if (mapSuccessCount.get(subKey) != null) {
                subLogInfo.setSuccessCount((Integer)mapSuccessCount.get(subKey));
            }
            if (mapExistCount.get(subKey) != null) {
                subLogInfo.setExistCount((Integer)mapExistCount.get(subKey));
            }
            if (mapFailCount.get(subKey) == null) continue;
            subLogInfo.setFailureCount((Integer)mapFailCount.get(subKey));
        }
        return SubMonitorLogControllerBean.mergeColl2Coll((IObjectCollection)filterColl);
    }

    @Override
    protected Map _getMainLogByMonitor(Context ctx, String monitorLogId) throws BOSException, EASBizException {
        String oql = "where monitorLogId='" + monitorLogId + "' and mainTable=1 order by PLANNUMBER";
        SubMonitorLogCollection coll = this.getSubMonitorLogCollection(ctx, oql);
        return SubMonitorLogControllerBean.mergeColl2Coll((IObjectCollection)coll);
    }

    public static final SubMonitorLogInfo mergeColl2Info(IObjectCollection coll) {
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        if (coll.size() > 0) {
            logInfo = (SubMonitorLogInfo)coll.getObject(0);
        }
        for (int i = 0; i < coll.size(); ++i) {
            SubMonitorLogInfo tmp = (SubMonitorLogInfo)coll.getObject(i);
            if (i == 0) {
                logInfo = tmp;
                continue;
            }
            SubMonitorLogControllerBean.mergeField(logInfo, tmp);
        }
        return logInfo;
    }

    public static Map getMainLogWithoutIDs(Context ctx, String monitorLogId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("PLANNUMBER"));
        sic.add(new SelectorItemInfo("TABLENAME"));
        sic.add(new SelectorItemInfo("CMD"));
        sic.add(new SelectorItemInfo("SUCCESSCOUNT"));
        sic.add(new SelectorItemInfo("FAILURECOUNT"));
        sic.add(new SelectorItemInfo("EXISTCOUNT"));
        sic.add(new SelectorItemInfo("ID"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("monitorLogId", (Object)monitorLogId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mainTable", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("PLANNUMBER"));
        view.setSorter(sorters);
        SubMonitorLogCollection coll = SubMonitorLogFactory.getLocalInstance(ctx).getSubMonitorLogCollection(view);
        return SubMonitorLogControllerBean.mergeColl2Coll((IObjectCollection)coll);
    }

    public static final Map mergeColl2Coll(IObjectCollection coll) {
        SubMonitorLogCollection collection = new SubMonitorLogCollection();
        HashMap<String, SubMonitorLogCollection> logMap = new HashMap<String, SubMonitorLogCollection>();
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        for (int i = 0; i < coll.size(); ++i) {
            SubMonitorLogInfo tmp = (SubMonitorLogInfo)coll.getObject(i);
            if (i == 0) {
                logInfo = tmp;
                collection.add(logInfo);
                continue;
            }
            if (!StringUtils.equals((String)logInfo.getPlanNumber(), (String)tmp.getPlanNumber())) {
                logMap.put(logInfo.getPlanNumber(), collection);
                collection = new SubMonitorLogCollection();
                collection.add(tmp);
                logInfo = tmp;
                continue;
            }
            if (!StringUtils.equals((String)logInfo.getTableName(), (String)tmp.getTableName())) {
                collection.add(tmp);
                logInfo = tmp;
                continue;
            }
            if (!StringUtils.equals((String)logInfo.getCmd(), (String)tmp.getCmd())) {
                collection.add(tmp);
                logInfo = tmp;
                continue;
            }
            SubMonitorLogControllerBean.mergeField(logInfo, tmp);
            if (i != coll.size() - 1) continue;
            collection.add(logInfo);
            logMap.put(logInfo.getPlanNumber(), collection);
        }
        if (coll.size() > 0) {
            collection.add(logInfo);
            logMap.put(logInfo.getPlanNumber(), collection);
        }
        return logMap;
    }

    private static final void mergeField(SubMonitorLogInfo logInfo, SubMonitorLogInfo tmp) {
        logInfo.setSuccessCount(logInfo.getSuccessCount() + tmp.getSuccessCount());
        logInfo.setFailureCount(logInfo.getFailureCount() + tmp.getFailureCount());
        logInfo.setExistCount(logInfo.getExistCount() + tmp.getExistCount());
        logInfo.setSuccess(SubMonitorLogControllerBean.trimFirstEmpty(logInfo.getSuccess()) + SubMonitorLogControllerBean.trimNull2Empty(tmp.getSuccess()));
        logInfo.setFailure(SubMonitorLogControllerBean.trimFirstEmpty(logInfo.getFailure()) + SubMonitorLogControllerBean.trimNull2Empty(tmp.getFailure()));
    }

    public static String trimFirstEmpty(String obj) {
        if (obj == null) {
            return "";
        }
        return obj;
    }

    public static String trimNull2Empty(String obj) {
        if (obj == null) {
            return "";
        }
        return "," + obj;
    }

    @Override
    protected void _addLogWithoutTrans(Context ctx, BaseDataSaver saver, String tableName, String type, boolean isMainTable, String planNumber) throws BOSException {
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        String monitorLogId = MonitorManager.getCurrentBaseDataDown().getId().toString();
        try {
            String successNumber = saver.getSuccessNumber();
            String failureNumber = saver.getFailureNumber();
            String existNumber = saver.getExistNumber();
            int successCount = BufferedBillDataProvider.getNumberCount(successNumber);
            int failureCount = BufferedBillDataProvider.getNumberCount(failureNumber);
            int existCount = BufferedBillDataProvider.getNumberCount(existNumber);
            if (failureCount > 0) {
                logInfo.setSuccess("");
                logInfo.setFailure(failureNumber);
                logInfo.setTableName(tableName);
                logInfo.setSuccessCount(0);
                logInfo.setFailureCount(failureCount);
                logInfo.setExistCount(existCount);
            } else {
                logInfo.setSuccess(successNumber);
                logInfo.setFailure(failureNumber);
                logInfo.setTableName(tableName);
                logInfo.setSuccessCount(successCount);
                logInfo.setFailureCount(failureCount);
                logInfo.setExistCount(existCount);
            }
            logInfo.setCmd(type);
            logInfo.setMainTable(isMainTable);
            logInfo.setPlanNumber(planNumber.toString());
            logInfo.setMonitorLogId(monitorLogId);
            SubMonitorLogFactory.getLocalInstance(ctx).addnew(logInfo);
        }
        catch (Exception e) {
            logger.error((Object)"EIP\u751f\u6210\u5b50\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }
}

