/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.monitor.app.util.IMonitorLogDataDown;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class MonitorLogDataDown
implements IMonitorLogDataDown {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.monitor.app.util.MonitorLogHelper");
    private static final List<String> APUSIC_LIST = Arrays.asList("apusic.log.0", "apusic.log.1", "csinterface.log", "apusic0.log", "apusic1.log");
    private static final String ZIP_LOG = "/eipLog.zip";
    private static final String COMMON_SEPARATOR = "/";
    private static final int BYTE_LENGTH = 1024;
    private FileOutputStream fos = null;
    private ZipOutputStream zos = null;
    private File zipFile;

    public static void addFile(String fileName) {
        APUSIC_LIST.add(fileName);
    }

    public static void removeFile(String fileName) {
        int index = APUSIC_LIST.indexOf(fileName);
        APUSIC_LIST.remove(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerWriterZipFile(String path) {
        try {
            this.fos = new FileOutputStream(this.zipFile);
            this.zos = new ZipOutputStream(this.fos);
            List<String> logPaths = this.getLogPaths(path);
            Map<String, byte[]> logDataMap = this.logsToByte(logPaths);
            this.innerZip(logDataMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (null != this.zos) {
                    this.zos.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)e1);
            }
        }
    }

    private File createFile(String path) {
        File zipFileTmp = new File(path);
        zipFileTmp.delete();
        if (!zipFileTmp.exists()) {
            try {
                zipFileTmp.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return zipFileTmp;
    }

    private List<String> getLogPaths(String path) {
        if (!StringUtils.isEmpty(path) && !path.endsWith(COMMON_SEPARATOR)) {
            path = path + COMMON_SEPARATOR;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String p : APUSIC_LIST) {
            paths.add(path + p);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> logsToByte(List<String> logPaths) {
        if (logPaths.isEmpty()) {
            return null;
        }
        HashMap<String, byte[]> logDataMap = new HashMap<String, byte[]>();
        FileInputStream fis = null;
        ByteArrayOutputStream byteos = null;
        for (String logPath : logPaths) {
            try {
                fis = new FileInputStream(logPath);
                byteos = new ByteArrayOutputStream();
                int num = 0;
                byte[] infos = new byte[1024];
                while ((num = fis.read(infos)) != -1) {
                    byteos.write(infos, 0, num);
                }
                byteos.flush();
                String[] tempstr = logPath.split(COMMON_SEPARATOR);
                logDataMap.put(tempstr[tempstr.length - 1], byteos.toByteArray());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                if (null != byteos) {
                    try {
                        byteos.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage());
                    }
                }
                if (null == fis) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return logDataMap;
    }

    private void innerZip(Map<String, byte[]> dataMap) {
        for (Map.Entry<String, byte[]> entry : dataMap.entrySet()) {
            String fileName = entry.getKey();
            byte[] data = entry.getValue();
            this.writeByteToZip(data, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteToZip(byte[] data, String fileName) {
        try {
            ZipEntry zipEntry = new ZipEntry(fileName);
            this.zos.putNextEntry(zipEntry);
            this.zos.write(data);
            this.zos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (null != this.zos) {
                    this.zos.closeEntry();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getLogZip2Byte() {
        FileInputStream fis = null;
        ByteArrayOutputStream byteos = null;
        try {
            fis = new FileInputStream(this.zipFile);
            byteos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = fis.read()) != -1) {
                byteos.write(ch);
            }
            byteos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != byteos) {
                    byteos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        if (null == byteos) {
            logger.error((Object)"byteos \u4e3a null \uff0c\u8bf7\u68c0\u67e5\uff01");
            return null;
        }
        return byteos.toByteArray();
    }

    private String localLogPath(String serverName) {
        String logPath = System.getProperty("EAS_INSTANCE_HOME");
        String profilesPath = new File(logPath).getParent();
        return profilesPath + File.separator + serverName + File.separator + "logs";
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMonitorLogData(String serverName) throws BOSException {
        try {
            String path = this.localLogPath(serverName);
            if (StringUtils.isEmpty(path)) {
                throw new BOSException("\u4e0b\u8f7d\u96c6\u6210\u5e73\u53f0\u76d1\u63a7\u65e5\u5fd7\uff0c\u65e5\u5fd7\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
            }
            this.zipFile = this.createFile(path + ZIP_LOG);
            this.innerWriterZipFile(path);
            byte[] byArray = this.getLogZip2Byte();
            return byArray;
        }
        finally {
            if (null != this.zipFile && this.zipFile.exists()) {
                this.zipFile.delete();
            }
        }
    }
}

