/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app.util.monitordel;

import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EIPConfigFileInfo {
    private static final Logger logger = Logger.getLogger(EIPConfigFileInfo.class);
    private volatile boolean isEnableMonitorDel;
    private boolean isExist;
    private long lastUpdatetime;
    private File conFile;

    public EIPConfigFileInfo() {
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        String path = System.getProperty("eas.properties.dir");
        String file = path + File.separator + "eipconfig.properties";
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            this.conFile = new File(file);
            if (this.conFile.exists()) {
                this.isExist = true;
                this.lastUpdatetime = this.conFile.lastModified();
                inputStream = new FileInputStream(this.conFile);
                prop.load(inputStream);
                if (!prop.containsKey("isEnableMonitorDel")) {
                    this.isEnableMonitorDel = false;
                    return;
                }
                String isEnableMonitorDel = prop.getProperty("isEnableMonitorDel");
                if (!StringUtils.isEmpty((String)isEnableMonitorDel)) {
                    this.isEnableMonitorDel = Boolean.valueOf(isEnableMonitorDel);
                }
            } else {
                this.isExist = false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ThrowableHelper.toString(ex));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)ThrowableHelper.toString(e));
                }
            }
        }
    }

    public boolean isEnableMonitorDel() {
        return this.isEnableMonitorDel;
    }

    public void setEnableMonitorDel(boolean isEnableMonitorDel) {
        this.isEnableMonitorDel = isEnableMonitorDel;
    }

    public boolean isExist() {
        return this.isExist;
    }

    public void setExist(boolean isExist) {
        this.isExist = isExist;
    }

    public long getLastUpdatetime() {
        return this.lastUpdatetime;
    }

    public void setLastUpdatetime(long lastUpdatetime) {
        this.lastUpdatetime = lastUpdatetime;
    }

    public File getConFile() {
        return this.conFile;
    }

    public void setConFile(File conFile) {
        this.conFile = conFile;
    }
}

