/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.MidBillDataProcessFacadeFactory;
import com.kingdee.eas.csinterface.billmapping.app.util.Log4jUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.TempTableUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CheckMidStatus {
    private static Logger logger = Logger.getLogger(CheckMidStatus.class);
    private Context ctx;
    private String midBillName;
    private ScheduleInfo scheduleInfo;
    private String midTableName;
    public static boolean checkByOldLogic = false;
    public static int checkType = 1;
    public static int pageSize = 20000;
    public static String baseQryCondition = " and fmidbillstatus in (1,2) ";
    public static int updateBillCount = 50000;

    public CheckMidStatus(Context ctx, BillMappingInfo billMappingInfo, ScheduleInfo scheduleInfo) {
        this.ctx = ctx;
        this.midBillName = billMappingInfo.getNumber();
        this.scheduleInfo = scheduleInfo;
        this.midTableName = billMappingInfo.getMidBillTable();
    }

    public void check(int type) throws Exception {
        Connection cn = null;
        int totalCount = 0;
        Map<String, Object> param = null;
        boolean truncateTempTable = false;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            String dbType = cn.getMetaData().getDatabaseProductName();
            HashMap<String, Object> finalResult = new HashMap<String, Object>();
            this.initResult(finalResult);
            String appendCondition = this.scheduleInfo.getDataFilter();
            param = this.createMapParam(type, cn, dbType, appendCondition);
            Log4jUtil.log(10, this.scheduleInfo.getDescription() + checkType);
            if ("all".equalsIgnoreCase(this.scheduleInfo.getDescription()) || checkType == 2) {
                TempTableUtil.createTempTableIfNotExist(param);
                TempTableUtil.addTempTableColumn(param);
                SQLUtils.execute((Connection)cn, (String)("insert into " + param.get("tempTableName") + " select " + param.get("flagColumn") + ",0 from " + this.midTableName + " where 1=1 " + CheckMidStatus.getWhereSql(appendCondition)));
                truncateTempTable = true;
                totalCount = this.getTotalCount(cn, (String)param.get("tempTableName"));
                int pageCount = (totalCount - 1) / pageSize + 1;
                MonitorManager.getCurrentCheckMidStatus().addBillCount(totalCount);
                for (int i = 0; i < pageCount; ++i) {
                    this.updateMidStatus(finalResult, i, param);
                }
            } else {
                this.updateMidStatus(finalResult, -1, param);
            }
            MonitorManager.getCurrentCheckMidStatus().setTransformResult(finalResult);
        }
        catch (Exception e) {
            logger.error((Object)("\u5f53\u524d\u68c0\u6d4b\u53d8\u5316\u7684\u603b\u6570\u4e3a\uff1a" + totalCount + "\u7edf\u4e00\u5f02\u5e38\u6253\u5370"), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (truncateTempTable) {
                    TempTableUtil.deleteHeadpkFromTempTable(param);
                }
            }
            catch (Exception e2) {
                logger.error((Object)"\u6e05\u9664\u6bd4\u5bf9\u6570\u636e\u8868\u5931\u8d25", (Throwable)e2);
            }
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private Map<String, Object> createMapParam(int type, Connection cn, String dbTypeStr, String appendCondition) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DBType dbType = DBType.getEnum(dbTypeStr);
        String tempTableName = TempTableUtil.getTempTableName(dbType, this.midTableName);
        param.put("tempTableName", tempTableName);
        param.put("appendCondition", appendCondition);
        param.put("dbTypeStr", dbTypeStr);
        param.put("DBTYPE", (Object)dbType);
        param.put("srcCon", cn);
        param.put("srcViewName", this.midTableName);
        param.put("pageSize", pageSize);
        param.put("actionType", type);
        if (type == 300) {
            param.put("flagColumn", "fid");
        } else if (type == 850) {
            param.put("flagColumn", "cfheadpk");
        }
        return param;
    }

    private void updateMidStatus(Map<String, Object> finalResult, int i, Map<String, Object> param) throws Exception {
        String qrySql = this.getQrySql(i, (String)param.get("dbTypeStr"), (String)param.get("appendCondition"), (String)param.get("tempTableName"), (String)param.get("flagColumn"));
        RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)((Connection)param.get("srcCon")), (String)qrySql);
        if (i > -1) {
            TempTableUtil.deleteTempPageData(param);
        }
        HashSet<String> srcIdSet = new HashSet<String>();
        while (rowSet.next()) {
            String headpk = rowSet.getString(1);
            srcIdSet.add(headpk);
        }
        if (i < 0) {
            MonitorManager.getCurrentCheckMidStatus().addBillCount(srcIdSet.size());
        }
        Map<String, Object> result = new HashMap<String, Object>();
        int type = (Integer)param.get("actionType");
        if (type == 300) {
            result = (Map)MidBillDataProcessFacadeFactory.getLocalInstance(this.ctx).setMidBillStatus(this.midTableName, srcIdSet.toArray(new String[0]));
        } else if (type == 850) {
            result = (Map)MidBillDataProcessFacadeFactory.getLocalInstance(this.ctx).checkMidStatuForBaseData(this.midBillName, srcIdSet.toArray(new String[0]));
        }
        this.adjustResult(finalResult, result);
    }

    private void initResult(Map<String, Object> finalResult) {
        finalResult.put("srcIdExitNum", 0);
        finalResult.put("srcIdNotExitNum", 0);
        finalResult.put("srcIdRealNum", 0);
    }

    private void adjustResult(Map<String, Object> finalResult, Map<String, Object> tempResult) {
        int finalExitNum = (Integer)finalResult.get("srcIdExitNum");
        int finalNotExitNum = (Integer)finalResult.get("srcIdNotExitNum");
        int finalRealNum = (Integer)finalResult.get("srcIdRealNum");
        Object objVal = tempResult.get("srcIdExitNum");
        if (null != objVal) {
            finalExitNum += ((Integer)objVal).intValue();
        }
        if (null != (objVal = tempResult.get("srcIdNotExitNum"))) {
            finalNotExitNum += ((Integer)objVal).intValue();
        }
        if (null != (objVal = tempResult.get("srcIdRealNum"))) {
            finalRealNum += ((Integer)objVal).intValue();
        }
        finalResult.put("srcIdExitNum", finalExitNum);
        finalResult.put("srcIdNotExitNum", finalNotExitNum);
        finalResult.put("srcIdRealNum", finalRealNum);
    }

    private String getQrySql(int i, String dbType, String appendCondition, String tempTableName, String flagColumn) {
        StringBuilder builder = new StringBuilder();
        String conditionSql = CheckMidStatus.getWhereSql(appendCondition);
        if (i < 0) {
            conditionSql = conditionSql + " order by flastUpdateTime desc ";
            if ("mySql".equalsIgnoreCase(dbType)) {
                builder.append("select tt." + flagColumn + " from (select " + flagColumn + " from " + this.midTableName + " where 1=1 ");
                builder.append(conditionSql + " limit " + updateBillCount + ",1) tt");
            } else {
                builder.append("select top " + updateBillCount + " " + flagColumn + " from " + this.midTableName + " where 1=1 " + conditionSql);
            }
        } else if ("mySql".equalsIgnoreCase(dbType)) {
            builder.append("select tt." + flagColumn + "  from (select  " + flagColumn + " from " + this.midTableName + " where 1=1 ");
            builder.append(conditionSql);
            builder.append("limit " + pageSize + " offset  " + i * pageSize + ") tt");
        } else {
            builder.append("select  " + flagColumn + " from " + this.midTableName + " where ");
            builder.append(flagColumn + " in (select top " + pageSize + " headpk  from " + tempTableName + " order by headpk) ");
        }
        return builder.toString();
    }

    public static String getWhereSql(String appendCondition) {
        String conditionSql = baseQryCondition;
        if (!StringUtils.isEmpty((String)appendCondition)) {
            conditionSql = conditionSql + " and " + appendCondition;
        }
        return conditionSql;
    }

    private int getTotalCount(Connection cn, String tempTableName) throws SQLException {
        int totalCount = 0;
        String qrySql = "select count(1) from " + tempTableName;
        RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)cn, (String)qrySql);
        while (rowSet.next()) {
            totalCount = rowSet.getInt(1);
        }
        return totalCount;
    }

    public void check() throws BOSException {
        CoreBillBaseCollection src = this.getSrcBillInfos();
        MonitorManager.getCurrentCheckMidStatus().addBillCount(src == null ? 0 : src.size());
        if (src == null || src.size() == 0) {
            return;
        }
        DIPMetadata dm = new DIPMetadata(this.midBillName);
        String midBillTableName = DIPMetadata.getShortName(dm.getHeaderTablePK());
        CheckMidStatus.updateMidBillStatus(this.ctx, src, midBillTableName);
    }

    private CoreBillBaseCollection getSrcBillInfos() throws BOSException {
        try {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo ev = null;
            String where = "";
            ev = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
            ev.setFilter(filter);
            CoreBillBaseCollection coreBaseColl = MidBillFactory.getInstance(this.ctx, this.midBillName).getCoreBillBaseCollection(ev);
            if (coreBaseColl == null || coreBaseColl.size() == 0) {
                logger.info((Object)("read MidBill data from '" + this.midBillName + "' is empty!!"));
            }
            return coreBaseColl;
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u4e2d\u95f4\u5355\u636e\u96c6\u5408\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static void updateMidBillStatus(Context ctx, CoreBillBaseCollection src, String midTableName) throws BOSException {
        HashSet<String> srcIdSet = new HashSet<String>();
        for (CoreBillBaseInfo bill : src) {
            String id = bill.getId().toString();
            if (StringUtils.isEmpty((String)id)) continue;
            srcIdSet.add(id);
        }
        Object result = MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillStatus(midTableName, srcIdSet.toArray(new String[0]));
        MonitorManager.getCurrentCheckMidStatus().setTransformResult(result);
    }
}

