/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataCheckUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class BaseDataCheckExist {
    static Logger logger = Logger.getLogger(BaseDataCheckExist.class);
    private Connection currCon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String judgement(String jsonInfo) {
        JSONObject jsonMap = JSON.parseObject((String)jsonInfo);
        String user = (String)jsonMap.get("USER");
        String password = (String)jsonMap.get("PASSWORD");
        String dcName = (String)jsonMap.get("DCNAME");
        String language = (String)jsonMap.get("LANG");
        String auth = (String)jsonMap.get("AUTH");
        try {
            Context ctx = this.getContext(user, password, dcName, language, auth);
            this.currCon = DbConnector.getConnection((Context)ctx);
            JSONArray array = (JSONArray)jsonMap.get("PKLIST");
            String existInfo = this.checkExistByHeadpk(ctx, array);
            jsonMap.clear();
            jsonMap.put("STATUS", "SUCC");
            jsonMap.put("RESULT", existInfo);
        }
        catch (Exception e) {
            jsonMap.clear();
            jsonMap.put("STATUS", "FAIL");
            jsonMap.put("MSG", e);
        }
        finally {
            SQLUtils.cleanup((Connection)this.currCon);
        }
        return JSON.toJSONString((Object)jsonMap);
    }

    public boolean judgement(Context ctx, String fid, Boolean throwError) throws Exception {
        RowSet rowSet;
        String orignalTable = this.getTableName(ctx, fid, false);
        String eipTable = BaseDataCheckUtil.getEipTable(orignalTable);
        try {
            this.currCon = DbConnector.getConnection((Context)ctx);
            rowSet = this.getRowInfo(this.currCon, eipTable, "'" + fid + "'");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)this.currCon);
        }
        ArrayList<String> listAgents = new ArrayList<String>();
        while (rowSet.next()) {
            String agentID = rowSet.getString(2);
            listAgents.add(agentID);
        }
        if (listAgents.size() != 0) {
            boolean exist = this.checkDestExist(ctx, fid, listAgents, orignalTable);
            if (exist && throwError.booleanValue()) {
                throw new Exception("\u5f53\u524dFID\u5b58\u5728EIP\u8bb0\u5f55");
            }
            if (exist) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDestExist(Context ctx, String fid, List<String> listAgents, String orignalTable) throws Exception {
        String qrySql = "select count(*) from " + orignalTable + " where fid ='" + fid + "'";
        CoreBaseCollection collection = ConnectionFactory.getLocalInstance(ctx).getCollection("where id in (" + this.getWhereSql(listAgents) + ")");
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            ConnectionInfo baseInfo = (ConnectionInfo)collection.get(i);
            Connection conn = null;
            try {
                conn = KSQLUtil.getConnection(baseInfo);
                RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)conn, (String)qrySql);
                while (rowSet.next()) {
                    int count = rowSet.getInt(1);
                    if (count == 0) continue;
                    boolean bl = true;
                    return bl;
                }
                continue;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    private String checkExistByHeadpk(Context ctx, JSONArray array) throws SQLException, BOSException {
        HashMap<String, List<String>> tableMap = new HashMap<String, List<String>>();
        ArrayList<String> errpkList = new ArrayList<String>();
        this.getTableMapInfo(ctx, array, tableMap, errpkList);
        Map<String, String> existInfo = this.getEIPInfo(array, tableMap);
        HashMap<String, ArrayList<String>> errorInfo = new HashMap<String, ArrayList<String>>();
        errorInfo.put("ERRPKLIST", errpkList);
        String[] infoArr = new String[]{JSON.toJSONString(errorInfo), JSON.toJSONString(existInfo)};
        HashMap<String, String[]> mapInfo = new HashMap<String, String[]>();
        mapInfo.put("INFO", infoArr);
        return JSON.toJSONString(mapInfo);
    }

    private Map<String, String> getEIPInfo(JSONArray array, Map<String, List<String>> tableMap) throws SQLException {
        HashMap<String, String> existInfo = new HashMap<String, String>();
        for (String eipTable : tableMap.keySet()) {
            String whereSql = this.getWhereSql(tableMap.get(eipTable));
            RowSet rowSet = this.getRowInfo(this.currCon, eipTable, whereSql);
            while (rowSet.next()) {
                String headpkTmp = rowSet.getString(1);
                String agentId = rowSet.getString(2);
                String createTime = rowSet.getObject(3).toString();
                if (existInfo.containsKey(headpkTmp)) {
                    existInfo.put(headpkTmp + "||" + agentId, "EIPTIME\uff1a" + createTime);
                    continue;
                }
                existInfo.put(headpkTmp, "EIPTIME\uff1a" + createTime + " || AGENTID\uff1a" + agentId);
            }
        }
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            String headpk = array.getString(i);
            if (existInfo.containsKey(headpk)) continue;
            existInfo.put(headpk, "\u65e0EIP\u8bb0\u5f55");
        }
        return existInfo;
    }

    private RowSet getRowInfo(Connection currCon, String eipTable, String whereSql) throws SQLException {
        String qrySql = "select headpk,agentId, createtime from  " + eipTable + " where headpk in (" + whereSql + ")";
        return SQLUtils.getJdbcRowSet((Connection)currCon, (String)qrySql);
    }

    private void getTableMapInfo(Context ctx, JSONArray array, Map<String, List<String>> tableMap, List<String> errpkList) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            String headpk = array.getString(i);
            try {
                List<Object> headpkList;
                String eipTable = this.getTableName(ctx, headpk, true);
                if (tableMap.containsKey(eipTable)) {
                    headpkList = tableMap.get(eipTable);
                    headpkList.add(headpk);
                    continue;
                }
                headpkList = new ArrayList();
                headpkList.add(headpk);
                tableMap.put(eipTable, headpkList);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("\u5f53\u524dID\u4e0d\u7b26\u5408\u89c4\u8303\uff0cID:" + headpk), (Throwable)ex);
                errpkList.add(headpk);
                array.remove(i);
            }
        }
    }

    private String getTableName(Context ctx, String headpk, boolean isEip) throws BOSException {
        BOSObjectType bosType = BOSUuid.read((String)headpk).getType();
        String tableName = FMIsqlFacadeFactory.getLocalInstance((Context)ctx).getTableNameByBosType(bosType);
        if (isEip) {
            return BaseDataCheckUtil.getEipTable(tableName);
        }
        return tableName;
    }

    private String getWhereSql(List<String> headpkList) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String headpk : headpkList) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append("'" + headpk + "'");
            ++i;
        }
        return builder.toString();
    }

    private Context getContext(String user, String password, String dcName, String language, String auth) throws BOSException {
        String tokenId = SessionUtil.getTokenId(user, password, dcName, language, "eas", auth);
        return SessionUtil.getContextByToken(tokenId);
    }

    public static String checkExist(String jsonInfo) {
        BaseDataCheckExist checkExist = new BaseDataCheckExist();
        return checkExist.judgement(jsonInfo);
    }

    public static boolean checkExist(Context ctx, String fid, boolean throwError) throws Exception {
        return BaseDataCheckExist.getInstance().judgement(ctx, fid, throwError);
    }

    public static BaseDataCheckExist getInstance() {
        return SingletonEnum.INSTANCE.getInstance();
    }

    public static enum SingletonEnum {
        INSTANCE;

        private BaseDataCheckExist checkExist = new BaseDataCheckExist();

        public BaseDataCheckExist getInstance() {
            return this.checkExist;
        }
    }
}

