/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.basedata.filter.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.csinterface.ITransactionWrapperFacade;
import com.kingdee.eas.csinterface.TransactionWrapperFacadeFactory;
import com.kingdee.eas.csinterface.agent.service.base.util.MD5;
import com.kingdee.eas.csinterface.app.TransactionBlock;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataConstant;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataContext;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataModel;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.FieldModel;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.InvocationProxy;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.ResultDto;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.filter.Filter;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.helper.TemplateHelper;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.invocation.BaseDataInvocation;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.listener.ITransformListener;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.visit.IVisitor;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.visit.VistorFactory;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationCollection;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationFactory;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationInfo;
import com.kingdee.eas.csinterface.syncdatabase.IEIPRelation;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.InspectorCreator;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseDataFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(BaseDataFilter.class);
    private List<ITransformListener> listeners = new ArrayList<ITransformListener>();

    @Override
    public String getFilterName() {
        return "BaseDataFilter";
    }

    @Override
    public String doFilter(BaseDataInvocation baseDataInvocation) throws Exception {
        Context ctx = baseDataInvocation.getContext();
        BaseDataContext bdctx = baseDataInvocation.getBaseDataContext();
        BDRMappingInfo bdr = (BDRMappingInfo)bdctx.getBdrMapping();
        DIETemplateInfo dIETemplateInfo = bdr.getDIETemplate();
        boolean isCodeImplementTrans = bdctx.getIsCodeImplementTrans();
        boolean isUserDefineTrans = bdctx.getIsUserDefineTrans();
        IDataTransmission iDataTrans = null;
        DefaultDataTransmission defaultTrans = null;
        if (isCodeImplementTrans) {
            iDataTrans = TemplateHelper.createDataTransmissionObject(dIETemplateInfo);
        }
        defaultTrans = new DefaultDataTransmission(ctx);
        defaultTrans.setDIETemplateInfo(dIETemplateInfo);
        defaultTrans.setContext(ctx);
        defaultTrans.setCodeImplementTrans(isCodeImplementTrans);
        defaultTrans.setUserDefineTrans(isUserDefineTrans);
        HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
        DatataskParameter dp = new DatataskParameter();
        Map myParam = dp.getContextParam();
        if (myParam != null) {
            contextParam.putAll(myParam);
        }
        contextParam.put("DATATASKMODE", new Integer(24));
        defaultTrans.setContextParameter(contextParam);
        int submitType = 0;
        submitType = iDataTrans != null ? iDataTrans.getSubmitType() : (defaultTrans != null ? defaultTrans.getSubmitType() : 0);
        IVisitor visit = VistorFactory.getVisit(submitType);
        List<Map> data = visit.visit((BaseDataModel)bdctx.getData());
        ITransactionWrapperFacade instance = TransactionWrapperFacadeFactory.getLocalInstance(ctx);
        BaseDataContext.getContext().put("all count", data.size());
        short countEach = dIETemplateInfo.getCountEachTime();
        int pageSize = (data.size() - 1) / countEach + 1;
        int success = 0;
        ArrayList<ResultDto> result = new ArrayList<ResultDto>();
        BaseDataContext.getContext().put("detail tranform infomation", result);
        for (int i = 0; i < pageSize; ++i) {
            List<Map> subList = null;
            subList = i < pageSize - 1 ? data.subList(i * countEach, (i + 1) * countEach) : data.subList(i * countEach, data.size());
            ResultDto dto = new ResultDto();
            StringBuilder sb = new StringBuilder();
            for (Map hsdata : subList) {
                sb.append(String.valueOf(visit.visitFieldValue(hsdata, BaseDataConstant.HEADPK_MODEL))).append(",");
            }
            dto.setHeadpk(sb.toString());
            BaseDataTransaction block = new BaseDataTransaction(ctx, baseDataInvocation, subList, visit, isCodeImplementTrans, isUserDefineTrans, iDataTrans, defaultTrans);
            try {
                result.addAll((List)instance.doInvokerWithTransaction(block));
                success += countEach;
                continue;
            }
            catch (Exception e) {
                dto.setSuccessed(false);
                if (e.getCause() instanceof TaskExternalException) {
                    StringBuilder traces = new StringBuilder();
                    StackTraceElement[] stackTraceElements = ((TaskExternalException)e.getCause()).getStackTrace();
                    for (int j = 0; j < stackTraceElements.length && j < 5; ++j) {
                        traces.append(stackTraceElements[j].toString()).append("\n");
                    }
                    dto.setErrorMsg(" \u57fa\u7840\u8d44\u6599\u5f15\u5165\u5b57\u6bb5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01\n" + traces);
                    logger.error((Object)"\u57fa\u7840\u8d44\u6599\u5f15\u5165\u5b57\u6bb5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Throwable)((TaskExternalException)e.getCause()));
                } else {
                    dto.setErrorMsg(e.getMessage());
                }
                result.add(dto);
            }
        }
        BaseDataContext.getContext().put("tranform successed count", success);
        baseDataInvocation.invoke();
        return "SUCCESS";
    }

    private CoreBaseInfo transform(Context ctx, Map hsData, boolean isCodeImplementTrans, boolean isUserDefineTrans, IDataTransmission iDataTrans, DefaultDataTransmission defaultTrans) throws Exception {
        CoreBaseInfo coreBaseInfo = null;
        try {
            if (isCodeImplementTrans) {
                coreBaseInfo = iDataTrans.transmit(hsData, ctx);
                coreBaseInfo = InspectorCreator.attachCreator((CoreBaseInfo)coreBaseInfo, (Map)hsData, (Context)ctx);
            }
            if (isUserDefineTrans && isCodeImplementTrans) {
                coreBaseInfo = this.dataTransmit(hsData, defaultTrans, coreBaseInfo);
                iDataTrans.submit(coreBaseInfo, ctx);
            } else if (isUserDefineTrans) {
                coreBaseInfo = this.dataTransmit(hsData, defaultTrans, coreBaseInfo);
                defaultTrans.submit(coreBaseInfo, ctx);
            } else if (isCodeImplementTrans) {
                iDataTrans.submit(coreBaseInfo, ctx);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u3010eip\u3011 process error", (Throwable)ex);
            throw ex;
        }
        return coreBaseInfo;
    }

    private CoreBaseInfo dataTransmit(Map hsData, DefaultDataTransmission defaultTrans, CoreBaseInfo coreBaseInfo) throws TaskExternalException {
        int blockSize = hsData.size();
        boolean hasTrans = false;
        if (blockSize > 0 && hsData.get(0) == null) {
            coreBaseInfo = defaultTrans.transmit(hsData, coreBaseInfo);
            hasTrans = true;
        }
        if (!hasTrans) {
            for (int i = 0; i < blockSize; ++i) {
                defaultTrans.setCurrentEntryRowIndex(i);
                coreBaseInfo = defaultTrans.transmit((Map)hsData.get(i), coreBaseInfo);
            }
        }
        return coreBaseInfo;
    }

    public List<ITransformListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<ITransformListener> listeners) {
        this.listeners = listeners;
    }

    public BaseDataFilter() {
        this.init();
    }

    private void init() {
        String[] listeners = InvocationProxy.getProperties(this.getFilterName());
        if (listeners == null) {
            return;
        }
        for (String listener : listeners) {
            ITransformListener filter = (ITransformListener)ClassUtil.getNewInstance(listener);
            this.listeners.add(filter);
        }
    }

    class BaseDataTransaction
    implements TransactionBlock {
        private Context ctx;
        private BaseDataInvocation baseDataInvocation;
        private List<Map> data;
        private IVisitor visit;
        private boolean isCodeImplementTrans;
        private boolean isUserDefineTrans;
        private IDataTransmission iDataTrans;
        private DefaultDataTransmission defaultTrans;

        public BaseDataTransaction(Context ctx, BaseDataInvocation baseDataInvocation, List<Map> data, IVisitor visit, boolean isCodeImplementTrans, boolean isUserDefineTrans, IDataTransmission iDataTrans, DefaultDataTransmission defaultTrans) {
            this.ctx = ctx;
            this.baseDataInvocation = baseDataInvocation;
            this.data = data;
            this.visit = visit;
            this.isCodeImplementTrans = isCodeImplementTrans;
            this.isUserDefineTrans = isUserDefineTrans;
            this.iDataTrans = iDataTrans;
            this.defaultTrans = defaultTrans;
        }

        @Override
        public Object doTransaction() throws Exception {
            HashMap<String, Object> contextParam = new HashMap<String, Object>();
            DatataskParameter dp = new DatataskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            FullOrgUnitInfo defaultOu = (FullOrgUnitInfo)BaseDataContext.getContext().get("default ou");
            ArrayList<ResultDto> rowsRresult = new ArrayList<ResultDto>();
            String preCuID = null;
            for (Map hsdata : this.data) {
                CoreBaseInfo destObject = null;
                ResultDto dto = new ResultDto();
                dto.setHeadpk(String.valueOf(this.visit.visitFieldValue(hsdata, BaseDataConstant.HEADPK_MODEL)));
                dto.setrValue(String.valueOf(this.visit.visitFieldValue(hsdata, (FieldModel)BaseDataContext.getContext().get("relation field"))));
                String ouID = defaultOu == null ? null : defaultOu.getId().toString();
                FieldModel ouField = (FieldModel)BaseDataContext.getContext().get("ou field");
                if (ouField != null) {
                    OrgUnitInfo ou = null;
                    Object comObj = this.visit.visitFieldValue(hsdata, ouField);
                    if (comObj != null) {
                        if (comObj instanceof String) {
                            FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitCollection("where number = '" + comObj + "'");
                            if (fullOrgUnitCollection.size() > 0) {
                                ou = fullOrgUnitCollection.get(0);
                            }
                        } else {
                            ou = (OrgUnitInfo)this.visit.visitFieldValue(hsdata, ouField);
                        }
                    }
                    if (ou != null) {
                        ouID = ou.getId().toString();
                    }
                }
                if (ouID == null) {
                    throw new Exception("\u627e\u4e0d\u5230\u76ee\u6807\u7ec4\u7ec7");
                }
                if (!ouID.equals(preCuID)) {
                    OrgSwitchFacadeFactory.getLocalInstance((Context)this.ctx).orgSwitch(ouID);
                    preCuID = ouID;
                }
                Map toCtxFieldMap = (Map)this.visit.visitFieldValue(hsdata, BaseDataConstant.TOCTX_MODEL);
                Set toCtxSet = toCtxFieldMap.keySet();
                for (String key : toCtxSet) {
                    DataToken token = (DataToken)toCtxFieldMap.get(key);
                    contextParam.put(key, token.data);
                }
                int midStatu = (Integer)this.visit.visitFieldValue(hsdata, BaseDataConstant.STATU_MODEL);
                if (2 == midStatu) {
                    contextParam.put("DATATASKMODE", new Integer(16));
                    this.defaultTrans.setContextParameter(contextParam);
                    if (null != this.iDataTrans) {
                        this.iDataTrans.setContextParameter(contextParam);
                    }
                } else {
                    contextParam.put("DATATASKMODE", new Integer(8));
                    this.defaultTrans.setContextParameter(contextParam);
                    if (null != this.iDataTrans) {
                        this.iDataTrans.setContextParameter(contextParam);
                    }
                }
                for (ITransformListener listen : BaseDataFilter.this.listeners) {
                    listen.beforeTransform(hsdata);
                }
                destObject = BaseDataFilter.this.transform(this.ctx, hsdata, this.isCodeImplementTrans, this.isUserDefineTrans, this.iDataTrans, this.defaultTrans);
                if (null != destObject) {
                    destObject.setInt("midBillStatus", 2);
                    dto.setDestObjectID(destObject.getId().toString());
                }
                dto.setSuccessed(true);
                for (ITransformListener listen : BaseDataFilter.this.listeners) {
                    listen.afterTransform(destObject);
                }
                rowsRresult.add(dto);
            }
            this.batchReverseSave(this.baseDataInvocation, rowsRresult);
            return rowsRresult;
        }

        private void batchReverseSave(BaseDataInvocation baseDataInvocation, List<ResultDto> rowsRresult) throws Exception {
            if (rowsRresult == null || rowsRresult.isEmpty()) {
                return;
            }
            CoreBaseCollection colls = new CoreBaseCollection();
            HashSet<String> set = new HashSet<String>();
            for (ResultDto rowResult : rowsRresult) {
                if (!rowResult.isSuccessed()) continue;
                set.add(rowResult.getHeadpk());
            }
            IEIPRelation instance = EIPRelationFactory.getLocalInstance(baseDataInvocation.getContext());
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("headpk", set, CompareType.INCLUDE));
            EIPRelationCollection coll = instance.getEIPRelationCollection(ev);
            set.clear();
            HashMap<String, BOSUuid> update = new HashMap<String, BOSUuid>();
            for (int i = 0; i < coll.size(); ++i) {
                update.put(coll.get(i).getHeadpk(), coll.get(i).getId());
            }
            BillMappingInfo billMappingInfo = (BillMappingInfo)baseDataInvocation.getBaseDataContext().getBillMapping();
            String str = billMappingInfo.getSrcDBConn().getId().toString();
            ConnectionInfo connectionInfo = ConnectionFactory.getLocalInstance(baseDataInvocation.getContext()).getConnectionInfo("where Id= '" + str + "'");
            String srcDatabase = connectionInfo.getIP() + "+" + connectionInfo.getPort() + "+" + connectionInfo.getInstance();
            String newHashCode = MD5.code(srcDatabase);
            MetaDataPK metaPk = new MetaDataPK(new DIPMetadata(billMappingInfo.getNumber()).getHeaderEntityPK());
            EntityObjectInfo entity = UictUtils.loadEntity((IMetaDataPK)metaPk);
            if (entity == null || entity.getType() == null) {
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38,\u67e5\u8be2\u7f16\u7801\u4e3a" + billMappingInfo.getNumber() + "\u4e1a\u52a1\u5355\u636e\u6620\u5c04BOSTYPE\u5931\u8d25");
            }
            String srcBostype = entity.getType().toString();
            ArrayList<Object[]> head = new ArrayList<Object[]>();
            for (ResultDto rowResult : rowsRresult) {
                if (!rowResult.isSuccessed()) continue;
                EIPRelationInfo info = new EIPRelationInfo();
                info.setId((BOSUuid)update.get(rowResult.getHeadpk()));
                head.add(new Object[]{1, rowResult.getHeadpk()});
                info.setHeadpk(rowResult.getHeadpk());
                info.setSrcObjectID(rowResult.getrValue());
                info.setDestObjectID(rowResult.getDestObjectID());
                info.setDestEntityID(BOSUuid.read((String)rowResult.getDestObjectID()).getType().toString());
                info.setBdrMapping(((BDRMappingInfo)baseDataInvocation.getBaseDataContext().getBdrMapping()).getId().toString());
                info.setSourceValue(newHashCode);
                info.setSrcEntityID(srcBostype);
                info.setSourceType(100);
                colls.add((CoreBaseInfo)info);
            }
            instance.submit(colls);
            BillMappingInfo billMapping = (BillMappingInfo)baseDataInvocation.getBaseDataContext().getBillMapping();
            String tableName = DBUtils.createTableName(billMapping.getNumber());
            String sql = "update " + tableName + " set fmidbillstatus=? where cfheadpk =?";
            DbUtil.executeBatch((Context)baseDataInvocation.getContext(), (String)sql, head);
        }
    }
}

