/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.MidBillTransferBotpFacadeFactory;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractTransferManager;
import com.kingdee.eas.csinterface.schedule.util.DestBillBatchUtil;
import com.kingdee.eas.csinterface.schedule.util.GroupInfo;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class TransferMultiToMultiManagerImpl
extends AbstractTransferManager {
    private static Logger logger = Logger.getLogger(TransferMultiToMultiManagerImpl.class);
    public static final int selectCountNumber = 1;
    public static final int defaultEntrysNumber = 3000;

    public TransferMultiToMultiManagerImpl(Context ctx, Set<String> headpkSet, BOTMappingInfo botMapping, BillMappingInfo billMappingInfo, String scheduId) {
        super(ctx, headpkSet, botMapping, billMappingInfo, scheduId);
    }

    @Override
    public void invokeTansferBotp() throws Exception {
        IDynamicBillTemplate template = MidBillFactory.getInstance(this.ctx, this.billMappingInfo.getNumber());
        Map<String, String> map = DestBillBatchUtil.findBotpGroupRule(this.ctx, this.botMapping);
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String[] entity = key.split("\\.");
            if (entity[0].equalsIgnoreCase(this.billMappingInfo.getNumber()) && !key.endsWith("_BOTP")) continue;
            it.remove();
        }
        if (map.isEmpty()) {
            EntityViewInfo ev = this.getBaseEntityViewInfo(this.headpkSet);
            IObjectPK[] pkList = template.getPKList(ev.getFilter(), null);
            if (pkList == null || pkList.length <= 0) {
                return;
            }
            HashSet<String> idList = new HashSet<String>();
            for (int index = 0; index < pkList.length; ++index) {
                idList.add(pkList[index].toString());
            }
            try {
                Integer assignmentNumber = DestBillBatchUtil.getMaxAssNumberByBillMapiing(this.ctx, this.billMappingInfo);
                MidBillTransferBotpFacadeFactory.getLocalInstance(this.ctx).orderTask(assignmentNumber, idList, this.billMappingInfo.getId().toString(), this.botMapping.getId().toString(), this.scheduId);
            }
            catch (Exception e) {
                this.printMoniLog(null, e, idList);
                logger.error((Object)e);
            }
            return;
        }
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        HashMap<String, String> tableEntryMap = new HashMap<String, String>();
        String groupBy = DestBillBatchUtil.findTableEntityMap(map, this.billMappingInfo, typeMap, tableEntryMap);
        List<GroupInfo> groupInfoList = this.findGroupInfoList(this.ctx, groupBy, this.billMappingInfo, this.headpkSet);
        for (int i = 0; i < groupInfoList.size(); ++i) {
            ArrayList<GroupInfo> infoList = new ArrayList<GroupInfo>();
            infoList.add(groupInfoList.get(i));
            EntityViewInfo ev = this.getSubEntityViewInfo(typeMap, tableEntryMap, infoList, this.headpkSet);
            IObjectPK[] pkList = template.getPKList(ev.getFilter(), null);
            HashSet<String> idList = new HashSet<String>();
            for (int index = 0; index < pkList.length; ++index) {
                idList.add(pkList[index].toString());
            }
            try {
                Integer assignmentNumber = DestBillBatchUtil.getMaxAssNumberByBillMapiing(this.ctx, this.billMappingInfo);
                MidBillTransferBotpFacadeFactory.getLocalInstance(this.ctx).orderTask(assignmentNumber, idList, this.billMappingInfo.getId().toString(), this.botMapping.getId().toString(), this.scheduId);
                continue;
            }
            catch (Exception e) {
                this.printMoniLog(infoList, e, idList);
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMoniLog(List<GroupInfo> infoList, Exception e, Set<String> idList) {
        try {
            if (this.scheduId != null) {
                MonitorManager.enterMidBillToDest(this.ctx, "\u8c03\u5ea6\u7b56\u7565", this.billMappingInfo.getNumber(), this.scheduId);
            } else {
                MonitorManager.enterMidBillToDest(this.ctx, "EAS\u5ba2\u6237\u7aef", this.billMappingInfo.getNumber(), null);
            }
            MonitorManager.getCurrentMidBillToDest().setBotMappingInfo(this.botMapping);
            MonitorManager.getCurrentMidBillToDest().setTransformType(this.botMapping.getDefineSys().getName());
            MonitorManager.getCurrentMidBillToDest().setDealingBillHeadpks(new ArrayList<String>(idList));
            StringBuilder errorMsg = new StringBuilder();
            if (infoList != null) {
                for (GroupInfo info : infoList) {
                    for (String columnName : info.getColumnValueMap().keySet()) {
                        Object value = info.getColumnValueMap().get(columnName);
                        errorMsg.append(columnName + "=" + value == null ? "" : value.toString() + "\n");
                    }
                }
            }
            Exception e1 = new Exception(errorMsg + e.getMessage());
            e1.setStackTrace(e.getStackTrace());
            MonitorManager.error(e1);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        finally {
            MonitorManager.exit(this.ctx);
        }
    }

    @Override
    public EntityViewInfo getBaseEntityViewInfo(Set<String> headpkSet) {
        EntityViewInfo selectedView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
        if (headpkSet != null && !headpkSet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("headpk", headpkSet, CompareType.INCLUDE));
            filter.setMaskString("(#0 or #1) and #2");
        } else {
            filter.setMaskString("(#0 or #1)");
        }
        selectedView.setFilter(filter);
        return selectedView;
    }

    @Override
    public String initQueryString(String groupBySql, BillMappingInfo billMappingInfo, Set<String> headpkSet) {
        StringBuilder headPkInSql = new StringBuilder();
        if (headpkSet != null && !headpkSet.isEmpty()) {
            headPkInSql.append("(");
            for (String str : headpkSet) {
                headPkInSql.append("'").append(str).append("'").append(",");
            }
            headPkInSql.deleteCharAt(headPkInSql.length() - 1);
            headPkInSql.append(")");
        }
        String result = "select count(1) ," + groupBySql + " from " + billMappingInfo.getMidBillTable() + " where (" + billMappingInfo.getMidBillTable() + ".FFivouchered =0 or " + billMappingInfo.getMidBillTable() + ".FFivouchered is null )";
        if (!StringUtils.isEmpty((String)headPkInSql.toString())) {
            result = result + " and cfheadpk in " + headPkInSql;
        }
        result = result + " group by " + groupBySql;
        result = result + " order by count(1) ";
        return result;
    }
}

