/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.util;

import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.StringTokenizer;

public class CronExpTranslation {
    private Date startExcuteDate;
    private String quartzExpression;

    public CronExpTranslation(Date startExcuteDate, String quartz) {
        this.startExcuteDate = startExcuteDate;
        this.quartzExpression = quartz;
    }

    public String parse() {
        return this.parseQuartz(this.quartzExpression);
    }

    private String parseQuartz(String quartz) {
        String time;
        String week;
        if (quartz == null || quartz.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u4ece" + (this.startExcuteDate == null ? "\u4eca\u5929" : DateTimeUtils.format((Date)this.startExcuteDate, (String)"yyyy-MM-dd")) + "\u8d77");
        StringTokenizer st = new StringTokenizer(quartz);
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextToken();
            ++i;
        }
        String date = this.parseDate(new String[]{tokens[3], tokens[4]});
        if (date != null && date.length() > 0) {
            buffer.append(",");
            buffer.append(date);
        }
        if ((week = this.parseWeek(tokens[5])) != null && week.length() > 0) {
            buffer.append(",");
            buffer.append(week);
        }
        if ((time = this.parseTime(new String[]{tokens[0], tokens[1], tokens[2]})) != null && time.length() > 0) {
            buffer.append(",");
            buffer.append(time);
        }
        return buffer.toString();
    }

    private String parseTime(String[] time) {
        if (time.length != 3) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.innerParse(time[2], "\u70b9", "\u5c0f\u65f6"));
        buffer.append(this.innerParse(time[1], "\u5206", "\u5206\u949f"));
        buffer.append(this.innerParse(time[0], "\u79d2", "\u79d2"));
        return buffer.toString();
    }

    private String innerParse(String field, String type, String typeAlias) {
        boolean isSerialValue;
        boolean isSegmentValue;
        boolean isIncrementValue;
        boolean isAllValues;
        boolean bl = isAllValues = "*".equals(field) || "?".equals(field);
        if (isAllValues) {
            return "";
        }
        boolean bl2 = isIncrementValue = field.indexOf("/") != -1;
        if (isIncrementValue) {
            return "\u4ece" + field.substring(0, field.indexOf("/")) + type + "\u5f00\u59cb,\u6bcf" + field.substring(field.indexOf("/") + 1, field.length()) + typeAlias;
        }
        boolean bl3 = isSegmentValue = field.indexOf("-") != -1;
        if (isSegmentValue) {
            return field + type;
        }
        boolean bl4 = isSerialValue = field.indexOf(",") != -1;
        if (isSerialValue) {
            return this.parseComma(field) + type;
        }
        return field + type;
    }

    public String parseComma(String field) {
        String[] str = field.split(",");
        StringBuffer result = new StringBuffer();
        int postion = 0;
        int i = 0;
        int size = str.length - 1;
        while (i <= size) {
            int next;
            int start;
            int before = start = Integer.parseInt(str[i]);
            int j = i + 1;
            while (j <= size && before + 1 == (next = Integer.parseInt(str[j]))) {
                postion = j++;
                before = next;
            }
            result.append(start);
            if (start != before) {
                result.append("-");
                result.append(str[postion]);
            }
            if (postion < size) {
                result.append(",");
            }
            i = ++postion;
        }
        return result.toString();
    }

    private String parseDate(String[] date) {
        if (date.length != 2) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        String day = date[0];
        String month = date[1];
        buffer.append(this.innerParse(month, "\u6708", "\u6708"));
        if ("L".equalsIgnoreCase(day)) {
            buffer.append("\u6700\u540e\u4e00\u5929");
        } else {
            buffer.append(this.innerParse(day, "\u65e5", "\u5929"));
        }
        return buffer.toString();
    }

    private String parseWeek(String week) {
        if (week == null || week.length() == 0) {
            throw new IllegalArgumentException();
        }
        String[] weekDay = new String[]{"\u5360\u4f4d\u7b26", "\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        if ("*".equals(week)) {
            return "\u6bcf\u5468";
        }
        if ("?".equals(week)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int commaIndex = week.indexOf(44);
        int jingIndex = week.indexOf(35);
        if (commaIndex > 0) {
            String[] tokens = week.split(",");
            for (int i = 0; i <= tokens.length - 1; ++i) {
                if (i > 0) {
                    buffer.append("\u3001");
                }
                buffer.append(weekDay[Integer.parseInt(tokens[i])]);
            }
        } else if (jingIndex > 0) {
            String[] tokens = week.split("#");
            buffer.append("\u7b2c" + tokens[1] + "\u4e2a\u661f\u671f");
            buffer.append(weekDay[Integer.parseInt(tokens[0])]);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

