/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.util;

import com.kingdee.eas.csinterface.schedule.ScheduleTimerEnum;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MyTimer {
    private static final String everNDaysPrefix = "kingdeeEextend_everyNDays:";
    private static final String weekPrefix = "kingdeeEextend_week:";
    private static final String monthPrefix = "kingdeeEextend_month:";
    private static final String timeInterval = "kingdeeEextend_interval:";
    private static final String userDefine = "kingdeeEextend_define:";
    public static final String INTERVAL_TYPE_HOUR = "\u5c0f\u65f6";
    public static final String INTERVAL_TYPE_MINUS = "\u5206\u949f";
    public static final String INTERVAL_TYPE_SECOND = "\u79d2\u949f";
    public static final String[] INTERVAL_TYPES = new String[]{"\u5c0f\u65f6", "\u5206\u949f", "\u79d2\u949f"};
    protected ScheduleTimerEnum timerType;
    protected Date actionTimerTime;
    private int n;
    private boolean[] daysInWeek = new boolean[7];
    private boolean[] datesInMonth = new boolean[31];
    private String triggerExpression;
    private String intervalType;
    private int interval;
    private static final DateFormat dateFormat = new SimpleDateFormat("ss mm HH");

    public MyTimer(ScheduleTimerEnum timerType, Date actionTimerTime, int n, boolean[] daysInWeek, boolean[] datesInMonth, String triggerExpression) {
        this.timerType = timerType;
        this.actionTimerTime = actionTimerTime;
        this.n = n;
        this.daysInWeek = daysInWeek;
        this.datesInMonth = datesInMonth;
        this.triggerExpression = triggerExpression;
    }

    public MyTimer(String intervalType, int interval) {
        String triggerExpression = null;
        if (INTERVAL_TYPE_HOUR.equals(intervalType)) {
            triggerExpression = "0 0 0/" + interval + " * * ?";
        } else if (INTERVAL_TYPE_MINUS.equals(intervalType)) {
            triggerExpression = "0 0/" + interval + " * * * ?";
        } else if (INTERVAL_TYPE_SECOND.equals(intervalType)) {
            triggerExpression = "0/" + interval + " * * * * ?";
        } else {
            throw new IllegalArgumentException("not supported interval type '" + intervalType + "'");
        }
        this.intervalType = intervalType;
        this.interval = interval;
        this.timerType = ScheduleTimerEnum.timeInterval;
        this.triggerExpression = triggerExpression;
    }

    public MyTimer(ScheduleTimerEnum timerType, String triggerExpression) {
        this.timerType = timerType;
        this.triggerExpression = triggerExpression;
    }

    public String parse2Expression() {
        StringBuffer sb = new StringBuffer();
        int timerTypeValue = this.timerType.getValue();
        if (0 == timerTypeValue) {
            sb.append(everNDaysPrefix);
            sb.append(dateFormat.format(this.actionTimerTime));
            sb.append(" * * ?");
        } else if (1 == timerTypeValue) {
            sb.append(weekPrefix);
            sb.append(dateFormat.format(this.actionTimerTime));
            sb.append(" ? * ");
            boolean first = true;
            for (int i = 0; i < this.daysInWeek.length; ++i) {
                if (!this.daysInWeek[i]) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i + 1);
            }
        } else if (2 == timerTypeValue) {
            sb.append(monthPrefix);
            sb.append(dateFormat.format(this.actionTimerTime));
            sb.append(" ");
            boolean first = true;
            for (int i = 0; i < this.datesInMonth.length; ++i) {
                if (!this.datesInMonth[i]) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i + 1);
            }
            sb.append(" * ?");
        } else if (3 == timerTypeValue) {
            sb.append(timeInterval);
            sb.append(this.triggerExpression);
        } else if (4 == timerTypeValue) {
            sb.append(userDefine);
            sb.append(this.triggerExpression);
        }
        return sb.toString();
    }

    public static MyTimer parse2MyTimer(String expression) {
        if (expression.startsWith(everNDaysPrefix)) {
            String cornExpression = expression.substring(everNDaysPrefix.length());
            String tag = " * * ?";
            int index = cornExpression.indexOf(tag);
            String timeStr = cornExpression.substring(0, index);
            Date actionTimerTime = null;
            try {
                actionTimerTime = dateFormat.parse(timeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return new MyTimer(ScheduleTimerEnum.everyNDays, actionTimerTime, 1, null, null, cornExpression);
        }
        if (expression.startsWith(weekPrefix)) {
            String cornExpression = expression.substring(weekPrefix.length());
            String tag = " ? * ";
            int index = cornExpression.indexOf(tag);
            String timeStr = cornExpression.substring(0, index);
            Date actionTimerTime = null;
            try {
                actionTimerTime = dateFormat.parse(timeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String weekStr = cornExpression.substring(index + tag.length());
            String[] weekStrs = weekStr.split(",");
            boolean[] weeks = new boolean[7];
            for (int i = 0; i < weekStrs.length; ++i) {
                int week = Integer.parseInt(weekStrs[i]) - 1;
                weeks[week] = true;
            }
            return new MyTimer(ScheduleTimerEnum.week, actionTimerTime, 0, weeks, null, cornExpression);
        }
        if (expression.startsWith(monthPrefix)) {
            String cornExpression;
            String _cornExpression = cornExpression = expression.substring(monthPrefix.length());
            int index = _cornExpression.indexOf(" * ?");
            _cornExpression = _cornExpression.substring(0, index);
            String tag = " ";
            index = _cornExpression.lastIndexOf(tag);
            String timeStr = _cornExpression.substring(0, index);
            Date actionTimerTime = null;
            try {
                actionTimerTime = dateFormat.parse(timeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String daysStr = _cornExpression.substring(index + tag.length());
            String[] daysStrs = daysStr.split(",");
            boolean[] days = new boolean[31];
            for (int i = 0; i < daysStrs.length; ++i) {
                int day = Integer.parseInt(daysStrs[i]) - 1;
                days[day] = true;
            }
            return new MyTimer(ScheduleTimerEnum.month, actionTimerTime, 0, null, days, cornExpression);
        }
        if (expression.startsWith(timeInterval)) {
            String triggerExpression = expression.substring(timeInterval.length());
            String[] triggerPieces = triggerExpression.split("\\s+");
            String intervalType = null;
            int interval = 0;
            String pattern = "[^/]+/([^/]+)";
            for (int i = 0; i < triggerPieces.length; ++i) {
                if (!triggerPieces[i].matches(pattern)) continue;
                String _interval = triggerPieces[i].replaceAll(pattern, "$1");
                interval = Integer.parseInt(_interval);
                if (i == 0) {
                    intervalType = INTERVAL_TYPE_SECOND;
                    break;
                }
                if (i == 1) {
                    intervalType = INTERVAL_TYPE_MINUS;
                    break;
                }
                if (i != 2) break;
                intervalType = INTERVAL_TYPE_HOUR;
                break;
            }
            return new MyTimer(intervalType, interval);
        }
        if (expression.startsWith(userDefine)) {
            return new MyTimer(ScheduleTimerEnum.userDefine, expression.substring(userDefine.length()));
        }
        return null;
    }

    public static void main(String[] args) {
        String everNDays = "kingdeeEextend_everyNDays:0 10 12;3";
        String month = "kingdeeEextend_month:0 15 18 1,3,5,7,30,31 * ?";
        String week = "kingdeeEextend_week:0 10 12 ? * 1,3,4,5";
        MyTimer.parse2MyTimer(month);
    }

    public Date getActionTimerTime() {
        return this.actionTimerTime;
    }

    public int getN() {
        return this.n;
    }

    public boolean[] getDaysInWeek() {
        return this.daysInWeek;
    }

    public boolean[] getDatesInMonth() {
        return this.datesInMonth;
    }

    public String getCornExpression() {
        return this.triggerExpression;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getIntervalType() {
        return this.intervalType;
    }
}

