/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataMappingHelper;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.app.AbstractAssistAccountTypeFacadeControllerBean;
import com.kingdee.eas.csinterface.syncdatabase.app.util.CheckCorrespondRelationUtil;
import com.kingdee.eas.csinterface.syncdatabase.util.AssistAccountTypeBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssistAccountTypeFacadeControllerBean
extends AbstractAssistAccountTypeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.syncdatabase.app.AssistAccountTypeFacadeControllerBean");

    @Override
    protected List _checkTypeMapping(Context ctx, String ids, String filter, Map map) throws BOSException, EASBizException {
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        }
        catch (Exception e) {
            logger.info((Object)"license not enough.");
            throw new BOSException(e.getMessage());
        }
        BillMappingInfo strategy = DataModelUtil.readBillMappingInfo(ctx, ids);
        ArrayList<AssistAccountTypeBean> checkResult = new ArrayList<AssistAccountTypeBean>();
        if (!strategy.isIntegrateEasAssAcc() && !strategy.isIntergrateEASCashFlow() && StringUtil.isEmpty((String)strategy.getAsstNumber())) {
            return null;
        }
        IRowSet rs = CheckCorrespondRelationUtil.findSrcData(ctx, strategy, filter);
        if (rs == null) {
            return null;
        }
        AssistAccountTypeInfo assistAccountType = strategy.getAssistAccountType();
        try {
            BaseDataMappingHelper baseDataMappingHelper = new BaseDataMappingHelper(ctx);
            Map<String, CoreBaseInfo> dataMap = baseDataMappingHelper.initBaseDataMappingOnAssAcc(rs, strategy);
            Map<String, String> numberNameMap = baseDataMappingHelper.initAstNumberNameMapByRowSet(rs, strategy);
            AssistAccountTypeBean assistAccountTypeBean = new AssistAccountTypeBean();
            assistAccountTypeBean.setAssistAccountTypeId(assistAccountType.getId().toString());
            List list = CheckCorrespondRelationUtil.getFeildCheck(ctx, dataMap, numberNameMap);
            if (list != null && !list.isEmpty()) {
                assistAccountTypeBean.setList(list);
                checkResult.add(assistAccountTypeBean);
            }
        }
        catch (DIPException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return checkResult;
    }
}

