/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.billmapping.BillMappingCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.syncdatabase.app.AbstractSrcDBViewControllerBean;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.csinterface.utils.ViewSQLSimpleParser;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SrcDBViewControllerBean
extends AbstractSrcDBViewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.syncdatabase.app.SrcDBViewControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        for (IObjectPK pk : pkArray) {
            this.checkCanDelete(ctx, pk);
        }
        super._deleteBatchData(ctx, pkArray);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pkArray;
        for (IObjectPK pk : pkArray = super._delete(ctx, filter)) {
            this.checkCanDelete(ctx, pk);
        }
        return pkArray;
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pkArray;
        for (IObjectPK pk : pkArray = super._delete(ctx, oql)) {
            this.checkCanDelete(ctx, pk);
        }
        return pkArray;
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            this.checkCanDelete(ctx, pk);
        }
        super._delete(ctx, arrayPK);
    }

    private void checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SrcDBViewInfo dbView = this.getSrcDBViewInfo(ctx, pk);
        this.checkRelation(ctx, pk, dbView);
        this.deleteSrcViews(ctx, true, dbView);
    }

    private void checkRelation(Context ctx, IObjectPK pk, SrcDBViewInfo dbView) throws BOSException, EASBizException {
        boolean dialect = true;
        String ksql = dbView.getCreateViewSql();
        if (StringUtils.isEmpty((String)ksql)) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u89c6\u56fe\u8bed\u53e5\u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u5220\u9664\u89c6\u56fe\u3002"));
            return;
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ArrayList<String> ksqls = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        Object mainViewName = null;
        int index = 0;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            ++index;
            viewNames.add(parseResult.viewName);
            ksqls.add(dialect ? "/*dialect*/" + parseResult.viewSql : parseResult.viewSql);
        }
        DataSourceType dsType = dbView.getDsType();
        if (dsType == null) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u7f51\u7edc\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u89c6\u56fe"));
            return;
        }
        String connId = dbView.getConnection() == null ? null : dbView.getConnection().getId().toString();
        this.checkSrcViewHasUsed(ctx, viewNames.toArray(new String[0]), dbView.getNumber(), connId);
    }

    public void checkSrcViewHasUsed(Context ctx, String[] viewNames, String number, String connId) throws BOSException, EASBizException {
        if (viewNames.length == 0) {
            return;
        }
        if (connId == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcViewName", (Object)StringUtils.arrayToString((Object[])viewNames, (String)","), CompareType.INCLUDE));
        BillMappingCollection billColl = BillMappingFactory.getLocalInstance(ctx).getBillMappingCollection(viewInfo);
        Iterator it = billColl.iterator();
        StringBuffer relation = new StringBuffer();
        while (it.hasNext()) {
            BillMappingInfo bill = (BillMappingInfo)it.next();
            if (relation.length() > 0) {
                relation.append("\uff1b");
            }
            relation.append(bill.getSrcViewName()).append(",").append(bill.getNumber());
        }
        if (relation.length() > 0) {
            throw new BOSException("\u7f16\u7801\u4e3a\uff08" + number + "\uff09\u4e2d\u7684\u3010\u89c6\u56fe\u3011\u4e0e\u3010\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u3011\u5b58\u5728\u5f15\u7528\u5173\u7cfb(" + relation.toString() + ")\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
        EntityViewInfo typeViewInfo = new EntityViewInfo();
        FilterInfo typeFilter = new FilterInfo();
        typeViewInfo.setFilter(typeFilter);
        typeFilter.getFilterItems().add(new FilterItemInfo("srcTable", (Object)StringUtils.arrayToString((Object[])viewNames, (String)","), CompareType.INCLUDE));
        typeFilter.getFilterItems().add(new FilterItemInfo("conn.id", (Object)connId, CompareType.EQUALS));
        typeFilter.setMaskString("#0 and #1");
        BaseDataTypeCollection typeColl = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeCollection(typeViewInfo);
        Iterator typeIt = typeColl.iterator();
        StringBuffer typeRelation = new StringBuffer();
        while (typeIt.hasNext()) {
            BaseDataTypeInfo typeInfo = (BaseDataTypeInfo)typeIt.next();
            if (typeRelation.length() > 0) {
                typeRelation.append("\uff1b");
            }
            typeRelation.append(typeInfo.getSrcTable()).append(",").append(typeInfo.getNumber());
        }
        if (typeRelation.length() > 0) {
            throw new BOSException("\u7f16\u7801\u4e3a\uff08" + number + "\uff09\u4e2d\u7684\u3010\u89c6\u56fe\u3011\u4e0e\u3010\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04\u3011\u5b58\u5728\u5f15\u7528\u5173\u7cfb(" + typeRelation.toString() + ")\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
    }

    public void deleteSrcViews(Context ctx, boolean dialect, SrcDBViewInfo info) throws BOSException, EASBizException {
        String ksql = info.getCreateViewSql();
        if (StringUtils.isEmpty((String)ksql)) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u89c6\u56fe\u8bed\u53e5\u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u5220\u9664\u89c6\u56fe\u3002"));
            return;
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ArrayList<String> ksqls = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        String mainViewName = null;
        int index = 0;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            ++index;
            if (StringUtil.isEmpty((String)parseResult.viewName)) continue;
            viewNames.add(parseResult.viewName);
            ksqls.add(dialect ? "/*dialect*/" + parseResult.viewSql : parseResult.viewSql);
        }
        DataSourceType dsType = info.getDsType();
        if (dsType == null) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u7f51\u7edc\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u89c6\u56fe"));
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            ConnectionInfo conn = info.getConnection();
            if (null == conn) {
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(conn.getId());
            conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)pk);
            DataBaseType dbType = DataBaseType.getInstance(info.getDbType().getName());
            Connection srcDBConn = null;
            Statement statement = null;
            try {
                if (viewNames == null || viewNames.size() == 0) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < viewNames.size(); ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("'").append(((String)viewNames.get(i)).toUpperCase()).append("'");
                }
                try {
                    srcDBConn = KSQLUtil.getConnection(conn);
                }
                catch (Exception e) {
                    String errorMsg = "\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u5728\u6e90\u5e93\u4e2d\u5220\u9664\u5bf9\u5e94\u7684\u89c6\u56fe\uff1a" + buf.toString();
                    logger.error((Object)errorMsg);
                    System.out.print(errorMsg);
                    SQLUtil.cleanup(statement, srcDBConn);
                    return;
                }
                statement = srcDBConn.createStatement();
                System.out.println("executeQuery ksql :" + ksql);
                ksql = "Select KSQL_TABNAME From KSQL_USERTABLES Where KSQL_TABNAME in (" + buf.toString() + ")";
                ResultSet rs = statement.executeQuery(ksql);
                IRowSet rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                ArrayList<String> existViewList = new ArrayList<String>();
                try {
                    while (rowSet.next()) {
                        existViewList.add(rowSet.getString(1));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                Object[] existViews = existViewList.toArray(new String[0]);
                if (existViews != null && existViews.length > 0) {
                    String viewNamesStr = StringUtils.arrayToString((Object[])existViews, (String)",");
                    logger.info((Object)("\u9009\u62e9\u4e86\u5f3a\u5236\u5220\u9664\u89c6\u56fe:" + viewNamesStr));
                    for (int i = 0; i < existViews.length; ++i) {
                        if (((String)existViews[i]).charAt(0) != '\"') {
                            existViews[i] = ((String)existViews[i]).toUpperCase();
                        }
                        existViews[i] = "drop view " + (String)existViews[i];
                    }
                    try {
                        KSQLUtil.executeUpdate(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), (String[])existViews);
                        logger.info((Object)"\u5220\u9664\u89c6\u56fe\u6210\u529f\u3002");
                    }
                    catch (Exception e) {
                        MsgBox.showInfo((String)e.getMessage());
                        logger.error((Object)("\u5220\u9664\u89c6\u56fe\u5931\u8d25\u3002\n" + e));
                    }
                }
                SQLUtil.cleanup(statement, srcDBConn);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new BOSException((Throwable)e1);
            }
            finally {
                SQLUtil.cleanup(statement, srcDBConn);
            }
        }
        if (DataSourceType.agent.equals((Object)dsType)) {
            EipUserInfo eipUser = info.getAgentUser();
            if (null == eipUser) {
                return;
            }
            String[] dropKSQL = new String[viewNames.size()];
            for (int i = 0; i < viewNames.size(); ++i) {
                dropKSQL[i] = "drop view " + (String)viewNames.get(i);
            }
            EipTaskManager.orderViewDrop(ctx, eipUser, dropKSQL, viewNames.toArray(new String[0]), mainViewName);
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u4e0b\u8fbe\u5220\u9664\u89c6\u56fe\u6210\u529f\uff0c\u5206\u914d\u7ed9\uff1a" + eipUser.getName()));
        }
    }
}

