/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.app.util.Pks;
import com.kingdee.eas.csinterface.utils.AssistAccountMappingUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckCorrespondRelationUtil {
    public static IRowSet findSrcData(Context ctx, BillMappingInfo strategy, String filter) throws BOSException, EASBizException {
        StructuredDataModel dataModel;
        Pks pks = CheckCorrespondRelationUtil.getPks(strategy);
        BillMappingEntryCollection entryColl = strategy.getEntrys();
        Object entryInfo = null;
        try {
            dataModel = DataModelUtil.convert(strategy);
        }
        catch (DIPException e1) {
            throw new BOSException("\u8f6c\u6362\u6570\u636e\u6a21\u5f0f\u5f02\u5e38:" + e1.getMessage(), (Throwable)e1);
        }
        ArrayList checkResult = new ArrayList();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        if (!(header.baseDataTypes != null && header.baseDataTypes.length != 0 || entry.baseDataTypes != null && entry.baseDataTypes.length != 0 || strategy.isIntegrateEasAssAcc() || strategy.isIntergrateEASCashFlow() || !StringUtil.isEmpty((String)strategy.getAsstNumber()))) {
            return null;
        }
        StringBuffer sql = null;
        sql = CheckCorrespondRelationUtil.getQueryString(dataModel, filter);
        System.out.println("sql for _checkDataMaping:" + sql.toString());
        IRowSet rs = SQLFacadeFactory.getLocalInstance(ctx).getTargetRowset(strategy.getSrcDBConn(), sql.toString());
        return rs;
    }

    private static Pks getPks(BillMappingInfo strategy) {
        String headPk = null;
        String entryPk = null;
        BillMappingEntryCollection entryColl = strategy.getEntrys();
        BillMappingEntryInfo entry = null;
        int n = entryColl.size();
        for (int i = 0; i < n; ++i) {
            entry = entryColl.get(i);
            if (entry.isHead() && entry.isPkField()) {
                headPk = entry.getSrcFieldName();
                continue;
            }
            if (entry.isHead() || !entry.isPkField()) continue;
            entryPk = entry.getSrcFieldName();
        }
        return new Pks(headPk, entryPk);
    }

    private static StringBuffer getQueryString(StructuredDataModel dataModel, String filterString) {
        String asstNumber;
        Boolean isIntegrateEasCashFlow;
        int i;
        String srcWhere = StringUtils.trim((String)((String)dataModel.getProperty("srcWhere")));
        srcWhere = StringUtils.trim((String)srcWhere);
        String srcViewName = (String)dataModel.getProperty("srcViewName");
        String pkTableName = (String)dataModel.getProperty("pkTableName");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select ");
        String headPkName = null;
        int colNum = 0;
        for (i = 0; i < header.columns.length; ++i) {
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
            }
            if (header.columns[i].baseDataType == null) continue;
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            sqlBuf.append("v.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (entry.columns[i].baseDataType == null) continue;
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            sqlBuf.append("v.").append(entry.columns[i].name);
            ++colNum;
        }
        Boolean isIntegrateEasAssAcc = (Boolean)dataModel.getProperty("isIntegrateEasAssAcc");
        if (isIntegrateEasAssAcc.booleanValue()) {
            Map<String, String> relationMap = AssistAccountMappingUtil.findRelationMap((String)dataModel.getProperty("assistAccountRelation"));
            String assistAccount = relationMap.get("FNumberGroup");
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            sqlBuf.append("v.").append(assistAccount);
        }
        if ((isIntegrateEasCashFlow = (Boolean)dataModel.getProperty("isIntegrateEasCashFlow")).booleanValue()) {
            Map<String, String> relationMap = AssistAccountMappingUtil.findRelationMap((String)dataModel.getProperty("easCashFlowRelation"));
            String assistAccount = relationMap.get("CFAssGrp");
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            sqlBuf.append("v.").append(assistAccount);
        }
        if (!StringUtil.isEmpty((String)(asstNumber = (String)dataModel.getProperty("reportGroup")))) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            sqlBuf.append("v.").append(asstNumber);
        }
        sqlBuf.append(" from ").append(srcViewName).append(" as v");
        sqlBuf.append(" where v.").append(headPkName).append(" in (");
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = srcWhere.replaceAll("^(?im)where", "");
            }
            if (srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(srcWhere);
            } else {
                sqlBuf.append(" and ").append(srcWhere);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        sqlBuf.append(" not exists(select 1 from ").append(pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(")");
        return sqlBuf;
    }

    private static StringBuffer getMultiOrgQueryString(BillMappingInfo strategy, StructuredDataModel dataModel, String filterString) {
        String srcWhere = StringUtils.trim((String)((String)dataModel.getProperty("srcWhere")));
        srcWhere = StringUtils.trim((String)srcWhere);
        String srcViewName = (String)dataModel.getProperty("srcViewName");
        String pkTableName = (String)dataModel.getProperty("pkTableName");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        String orgId = "FCompanyID";
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select ");
        String headPkName = null;
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPk) continue;
            headPkName = header.columns[i].name;
            break;
        }
        sqlBuf.append("v.").append(orgId);
        sqlBuf.append(" from ").append(srcViewName).append(" as v");
        sqlBuf.append(" where v.").append(headPkName).append(" in (");
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = srcWhere.replaceAll("^(?im)where", "");
            }
            if (srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(srcWhere);
            } else {
                sqlBuf.append(" and ").append(srcWhere);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        sqlBuf.append(" not exists(select 1 from ").append(pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(")");
        return sqlBuf;
    }

    public static List getFeildCheck(Context ctx, Map baseDataMap, Map<String, String> numberNameMap) throws BOSException, SQLException, EASBizException {
        StringBuffer strBuffer = new StringBuffer();
        Object multiMap = null;
        Set set = baseDataMap.entrySet();
        Iterator it = set.iterator();
        Map.Entry elem = null;
        ArrayList<AssistAccountTypeEntryInfo> list = new ArrayList<AssistAccountTypeEntryInfo>();
        while (it.hasNext()) {
            elem = it.next();
            if (elem.getKey() == null || StringUtils.isEmpty((String)elem.getKey().toString()) || elem.getValue() != null) continue;
            AssistAccountTypeEntryInfo entryInfo = new AssistAccountTypeEntryInfo();
            entryInfo.setSrcID((String)elem.getKey());
            String srcDisplay = numberNameMap.get(elem.getKey());
            entryInfo.setSrcDisplay(srcDisplay);
            list.add(entryInfo);
        }
        return list;
    }
}

