/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util.gson;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JsonContext;
import com.kingdee.eas.csinterface.util.gson.EIPAutoRepaireUtil;
import com.kingdee.eas.csinterface.util.gson.Kson;
import java.lang.reflect.Type;
import java.util.HashMap;

public class EIPJSONUtils {
    public static final String SUCCESS = "success";
    public static final String FAILTURE = "error";
    public static final String QUOTES_PREFIX = "${quote_2312415321232}";
    public static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    public static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";

    public static String convertObjectToJson(Context ctx, Object object) throws BOSException {
        return EIPJSONUtils.convertObjectToJson(ctx, object, Kson.getGson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertObjectToJson(Context ctx, Object object, Gson gson) throws BOSException {
        if (object == null) {
            return "\"\"";
        }
        Kson.begin(EIPJSONUtils.newJsonContext(ctx));
        String result = null;
        try {
            result = gson.toJson(object);
        }
        finally {
            Kson.end();
        }
        if (result == null) {
            return "\"\"";
        }
        if (object instanceof String && result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        result = EIPJSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        if (result == null) {
            return null;
        }
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static HashMap<?, ?> convertJsonToObject(Context ctx, String json) throws BOSException {
        return (HashMap)EIPJSONUtils.convertJsonToObject(ctx, json, HashMap.class, Kson.getGson());
    }

    public static <T> T convertJsonToObject(Context ctx, String json, Class<T> classOfT) throws BOSException {
        return EIPJSONUtils.convertJsonToObject(ctx, json, classOfT, Kson.getGson());
    }

    public static <T> T convertJsonToObject(Context ctx, String json, Type typeOfT) throws BOSException {
        return EIPJSONUtils.convertJsonToObject(ctx, json, typeOfT, Kson.getGson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T convertJsonToObject(Context ctx, String json, Type typeOfT, Gson gson) throws BOSException {
        Kson.begin(EIPJSONUtils.newJsonContext(ctx));
        try {
            JSONObject obj = JSONObject.parseObject((String)json);
            String autoStr = obj.getString("isAutoRepair");
            boolean isAutoRepair = "true".equalsIgnoreCase(autoStr);
            Object t = gson.fromJson(json, typeOfT);
            if (t instanceof IObjectValue) {
                EIPAutoRepaireUtil.autoRepaire(isAutoRepair, (IObjectValue)t);
                Object object = t;
                return (T)object;
            }
            Object object = gson.fromJson(json, typeOfT);
            return (T)object;
        }
        finally {
            EIPAutoRepaireUtil.clearCache();
            Kson.end();
        }
    }

    static JsonContext newJsonContext(Context ctx) {
        return new JsonContext(ctx);
    }
}

