/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.IBaseDataMaping;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BaseDataMappingUtil {
    public static CoreBaseInfo convertFid2CoreBase(String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        IBaseDataMaping instance = BaseDataMapingFactory.getRemoteInstance();
        Map map = instance.convertId2CoreBaseInfo(new String[]{id});
        if (!map.isEmpty() && map.size() > 0) {
            return (CoreBaseInfo)map.values().iterator().next();
        }
        return null;
    }

    public static Map<String, CoreBaseInfo> convertFid2CoreBase(Context ctx, String[] idArray) throws BOSException, EASBizException {
        IBaseDataMaping instance = BaseDataMapingFactory.getLocalInstance(ctx);
        Map map = instance.convertId2CoreBaseInfo(idArray);
        return map;
    }

    public static Map<String, CoreBaseInfo> convertFid2CoreBase(Set<String> idSet) throws BOSException, EASBizException {
        String[] idArray = idSet.toArray(new String[0]);
        IBaseDataMaping instance = BaseDataMapingFactory.getRemoteInstance();
        Map map = instance.convertId2CoreBaseInfo(idArray);
        return map;
    }

    public static String getDestValue(IObjectValue coreBaseInfo, String field) {
        String value = "";
        if (field.indexOf(".") > 0) {
            String[] fields = field.split("\\.");
            value = ((IObjectValue)coreBaseInfo.get(fields[0])).getString(fields[1]);
        } else {
            value = coreBaseInfo.getString(field);
        }
        return value;
    }

    public static Map<String, CoreBaseInfo> convertFid2CoreBase(Set<String> idSet, BaseDataTypeInfo baseDataTypeInfo) throws BOSException, EASBizException {
        String[] idArray = idSet.toArray(new String[0]);
        String destDisplay = baseDataTypeInfo.getDestDisplay();
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)idSet.toArray(new String[0])[0], (boolean)true);
        ICoreBase instance = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, ICoreBase.class);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(baseDataTypeInfo.getDestDisplay()));
        selectors.add(new SelectorItemInfo(baseDataTypeInfo.getDestID()));
        ev.setSelector(selectors);
        HashMap<String, CoreBaseInfo> map = new HashMap<String, CoreBaseInfo>(idSet.size());
        CoreBaseCollection coll = instance.getCollection(ev);
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            CoreBaseInfo baseInfo = coll.get(i);
            String key = baseInfo.getId().toString();
            map.put(key, baseInfo);
        }
        return map;
    }

    public static Map<String, Object> convertFid2CoreBaseDisplay(Set<String> idSet, BaseDataTypeInfo baseDataTypeInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String destDisplay = baseDataTypeInfo.getDestDisplay();
        Map<String, CoreBaseInfo> map = BaseDataMappingUtil.convertFid2CoreBase(idSet);
        for (String fid : idSet) {
            CoreBaseInfo coreBase = map.get(fid);
            if (coreBase == null) continue;
            Object value = coreBase.get(destDisplay);
            result.put(fid, value);
        }
        return result;
    }

    public static Map<String, CoreBaseInfo> convertValue2CoreBase(Set<String> valueSet, BaseDataTypeInfo baseDataTypeInfo) throws BOSException, EASBizException {
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        StringBuffer strb = new StringBuffer();
        for (String key : valueSet) {
            if (!StringUtils.isEmpty((String)strb.toString())) {
                strb.append(",");
            }
            strb.append(key);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.baseDataType.id", (Object)baseDataTypeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcID", (Object)strb.toString(), CompareType.INCLUDE));
        ev.setFilter(filter);
        BaseDataMapingEntryCollection coll = BaseDataMapingEntryFactory.getRemoteInstance().getBaseDataMapingEntryCollection(ev);
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                BaseDataMapingEntryInfo info = coll.get(i);
                result.put(info.getSrcID(), (CoreBaseInfo)info);
            }
        }
        return result;
    }
}

