/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.utils;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObjectValueToMap {
    private List propList = new ArrayList();
    private Map<String, List> refPropMap = new HashMap<String, List>();
    private String[] prop;

    public List execute(IObjectValue value, String[] prop) {
        this.prop = prop;
        this.initProp(prop);
        LinkedList rtn = new LinkedList();
        this.flatten(value, rtn, new HashMap(), null, false);
        return rtn;
    }

    private void initProp(String[] prop) {
        this.propList.clear();
        for (int i = 0; i < prop.length; ++i) {
            String[] pns = prop[i].trim().split("[.]");
            this.addProperties(pns, pns.length - 1);
        }
    }

    private void addProperties(String[] pns, int currIndex) {
        if (currIndex > 0) {
            String porp = pns[currIndex - 1];
            if (!this.refPropMap.containsKey(porp)) {
                ArrayList props = new ArrayList();
                this.refPropMap.put(porp, props);
            }
            this.refPropMap.get(porp).add(pns[currIndex]);
            this.addProperties(pns, currIndex - 1);
        } else {
            this.propList.add(pns[0]);
        }
    }

    private void addToPropList(String key) {
        if (!this.propList.contains(key = key.toLowerCase())) {
            this.propList.add(key);
        }
    }

    private boolean isInFilterProp(String key) {
        key = key.toLowerCase();
        return this.propList.contains(key);
    }

    private void clearObjectValueMap(Map map, String pre) {
        if (pre == null || pre.length() == 0) {
            map.clear();
        } else {
            pre = pre + ".";
            for (String key : map.keySet()) {
                if (key == null || !key.startsWith(pre)) continue;
                map.put(key, null);
            }
        }
    }

    private void flatten(IObjectValue value, List list, Map map, String pre, boolean isIgnoreCollection) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        if (pre == null) {
            pre = "";
        }
        this.clearObjectValueMap(map, pre);
        String entryName = null;
        Enumeration enu = value.keys();
        while (enu.hasMoreElements()) {
            String p;
            String key = (String)enu.nextElement();
            if (key == null || !this.isInFilterProp(p = (pre.length() == 0 ? "" : pre + ".") + key)) continue;
            Object val = value.get(key);
            if (val instanceof IObjectValue) {
                map.put(p, val);
                this.flatten((IObjectValue)val, list, map, p, true);
                continue;
            }
            if (val instanceof IObjectCollection) {
                if (isIgnoreCollection) {
                    throw new IllegalArgumentException("value can not has a collection link property");
                }
                if (entryName == null) {
                    entryName = key;
                    continue;
                }
                throw new IllegalArgumentException("value has more than one collection link property");
            }
            if (val == null) continue;
            map.put(p, val);
        }
        if (!isIgnoreCollection) {
            if (entryName != null) {
                String p = (pre.length() == 0 ? "" : pre + ".") + entryName;
                IObjectCollection entries = (IObjectCollection)value.get(entryName);
                int len = entries.size();
                for (int i = 0; i < len; ++i) {
                    map.put(p, entries.getObject(i));
                    this.flatten(entries.getObject(i), list, map, p, false);
                }
            } else {
                HashMap map2 = new HashMap();
                for (int i = 0; i < this.prop.length; ++i) {
                    String pn = this.prop[i].trim();
                    String p = pn.toLowerCase();
                    Object data = map.get(p);
                    map2.put(pn, data);
                }
                list.add(map2);
            }
        }
    }
}

