/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSTransferLogInfo;
import com.kingdee.eas.csinterface.webservice.app.AbstractWSTransferLogControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WSTransferLogControllerBean
extends AbstractWSTransferLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.webservice.app.WSTransferLogControllerBean");
    private static final int maxLen = 4800;

    @Override
    protected void _log(Context ctx, WSTransferLogInfo wsTransferLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(wsTransferLogInfo);
        this._addnew(ctx, (IObjectPK)new ObjectUuidPK(wsTransferLogInfo.getId()), (IObjectValue)wsTransferLogInfo);
    }

    @Override
    protected void _updateLog(Context ctx, WSTransferLogInfo wsTransferLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(wsTransferLogInfo);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(wsTransferLogInfo.getId()), (IObjectValue)wsTransferLogInfo);
    }

    private void formatLogInfo(WSTransferLogInfo wsTransferLogInfo) {
        String returnData;
        String outgoingData;
        String incomingData;
        String errorMsg;
        if (null == wsTransferLogInfo) {
            return;
        }
        String stackTrace = wsTransferLogInfo.getStaceTrace();
        if (StringUtils.isEmpty((String)stackTrace)) {
            return;
        }
        if (stackTrace.length() > 4800) {
            stackTrace = stackTrace.substring(0, 4800);
            wsTransferLogInfo.setStaceTrace(stackTrace);
        }
        if (StringUtils.isEmpty((String)(errorMsg = wsTransferLogInfo.getErrorMsg()))) {
            return;
        }
        if (errorMsg.length() > 980) {
            errorMsg = errorMsg.substring(0, 980);
            wsTransferLogInfo.setErrorMsg(errorMsg);
        }
        if (StringUtils.isEmpty((String)(incomingData = wsTransferLogInfo.getIncomingData()))) {
            return;
        }
        if (incomingData.length() > 4800) {
            incomingData = incomingData.substring(0, 4800) + "\u2026";
            wsTransferLogInfo.setIncomingData(incomingData);
        }
        if (StringUtils.isEmpty((String)(outgoingData = wsTransferLogInfo.getOutgoingData()))) {
            return;
        }
        if (outgoingData.length() > 4800) {
            outgoingData = outgoingData.substring(0, 4800) + "\u2026";
            wsTransferLogInfo.setOutgoingData(outgoingData);
        }
        if (StringUtils.isEmpty((String)(returnData = wsTransferLogInfo.getReturnData()))) {
            return;
        }
        if (returnData.length() > 4800) {
            returnData = returnData.substring(0, 4800) + "\u2026";
            wsTransferLogInfo.setReturnData(returnData);
        }
    }
}

