/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceFactory;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.constant.WSConstant;
import com.kingdee.eas.csinterface.webservice.app.handler.user.AbstractUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.IERPUserHandler;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class EASBaseDataSynUserHandler
extends AbstractUserHandler {
    private static Logger logger = Logger.getLogger(IERPUserHandler.class);
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static Map<String, String> login(Context ctx, BaseDataSynWebServiceInfo webserviceInfo) throws BOSException {
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        StringBuffer buff = new StringBuffer();
        String host = EASBaseDataSynUserHandler.getHost(webserviceInfo);
        buff.append(host).append("/easportal/eip").append("/webAPI/login");
        String bodyStr = "";
        String userName = webserviceInfo.getUserName();
        try {
            bodyMap.put("language", webserviceInfo.getLanguage() == null ? "" : webserviceInfo.getLanguage().getValue());
            bodyMap.put("dcName", webserviceInfo.getDataCenter());
            bodyMap.put("user", userName);
            bodyMap.put("password", webserviceInfo.getPassword());
            bodyStr = JSONObject.toJSONString(bodyMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(buff.toString(), null, bodyStr, JsonNode.class);
        }
        catch (BOSException e) {
            logger.error((Object)(buff + "login fail:"), (Throwable)e);
            throw new BOSException(buff + "login fail:", (Throwable)e);
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            logger.error((Object)resultObj.get("message"));
            throw new BOSException("url " + buff + " login fail " + resultObj.get("message"));
        }
        String tokenValue = resultObj.findValue("token").getTextValue();
        tokenMap.put(host, tokenValue);
        tokenMap.put(tokenValue, String.valueOf(System.currentTimeMillis()));
        return null;
    }

    private static BaseDataSynWebServiceInfo getWebService(Context ctx) throws BOSException {
        BaseDataSynWebServiceInfo webserviceInfo = null;
        String webserviceId = "";
        try {
            webserviceId = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getExtendedProperty("webserviceId");
            if (!StringUtil.isEmpty((String)webserviceId)) {
                webserviceInfo = BaseDataSynWebServiceFactory.getLocalInstance(ctx).getBaseDataSynWebServiceInfo("select webAddress,port,edition,userName,password,language,dataCenter where id ='" + webserviceId + "'");
            }
        }
        catch (Exception e) {
            logger.error((Object)("EIP:baseDataSynWebService found error[id='" + webserviceId + "']"));
            throw new BOSException("EIP:baseDataSynWebService found error[id='" + webserviceId + "']", (Throwable)e);
        }
        return webserviceInfo;
    }

    private static String getHost(BaseDataSynWebServiceInfo wsserviceInfo) {
        StringBuffer url = new StringBuffer();
        url.append(wsserviceInfo.getWebAddress()).append(":").append(wsserviceInfo.getPort()).append(wsserviceInfo.getDataCenter());
        return url.toString();
    }

    private static String getToken(Context ctx, BaseDataSynWebServiceInfo webserviceInfo) throws BOSException {
        String token = "";
        String serverKey = EASBaseDataSynUserHandler.getHost(webserviceInfo);
        try {
            if (tokenMap != null && tokenMap.size() != 0 && !StringUtils.isEmpty((String)tokenMap.get(serverKey))) {
                String str = tokenMap.get(serverKey);
                if (System.currentTimeMillis() - Long.valueOf(tokenMap.get(str)) > 600000L) {
                    tokenMap.remove(str);
                    tokenMap.remove(serverKey);
                    EASBaseDataSynUserHandler.login(ctx, webserviceInfo);
                }
                token = tokenMap.get(serverKey);
            } else {
                EASBaseDataSynUserHandler.login(ctx, webserviceInfo);
                token = tokenMap.get(serverKey);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("EIP:seek token fail[id:'" + webserviceInfo.getId().toString() + "']"));
            throw new BOSException("EIP:seek token fail[id:'" + webserviceInfo.getId().toString() + "']", (Throwable)e);
        }
        return token;
    }

    public static String sendDataToEasforAdd2Update(Context ctx, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> colType, String method) throws BOSException {
        int i;
        BaseDataSynWebServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASBaseDataSynUserHandler.getWebService(ctx);
        String token = EASBaseDataSynUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        StringBuffer columnsBuff = new StringBuffer();
        ColumnModel model = null;
        if ("1".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                }
                columnsBuff.append(model.destName).append(",");
            }
        }
        if ("2".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                    continue;
                }
                columnsBuff.append(model.destName).append(",");
            }
            columnsBuff.append(mainPK).append(",");
        }
        columnsBuff.deleteCharAt(columnsBuff.length() - 1);
        bodyMap.put("tableName", tableName);
        bodyMap.put("columns", columnsBuff.toString());
        bodyMap.put("dataList", JSONObject.toJSONString(dataList));
        bodyMap.put("columnType", JSONObject.toJSONString(colType));
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASBaseDataSynUserHandler.getHost(sendService) + "/easportal/eip" + "/webAPI/baseDataService";
        JsonNode resultObj = null;
        try {
            String str = token + WSConstant.getEntryKey(ctx);
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            logger.error(resultObj);
            returnValue = resultObj.findValue("message").getTextValue();
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static String sendDataToEasQuery(Context ctx, List<String[]> checkList, String tableName, String mainPK, String oppValue, Map<String, String> colType, String method) throws BOSException {
        BaseDataSynWebServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        JsonNode resultObj = null;
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASBaseDataSynUserHandler.getWebService(ctx);
        String token = EASBaseDataSynUserHandler.getToken(ctx, sendService);
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException();
        }
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", JSONObject.toJSONString((Object)tableName));
        bodyMap.put("dataList", JSONObject.toJSONString(checkList));
        bodyMap.put("columnType", JSONObject.toJSONString(colType));
        bodyMap.put("columns", oppValue);
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASBaseDataSynUserHandler.getHost(sendService) + "/easportal/eip" + "/webAPI/baseDataService";
        try {
            String str = token + WSConstant.getEntryKey(ctx);
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            returnValue = resultObj.findValue("message").getTextValue();
            logger.error((Object)returnValue);
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static String sendDataToEasForDel(Context ctx, String idstr, String tableName, String mainPK, String method) throws BOSException {
        BaseDataSynWebServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASBaseDataSynUserHandler.getWebService(ctx);
        String token = EASBaseDataSynUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", tableName);
        bodyMap.put("dataList", JSONObject.toJSONString((Object)idstr));
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASBaseDataSynUserHandler.getHost(sendService) + "/easportal/eip" + "/webAPI/baseDataService";
        JsonNode resultObj = null;
        try {
            String str = token + WSConstant.getEntryKey(ctx);
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            returnValue = resultObj.findValue("message").getTextValue();
            logger.error((Object)returnValue);
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static String sendDataToEASForDataStructure(Context ctx, String tableName, String method, BaseDataSynWebServiceInfo sendService) throws BOSException {
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        if (sendService == null) {
            sendService = EASBaseDataSynUserHandler.getWebService(ctx);
        }
        String token = EASBaseDataSynUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", tableName);
        sendDataUrl = EASBaseDataSynUserHandler.getHost(sendService) + "/easportal/eip" + "/webAPI/baseDataService";
        JsonNode resultObj = null;
        try {
            String str = token + WSConstant.getEntryKey(ctx);
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            returnValue = resultObj.findValue("message").getTextValue();
            logger.error((Object)returnValue);
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static JsonNode baseWebSendDataToEasForDel(Context ctx, String idstr, String tableName, String mainPK, String method) throws BOSException {
        BaseDataSynWebServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASBaseDataSynUserHandler.getWebService(ctx);
        String token = EASBaseDataSynUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", tableName);
        bodyMap.put("dataList", JSONObject.toJSONString((Object)idstr));
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASBaseDataSynUserHandler.getHost(sendService) + "/easportal/eip" + "/webAPI/baseDataService";
        JsonNode resultObj = null;
        try {
            String str = token + WSConstant.getEntryKey(ctx);
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("");
        return resultObj;
    }
}

