/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.demo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.eas.csinterface.webservice.framework.ServiceURLUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class IERPLoginUtil {
    private static Logger logger = Logger.getLogger(IERPLoginUtil.class);
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static Map<String, String> login(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String loginURL = "http://localhost:8080/ierp/api/login.do";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("api", "true");
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("openid", serviceInfo.getOpenId());
        bodyMap.put("tenantid", serviceInfo.getDataCenter());
        JSONObject bodyJSON = new JSONObject();
        JSONArray numbers = new JSONArray();
        numbers.add((Object)"CNY");
        numbers.add((Object)"HKD");
        numbers.add((Object)"USD");
        bodyJSON.put("numbers", (Object)numbers);
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(loginURL, headerMap, bodyJSON.toJSONString(), JsonNode.class);
        }
        catch (BOSException e) {
            throw new BOSException(loginURL + "login fail:", (Throwable)e);
        }
        String accessToken = null;
        if (resultObj == null || !"success".equalsIgnoreCase(resultObj.get("state").getTextValue())) {
            logger.error((Object)resultObj.get("errorMsg"));
            throw new BOSException("url " + loginURL + " login fail " + resultObj.get("errorMsg"));
        }
        accessToken = resultObj.findValue("access_token").getTextValue();
        tokenMap.put(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo), accessToken);
        logger.info((Object)(new Date() + " --- IERPLoginUtil.login response: accessToken=" + accessToken));
        return tokenMap;
    }

    public static String getToken(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String token = tokenMap.get(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo));
        if (token == null) {
            IERPLoginUtil.login(ctx, serviceInfo);
            token = IERPLoginUtil.getToken(ctx, serviceInfo);
        }
        return token;
    }

    public static boolean needRelogin(Context ctx, WSServiceInfo serviceInfo, Map resultMap) throws BOSException {
        boolean isNotLogin = IERPLoginUtil.isNotLogin(resultMap);
        if (isNotLogin) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IERPLoginUtil.login(ctx, serviceInfo);
            return true;
        }
        return false;
    }

    public static boolean isNotLogin(Object returnData) {
        if (returnData == null) {
            return false;
        }
        Object errorCode = ((Map)returnData).get("error_code");
        return errorCode != null && "1".equals(errorCode.toString());
    }

    public static String getCacheTokenKey(Context ctx, WSServiceInfo serviceInfo) {
        return ServiceURLUtil.getHost(serviceInfo) + serviceInfo.getOpenId();
    }
}

