/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.webservice;

import java.net.URL;
import java.text.MessageFormat;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.description.OperationDesc;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceUtils.class);

    public static String messageFormat(String pattern, Object ... arguments) {
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (Exception e) {
            return pattern;
        }
    }

    public static Object getObjectByAxisCallClient(String webServiceAddr, String webServiceMethod, String soapActionURI, String targetNamespace, int timeout, Object[] inputValues, String[] inputNames, String[] inputXmlTypes, Class<?>[] inputJavaTypes) throws Exception {
        return WebServiceUtils.getObjectByAxisCallClient(webServiceAddr, webServiceMethod, soapActionURI, targetNamespace, timeout, inputValues, inputNames, inputXmlTypes, inputJavaTypes, null, null);
    }

    public static Object getObjectByAxisCallClient(String webServiceAddr, String webServiceMethod, String soapActionURI, String targetNamespace, int timeout, Object[] inputValues, String[] inputNames, String[] inputXmlTypes, Class<?>[] inputJavaTypes, String username, String password) throws Exception {
        Object resObj = null;
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(webServiceAddr));
            call.setUseSOAPAction(true);
            call.setOperationName(webServiceMethod);
            OperationDesc oper = new OperationDesc();
            if (!ArrayUtils.isEmpty((Object[])inputNames)) {
                for (int i = 0; i < inputNames.length; ++i) {
                    oper.addParameter(new QName(targetNamespace, inputNames[i]), new QName(targetNamespace, inputXmlTypes[i]), inputJavaTypes[i], (byte)1, false, false);
                }
            }
            call.setOperation(oper);
            if (timeout > 0) {
                call.setTimeout(Integer.valueOf(timeout));
            }
            if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                call.setUsername(username);
                call.setPassword(password);
            }
            resObj = call.invoke(inputValues);
        }
        catch (Exception e) {
            String message = WebServiceUtils.messageFormat("\u4f7f\u7528AxisCallClient\u8c03\u7528WebService\u5730\u5740\uff5b{0}\uff5d\u65b9\u6cd5\uff5b{1}\uff5d\u51fa\u73b0\u9519\u8bef\uff01", webServiceAddr, webServiceMethod);
            logger.error(message, (Throwable)e);
            throw e;
        }
        return resObj;
    }
}

