/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.model.util;

public class JsonFormatUtil {
    private static String SPACE = "   ";

    public static String beautyJSON(String json) {
        if (json == null || json.length() <= 2) {
            return json;
        }
        json = json.replaceAll("\\s{4,}", "");
        json = json.replaceAll("\\\\n", "");
        json = json.replaceAll("\\\\t", "");
        return json;
    }

    public static String formatJson(String json) {
        if (json == null || json.length() <= 2) {
            return json;
        }
        json = JsonFormatUtil.beautyJSON(json);
        json = json.replaceAll("\\\\\"", "\"");
        StringBuffer result = new StringBuffer();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(JsonFormatUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(JsonFormatUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(JsonFormatUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            if (key == ',') {
                result.append(key);
                result.append('\n');
                result.append(JsonFormatUtil.indent(number));
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        JsonFormatUtil json = new JsonFormatUtil();
        String str = "{'age':23,'aihao':['pashan','movies'],  'name':{'firstName':'zhang','lastName':'san','aihao':['pashan','movies','name':{'firstName':'zhang','lastName':'san','aihao':['pashan','movies']}]}}";
        String result = JsonFormatUtil.formatJson(str);
        System.out.println(result);
    }
}

