/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ep.UpgradeCollection;
import com.kingdee.eas.ep.UpgradeInfo;
import com.kingdee.eas.ep.app.AbstractUpgradeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import org.apache.log4j.Logger;

public class UpgradeControllerBean
extends AbstractUpgradeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ep.app.UpgradeControllerBean");

    private UpgradeCollection geProperCollection(Context ctx, int startVersion, int targetVersion) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo startFilter = new FilterItemInfo("startVersion", (Object)new Integer(startVersion), CompareType.EQUALS);
        FilterItemInfo targetFilter = new FilterItemInfo("targetVersion", (Object)new Integer(targetVersion), CompareType.EQUALS);
        startFilter.setCompareType(CompareType.GREATER_EQUALS);
        targetFilter.setCompareType(CompareType.LESS_EQUALS);
        filter.getFilterItems().add(startFilter);
        filter.getFilterItems().add(targetFilter);
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("startVersion"));
        SorterItemInfo sorterItem = new SorterItemInfo("targetVersion");
        sorterItem.setSortType(SortType.DESCEND);
        sorters.add(sorterItem);
        view.setSorter(sorters);
        CoreBaseCollection collection = this.getCollection(ctx, view);
        UpgradeCollection col = new UpgradeCollection();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            UpgradeInfo grade = (UpgradeInfo)collection.getObject(i);
            if (grade.getTargetVersion() <= grade.getStartVersion()) continue;
            col.add(grade);
        }
        return col;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, int startVersion, int targetVersion) throws BOSException {
        UpgradeCollection collection = this.geProperCollection(ctx, startVersion, targetVersion);
        if (collection != null) {
            WayFinder wayFinder = new WayFinder();
            wayFinder.setChoices(collection);
            wayFinder.setStart(startVersion);
            wayFinder.setTarget(targetVersion);
            return wayFinder.findWay();
        }
        return null;
    }

    class WayFinder {
        UpgradeCollection choices;
        int start;
        int target;
        UpgradeCollection bestway;

        WayFinder() {
        }

        UpgradeCollection findWay() {
            UpgradeCollection col = this.findByStartVersion(this.choices, this.start);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                this.findWay(col.get(i), new UpgradeCollection());
            }
            return this.bestway;
        }

        private void findWay(UpgradeInfo current, UpgradeCollection way) {
            way.add(current);
            if (current.getTargetVersion() == this.target) {
                this.recalculatedBestWay(way);
                return;
            }
            if (this.bestway == null || way.size() < this.bestway.size()) {
                UpgradeCollection nexts = this.getNextRecord(this.choices, current);
                int n = nexts.size();
                for (int i = 0; i < n; ++i) {
                    this.findWay(nexts.get(i), (UpgradeCollection)((Object)way.clone()));
                }
            }
        }

        private void recalculatedBestWay(UpgradeCollection way) {
            if (this.bestway == null || way.size() < this.bestway.size()) {
                this.bestway = way;
            }
        }

        private UpgradeCollection getNextRecord(UpgradeCollection choices, UpgradeInfo current) {
            int startVersion = current.getTargetVersion();
            return this.findByStartVersion(choices, startVersion);
        }

        private UpgradeCollection findByStartVersion(UpgradeCollection choices, int startVersion) {
            UpgradeCollection result = new UpgradeCollection();
            int n = choices.size();
            for (int i = 0; i < n; ++i) {
                if (choices.get(i).getStartVersion() != startVersion) continue;
                result.add(choices.get(i));
            }
            return result;
        }

        void setChoices(UpgradeCollection choices) {
            this.choices = choices;
        }

        void setStart(int start) {
            this.start = start;
        }

        void setTarget(int target) {
            this.target = target;
        }
    }
}

