/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.lightRemote;

import com.kingdee.eas.ep.lightRemote.DefaultContext;
import com.kingdee.eas.ep.lightRemote.RemoteContext;
import com.kingdee.eas.ep.lightRemote.RemoteEnv;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class RemoteServer
extends Thread {
    static final Logger logger = Logger.getLogger(RemoteServer.class);
    public static final int DEFAULT_PORT = 10080;
    public static final int STANDBY_PORT = 10088;
    public final ServerSocket server;
    private Map contexts = Collections.synchronizedMap(new HashMap());
    private RemoteContext lastContext = null;
    public volatile boolean closed = false;
    private volatile boolean started = false;

    public RemoteServer(int port) throws IOException {
        this.server = new ServerSocket(port);
    }

    public RemoteServer() throws IOException {
        this(10080);
    }

    protected void finalClose() {
        this.contexts.clear();
    }

    public synchronized void waitForStart() throws InterruptedException {
        while (!this.started) {
            this.wait();
        }
        Thread.sleep(1L);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finalClose();
    }

    @Override
    public String toString() {
        return "remote server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.info((Object)(this.toString() + "(" + this.server.getLocalPort() + ") started."));
            RemoteServer remoteServer = this;
            synchronized (remoteServer) {
                this.started = true;
                this.notifyAll();
            }
            while (true) {
                final Socket sock = this.server.accept();
                RemoteEnv.startThread(new Runnable(){

                    @Override
                    public void run() {
                        RemoteServer.this.accept(sock);
                    }
                });
            }
        }
        catch (Exception ex) {
            RemoteEnv.logException(logger, ex);
            return;
        }
    }

    protected RemoteContext createContext(Socket sock) throws Exception {
        return new DefaultContext(sock);
    }

    protected RemoteContext accept(Socket sock) {
        logger.info((Object)("new incoming connection " + sock));
        RemoteContext context = null;
        String ip = sock.getInetAddress().getHostAddress();
        try {
            context = this.createContext(sock);
            this.contexts.put(ip, context);
            this.lastContext = context;
            context.serviceLoop();
        }
        catch (Exception ex) {
            RemoteEnv.logException(logger, ex);
        }
        try {
            this.lastContext = null;
            this.contexts.remove(ip);
            sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)("close connection " + sock));
        return context;
    }

    public RemoteContext getContext(String clientIP) {
        return this.lastContext;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            new RemoteServer().run();
        }
        catch (Exception ex) {
            logger.error((Object)"RemoteServer.main", (Throwable)ex);
        }
    }
}

