/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.PlugInScriptInfo;
import com.kingdee.eas.ep.plugin.Logger4Script;
import com.kingdee.eas.ep.plugin.PluginCacheInfo;
import com.kingdee.eas.ep.plugin.PluginCacheSynFactory;
import com.kingdee.eas.ep.plugin.PluginPK;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PluginCache {
    private static final int MAX_CACHE_SIZE = 10240;
    private static final int DISCARD_CACHE_SIZE = 1024;
    private static final int INITIAL_CAPACITY = 1024;
    private static Map cache = Collections.synchronizedMap(new HashMap());
    private static Map metaCache = Collections.synchronizedMap(new HashMap());

    private PluginCache() {
    }

    public static void clearCache() {
        PluginCache.localClearCache();
        PluginCacheSynFactory.getInstance().clearCache();
    }

    protected static void localClearCache() {
        cache.clear();
        metaCache.clear();
    }

    public static void clearCache(String ais) {
        PluginCache.localClearCache(ais);
        PluginCacheSynFactory.getInstance().clearCache(ais);
    }

    protected static void localClearCache(String ais) {
        Map subCache = (Map)cache.get(ais);
        Set subMetaCache = (Set)metaCache.get(ais);
        if (subCache != null) {
            subCache.clear();
            cache.remove(ais);
            subMetaCache.clear();
            metaCache.remove(ais);
        }
    }

    private static PluginPK getPluginPK(Context ctx, String meta, ExtendPointInfo point) {
        String ais = null;
        if (ctx != null) {
            ais = ctx.getAIS();
        }
        PluginPK pk = new PluginPK(ais, meta, point);
        return pk;
    }

    public static void init(Context ctx) throws EASBizException, BOSException {
        String ais = ctx.getAIS();
        Map subCache = (Map)cache.get(ais);
        if (subCache != null) {
            return;
        }
        subCache = (Map)cache.get(ais);
        if (subCache == null) {
            cache.put(ais, new HashMap(1024));
            metaCache.put(ais, new HashSet());
            PlugInCollection col = PlugInFactory.getLocalInstance(ctx).getPlugin();
            PlugInInfo plugin = null;
            ExtendPointInfo point = null;
            String meta = null;
            PluginPK pk = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                plugin = col.get(i);
                point = plugin.getPoint();
                meta = plugin.getOwner();
                pk = PluginCache.getPluginPK(ctx, meta, point);
                PluginCache.putPlugin(ais, pk, plugin);
            }
        }
    }

    public static void reload(Context ctx, PlugInCollection col) throws EASBizException, BOSException {
        PluginCache.localReload(ctx, col);
        PluginCacheSynFactory.getInstance().reload(ctx, col);
    }

    protected static void localReload(Context ctx, PlugInCollection col) throws EASBizException, BOSException {
        if (col == null) {
            return;
        }
        String ais = ctx.getAIS();
        Map subCache = (Map)cache.get(ais);
        Set metaSubCache = (Set)metaCache.get(ais);
        if (subCache == null) {
            cache.put(ais, new HashMap(1024));
            metaCache.put(ais, new HashSet());
        } else {
            subCache.clear();
            metaSubCache.clear();
        }
        PlugInInfo plugin = null;
        ExtendPointInfo point = null;
        String meta = null;
        PluginPK pk = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            plugin = col.get(i);
            point = plugin.getPoint();
            meta = plugin.getOwner();
            pk = PluginCache.getPluginPK(ctx, meta, point);
            PluginCache.putPlugin(ais, pk, plugin);
        }
    }

    public static void reload(Context ctx, String meta, ExtendPointInfo point, PlugInCollection plugin) throws EASBizException, BOSException {
        PluginCache.localReload(ctx, meta, point, plugin);
        PluginCacheSynFactory.getInstance().reload(ctx, meta, point, plugin);
    }

    protected static void localReload(Context ctx, String meta, ExtendPointInfo point, PlugInCollection plugin) throws EASBizException, BOSException {
        String ais = ctx.getAIS();
        PluginPK pk = PluginCache.getPluginPK(ctx, meta, point);
        Map subCache = (Map)cache.get(ais);
        if (subCache == null) {
            return;
        }
        subCache.remove(pk);
        if (plugin != null && plugin.size() > 0) {
            Set subMetaCache = (Set)metaCache.get(ais);
            subCache.put(pk, new PluginCacheInfo(plugin));
            subMetaCache.add(pk.getMeta());
            if (subCache.size() >= 10240) {
                PluginCache.discardLongUnused(subCache);
            }
        }
    }

    private static void putPlugin(String ais, PluginPK pk, PlugInInfo plugin) {
        Map subCache = (Map)cache.get(ais);
        Set subMetaCache = (Set)metaCache.get(ais);
        PluginCacheInfo cacheInfo = (PluginCacheInfo)subCache.get(pk);
        PlugInCollection pCol = null;
        if (cacheInfo == null) {
            pCol = new PlugInCollection();
            subCache.put(pk, new PluginCacheInfo(pCol));
            subMetaCache.add(pk.getMeta());
            if (subCache.size() >= 10240) {
                PluginCache.discardLongUnused(subCache);
            }
        } else {
            pCol = cacheInfo.getPlugin();
        }
        pCol.add(plugin);
    }

    public static boolean isExtend(Context ctx, String meta) throws EASBizException, BOSException {
        PluginCache.init(ctx);
        String ais = ctx.getAIS();
        Set subMetaCache = (Set)metaCache.get(ais);
        if (subMetaCache == null) {
            return false;
        }
        return subMetaCache.contains(meta);
    }

    private static void reloadForGet(Context ctx, String meta, ExtendPointInfo point) throws EASBizException, BOSException {
        PlugInCollection plugin = PlugInFactory.getLocalInstance(ctx).getPlugIn(meta, point, false);
        PluginCache.localReload(ctx, meta, point, plugin);
    }

    public static PlugInCollection getPlugin(Context ctx, String meta, ExtendPointInfo point) throws EASBizException, BOSException {
        PluginCache.init(ctx);
        String ais = ctx.getAIS();
        Map subCache = (Map)cache.get(ais);
        if (subCache == null) {
            return null;
        }
        PluginPK pk = PluginCache.getPluginPK(ctx, meta, point);
        PluginCacheInfo cacheInfo = (PluginCacheInfo)subCache.get(pk);
        if (subCache.size() >= 10240 && cacheInfo == null) {
            PluginCache.reloadForGet(ctx, meta, point);
            cacheInfo = (PluginCacheInfo)subCache.get(pk);
        }
        PlugInCollection plugin = null;
        if (cacheInfo != null) {
            plugin = cacheInfo.getPlugin();
            cacheInfo.setLastAccessTime(System.currentTimeMillis());
        }
        return plugin;
    }

    public static void log(Context ctx) throws EASBizException, BOSException {
        PluginCache.init(ctx);
        String ais = ctx.getAIS();
        Map subCache = (Map)cache.get(ais);
        if (subCache == null) {
            return;
        }
        for (PluginPK pk : subCache.keySet()) {
            PluginCacheInfo cacheInfo = (PluginCacheInfo)subCache.get(pk);
            if (cacheInfo == null || pk == null) continue;
            Logger4Script.info(ctx, "+++ key:" + pk.toString());
            PlugInCollection plugin = null;
            plugin = cacheInfo.getPlugin();
            if (plugin == null) continue;
            PlugInInfo pInfo = null;
            int size = plugin.size();
            for (int i = 0; i < size; ++i) {
                pInfo = plugin.get(i);
                Logger4Script.info(ctx, "+++ Scheme ID:" + pInfo.getSchemeID());
                PlugInScriptInfo script = pInfo.getScriptBefore();
                if (script != null) {
                    Logger4Script.info(ctx, "+++ Script Before:\n" + script.getContent());
                }
                if ((script = pInfo.getScriptAfter()) == null) continue;
                Logger4Script.info(ctx, "+++ Script After:\n" + script.getContent());
            }
        }
    }

    private static void discardLongUnused(Map cache) {
        PluginPK pk = null;
        PluginCacheInfo cacheInfo = null;
        Object[] timeAndPKs = new UnusedTimePK[cache.size()];
        int index = 0;
        for (Map.Entry entry : cache.entrySet()) {
            pk = (PluginPK)entry.getKey();
            cacheInfo = (PluginCacheInfo)entry.getValue();
            timeAndPKs[index++] = new UnusedTimePK(System.currentTimeMillis() - cacheInfo.getLastAccessTime(), pk);
        }
        Arrays.sort(timeAndPKs);
        int size = timeAndPKs.length > 1024 ? 1024 : timeAndPKs.length;
        for (int i = 0; i < size; ++i) {
            cache.remove(((UnusedTimePK)timeAndPKs[i]).pk);
        }
    }

    static class UnusedTimePK
    implements Comparable {
        final long unusedTime;
        final PluginPK pk;

        UnusedTimePK(long unusedTime, PluginPK pk) {
            this.unusedTime = unusedTime;
            this.pk = pk;
        }

        public int compareTo(Object o) {
            UnusedTimePK another = (UnusedTimePK)o;
            if (this.unusedTime > another.unusedTime) {
                return -1;
            }
            if (this.unusedTime < another.unusedTime) {
                return 1;
            }
            return 0;
        }
    }
}

