/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.PluginServiceUtil;
import com.kingdee.eas.ep.plugin.ExtendMethodInfo;
import com.kingdee.eas.ep.plugin.IPluginService;
import com.kingdee.eas.ep.plugin.PluginUtils;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PluginServiceAdaptor
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static final Logger logger = Logger.getLogger(PluginServiceAdaptor.class);
    private static final String PLUGIN_SERVICE = "PLUGIN_SERVICE_EP";
    private static final int PLUGIN_PRIORITY = 200;
    private List services = new ArrayList();

    public void registerPluginService(IPluginService service) {
        this.services.add(service);
    }

    public void clearPluginService() {
        this.services.clear();
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (serviceContext == null || this.services.isEmpty()) {
            return;
        }
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        BOSObjectType boType = serviceContext.getBoType();
        IPluginService service = null;
        boolean isIgnore = true;
        int size = this.services.size();
        for (int i = 0; i < size; ++i) {
            service = (IPluginService)this.services.get(i);
            isIgnore = isIgnore && service.isIgnore(boType);
        }
        if (isIgnore) {
            return;
        }
        Context ctx = serviceContext.getContext();
        BOSObjectType metaType = serviceContext.getMetaType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        BusinessObjectInfo bo = this.getMetaData(ctx, metaType, boType);
        if (bo == null || bo.getFullName() == null) {
            return;
        }
        try {
            String meta = bo.getFullName();
            boolean isExtend = false;
            int size2 = this.services.size();
            for (int i = 0; i < size2; ++i) {
                service = (IPluginService)this.services.get(i);
                isExtend = isExtend || service.isExtend(ctx, meta);
            }
            if (!isExtend) {
                return;
            }
            MethodInfo method = this.getMethod(bo, operationPK);
            if (method == null) {
                return;
            }
            ExtendMethodInfo mInfo = PluginUtils.getExtendMethodInfo(method, serviceContext.getOperationParameters());
            mInfo.setResultValue(serviceContext.getMethodReturnValue());
            if (serviceContext.getExecutionMode() == 0) {
                PluginServiceUtil.beforePluginService(this.services, boType, ctx, meta, mInfo, serviceContext);
            } else if (serviceContext.getExecutionMode() == 1) {
                for (int i = this.services.size() - 1; i >= 0; --i) {
                    service = (IPluginService)this.services.get(i);
                    if (service.isIgnore(boType)) continue;
                    service.processAfter(ctx, meta, mInfo);
                }
            }
            serviceContext.setMethodReturnValue(mInfo.getResultValue());
        }
        catch (EASBizException e) {
            logger.error((Object)"PlugIn Execute Exceptoin:", (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("PlugIn execute():  " + (endTime - beginTime)));
        }
    }

    private BusinessObjectInfo getMetaData(Context ctx, BOSObjectType metaType, BOSObjectType boType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = null;
        if (MetaDataTypeList.ENTITY.equals((Object)metaType)) {
            bo = loader.getEntity(boType);
        } else if (MetaDataTypeList.FACADE.equals((Object)metaType)) {
            bo = loader.getFacade(boType);
        }
        return bo;
    }

    private MethodInfo getMethod(BusinessObjectInfo bo, IMetaDataPK operationPK) {
        if (bo == null || operationPK == null) {
            return null;
        }
        MethodCollection methods = bo.getAllMethodsRuntime();
        for (int i = 0; i < methods.size(); ++i) {
            if (!operationPK.toString().equalsIgnoreCase(methods.get(i).getInnerID())) continue;
            return methods.get(i);
        }
        return null;
    }

    public String getName() {
        return PLUGIN_SERVICE;
    }

    public int getPriority() {
        return 200;
    }
}

