/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.updater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataCollection;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.config.listener.CommonListenerManager;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.updater.UtilsForUpdate;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateToSP2 {
    private static Logger logger = CoreUIObject.getLogger(UpdateToSP2.class);
    private static final String UIOBJECT_TYPE = "uioj";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Context ctx) {
        try {
            IDynamicMetadata dynamic = DynamicMetadataFactory.getLocalInstance((Context)ctx);
            DynamicMetadataCollection collection = dynamic.getCollection();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicMetadataInfo metadataInfo = collection.get(i);
                String bosType = metadataInfo.getBosType();
                if (!UIOBJECT_TYPE.equals(bosType)) continue;
                String projectID = metadataInfo.getProjectID();
                String metaDataPK = metadataInfo.getMetaDataPK();
                UpdateToSP2.updateUIObject(ctx, metaDataPK, projectID);
            }
        }
        catch (BOSException e) {
            logger.error((Object)(UpdateToSP2.class.getName() + " : error when get dynamicMetadata"));
        }
        finally {
            try {
                CommonListenerManager.disable((Context)ctx, (String)UpdateToSP2.class.getName(), (String)"update");
            }
            catch (BOSException e) {
                logger.error((Object)"UpdateToSP2.update", (Throwable)e);
            }
        }
    }

    private static boolean updateUIObject(Context ctx, String metadataPK, String projectId) {
        if (StringUtils.isEmpty((String)metadataPK) || StringUtils.isEmpty((String)projectId)) {
            return false;
        }
        try {
            MetaDataPK pk = new MetaDataPK(metadataPK);
            Project depend = new Project();
            depend.setId(projectId);
            UIObjectInfo ui = UtilsForUpdate.loadUI((IMetaDataPK)pk, depend, ctx);
            if (!ui.isAssembled()) {
                ui = UIObjectAssembler.assembleUI((Context)ctx, (UIObjectInfo)ui);
            }
            UpdateToSP2.updateUIObject(ctx, ui, depend);
            UtilsForUpdate.saveMetadata((AbstractMetaDataValue)ui, projectId, null, ctx);
        }
        catch (Exception e) {
            logger.error((Object)(UpdateToSP2.class.getName() + " : error when update " + metadataPK));
            logger.error((Object)e.getLocalizedMessage());
            return false;
        }
        logger.error((Object)(UpdateToSP2.class.getName() + " : success update " + metadataPK));
        return true;
    }

    static void updateUIObject(Context ctx, UIObjectInfo uiobj, Project depend) {
        HashMap<String, EntityObjectInfo> bindEntitys = new HashMap<String, EntityObjectInfo>();
        DataObjectCollection dataObjects = uiobj.getDataObjects();
        int n = dataObjects.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity;
            DataObjectInfo dataObjectInfo = dataObjects.get(i);
            String type = dataObjectInfo.getObjectType();
            if (!MetaDataTypeList.ENTITY.toString().equals(type) || UtilsForUpdate.isEmptyMD((AbstractMDValue)(entity = UtilsForUpdate.loadEntity((IMetaDataPK)MetaDataPK.create((String)dataObjectInfo.getType()), depend, ctx)))) continue;
            bindEntitys.put(dataObjectInfo.getName(), entity);
        }
        if (bindEntitys.size() < 1) {
            logger.error((Object)(UpdateToSP2.class.getName() + " : bind Entitys is empty , don't need to update " + uiobj.getFullName()));
        }
        ComponentInfo mainPanel = uiobj.getMainPanelComponent();
        UpdateToSP2.resetComponent(ctx, bindEntitys, mainPanel);
    }

    private static void resetComponent(Context ctx, Map entities, ComponentInfo component) {
        block10: {
            try {
                PropertyBindingInfo propertyBindingInfo;
                int i;
                int n;
                PropertyBindingCollection propertyBindings;
                if (component == null) break block10;
                String classType = component.getClassType();
                if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType)) {
                    UpdateToSP2.extractPropertyToTable(ctx, component, entities);
                } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(component.getClassType())) {
                    propertyBindings = component.getPropertyBindings();
                    n = propertyBindings.size();
                    for (i = 0; i < n; ++i) {
                        propertyBindingInfo = propertyBindings.get(i);
                        if (!"data".equals(propertyBindingInfo.getPropertyName())) continue;
                        UpdateToSP2.extractPropertyToComponentInfo(ctx, component, propertyBindingInfo, entities);
                        break;
                    }
                } else if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(component.getClassType())) {
                    propertyBindings = component.getPropertyBindings();
                    n = propertyBindings.size();
                    for (i = 0; i < n; ++i) {
                        propertyBindingInfo = propertyBindings.get(i);
                        if (!"selectedIndex".equalsIgnoreCase(propertyBindingInfo.getPropertyName()) && !"selecteditem".equalsIgnoreCase(propertyBindingInfo.getPropertyName())) continue;
                        UpdateToSP2.extractPropertyToComponentInfo(ctx, component, propertyBindingInfo, entities);
                        break;
                    }
                }
                ComponentCollection components = component.getComponents();
                n = components.size();
                for (i = 0; i < n; ++i) {
                    ComponentInfo componentInfo = components.get(i);
                    UpdateToSP2.resetComponent(ctx, entities, componentInfo);
                }
            }
            catch (Exception e) {
                logger.error((Object)(UpdateToSP2.class.getName() + " : error when update component" + component.getName()));
            }
        }
    }

    private static void extractPropertyToComponentInfo(Context ctx, ComponentInfo cInfo, PropertyBindingInfo bindInfo, Map entities) {
        if (cInfo == null || bindInfo == null || entities.size() < 1) {
            return;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            cInfo.removeExtendedProperty("enumclassname");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("defaultF7Query");
            cInfo.removeExtendedProperty("f7UsedListUIClassName");
            return;
        }
        EntityObjectInfo bindEntity = (EntityObjectInfo)entities.get(bindingObject);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = UpdateToSP2.getPropertyByName(bindEntity, bindField);
        if (prop == null) {
            cInfo.removeExtendedProperty("enumclassname");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("defaultF7Query");
            cInfo.removeExtendedProperty("f7UsedListUIClassName");
            return;
        }
        if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(cInfo.getClassType())) {
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProperty = (OwnPropertyInfo)prop;
                if (ownProperty.getDataType() == DataType.ENUM) {
                    BizEnumInfo enumInfo = ((OwnPropertyInfo)prop).getEnumType();
                    if (enumInfo != null) {
                        cInfo.setExtendedProperty("enumclassname", enumInfo.getClassName());
                        cInfo.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
                    }
                } else {
                    com.kingdee.bos.metadata.data.ColumnInfo mappingField = UpdateToSP2.getMappingField(prop);
                    if (mappingField != null) {
                        cInfo.setExtendedProperty("bindpropertytype", mappingField.getTypeName().getName());
                    }
                }
            }
        } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(cInfo.getClassType())) {
            if (prop instanceof LinkPropertyInfo) {
                String f7ListUIName;
                RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                if (relationShip == null || relationShip.getSupplierObject() == null) {
                    return;
                }
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (!StringUtils.isEmpty((String)sQueryPK)) {
                    cInfo.setExtendedProperty("defaultF7Query", sQueryPK);
                }
                if (!StringUtils.isEmpty((String)(f7ListUIName = supplyEntityInfo.getExtendedProperty("f7UsedListUIClassName")))) {
                    cInfo.setExtendedProperty("f7UsedListUIClassName", f7ListUIName);
                }
            }
        } else if (("com.kingdee.bos.ctrl.swing.KDBusiCurrencyField".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(cInfo.getClassType())) && prop instanceof OwnPropertyInfo && DataType.DECIMAL.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
            int pr = -1;
            String bdt = prop.getExtendedProperty("bizDataType");
            pr = BizDataType.AMOUNT.getName().equals(bdt) ? 2 : (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt) ? 4 : ((OwnPropertyInfo)prop).getDecimalDigits());
            if (pr >= 0) {
                PropertyCollection pcol = cInfo.getProperties();
                PropertyInfo precision = new PropertyInfo();
                precision.setName("precision");
                precision.setType("int");
                precision.setValue(String.valueOf(pr));
                precision.setOverride(true);
                pcol.add(precision);
            }
        }
    }

    private static void extractPropertyToTable(Context ctx, ComponentInfo cInfo, Map entities) {
        if (cInfo == null || entities.size() < 1) {
            return;
        }
        PropertyInfo property = cInfo.getProperties().get("formatXml");
        if (property == null) {
            return;
        }
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        String formatXmlExt = cInfo.getExtendedProperty("extend_formatxml");
        TableInfoHelper.parseFormatXmlExt((TableInfo)tableInfo, (String)formatXmlExt);
        PropertyBindingCollection propertyBindings = cInfo.getPropertyBindings();
        int n = propertyBindings.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo bindInfo = propertyBindings.get(i);
            String propertyName = bindInfo.getPropertyName();
            if (StringUtils.isEmpty((String)propertyName) || !propertyName.endsWith(".text")) continue;
            try {
                String f7ListUIName;
                RelationshipInfo relationShip;
                String columnName;
                String bindingObject = bindInfo.getBindingObject();
                String bindField = bindInfo.getBingdingField();
                if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)(columnName = StringUtils.replace((String)propertyName, (String)".text", (String)"")))) continue;
                List columns = tableInfo.getColumns();
                ColumnInfo column = null;
                int k = columns.size();
                for (int j = 0; j < k && !columnName.equalsIgnoreCase((column = (ColumnInfo)columns.get(j)).getName()); ++j) {
                }
                if (column == null) continue;
                EntityObjectInfo bindEntity = (EntityObjectInfo)entities.get(bindingObject);
                com.kingdee.bos.metadata.entity.PropertyInfo prop = UpdateToSP2.getPropertyByName(bindEntity, bindField);
                if (prop == null) {
                    column.removeExtendedProperty("enumclassname");
                    column.removeExtendedProperty("bindpropertytype");
                    column.removeExtendedProperty("defaultF7Query");
                    column.removeExtendedProperty("f7UsedListUIClassName");
                    continue;
                }
                if (prop instanceof OwnPropertyInfo) {
                    if (((OwnPropertyInfo)prop).getDataType() == DataType.ENUM) {
                        BizEnumInfo enumInfo = ((OwnPropertyInfo)prop).getEnumType();
                        if (enumInfo == null) continue;
                        column.setExtendedProperty("enumclassname", enumInfo.getClassName());
                        column.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
                        continue;
                    }
                    if (DataType.BOOLEAN.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                        column.setExtendedProperty("bindpropertytype", DataType.BOOLEAN.getName());
                        continue;
                    }
                    com.kingdee.bos.metadata.data.ColumnInfo mappingField = UpdateToSP2.getMappingField(prop);
                    if (mappingField != null) {
                        column.setExtendedProperty("bindpropertytype", mappingField.getTypeName().getName());
                    }
                    if (!DataType.DECIMAL.equals((Object)((OwnPropertyInfo)prop).getDataType())) continue;
                    int pr = -1;
                    String bdt = prop.getExtendedProperty("bizDataType");
                    pr = BizDataType.AMOUNT.getName().equals(bdt) ? 2 : (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt) ? 4 : ((OwnPropertyInfo)prop).getDecimalDigits());
                    if (pr < 0) continue;
                    column.setExtendedProperty("precision", String.valueOf(pr));
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo) || (relationShip = ((LinkPropertyInfo)prop).getRelationship()) == null || relationShip.getSupplierObject() == null) continue;
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (!StringUtils.isEmpty((String)sQueryPK)) {
                    column.setExtendedProperty("defaultF7Query", sQueryPK);
                }
                if (StringUtils.isEmpty((String)(f7ListUIName = supplyEntityInfo.getExtendedProperty("f7UsedListUIClassName")))) continue;
                column.setExtendedProperty("f7UsedListUIClassName", f7ListUIName);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"UpdateToSP2.extractPropertyToTable", (Throwable)e);
                logger.error((Object)e.getMessage());
            }
        }
        formatXmlExt = TableInfoHelper.toFormatXmlExt((TableInfo)tableInfo);
        cInfo.setExtendedProperty("extend_formatxml", formatXmlExt);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null; ++i) {
            if (prop instanceof OwnPropertyInfo) {
                if (i == n - 1) break;
                prop = null;
                break;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    private static com.kingdee.bos.metadata.data.ColumnInfo getMappingField(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop.getMappingField() != null) {
            return prop.getMappingField();
        }
        if (prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return null;
    }

    public EntityObjectInfo getBindEntity(AbstractUIObjectInfo uiModel, String entityName) {
        DataObjectCollection col = uiModel.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!doInfo.getName().equals(entityName) || !doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) continue;
                MetaDataPK entitypk = new MetaDataPK(doInfo.getType());
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                EntityObjectInfo bindEntity = loader.getEntity((IMetaDataPK)entitypk);
                return bindEntity;
            }
        }
        return null;
    }
}

