/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDIntTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebCreateAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponentHelper;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NewWebCtrlDialog
extends CoreUIObject {
    protected static final Logger logger = CoreUIObject.getLogger(NewWebCtrlDialog.class);
    protected KDLabelContainer lblName;
    protected KDLabelContainer lblMaxLength;
    protected KDTextField txtName;
    protected KDIntTextField txtMaxLength;
    protected KDButton btnConfirm;
    protected KDButton btnCancel;
    protected KDLabelContainer lblLabelText;
    protected KDTextField txtLabelText;
    protected KDCheckBox chkMultiLan;
    protected WebUIObjectInfo uiModel;
    protected ComponentInfo newCtrl;
    protected WebTreeNode node;
    protected String classType;
    protected boolean isSupportML;
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";

    public NewWebCtrlDialog() throws Exception {
        this.jbInit();
        this.initUIP();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("Owner") instanceof WebCreateAction) {
            this.lblMaxLength.setVisible(false);
        }
        this.chkMultiLan.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setUITitle("\u65b0\u589e\u5b57\u6bb5\u63a7\u4ef6");
        this.lblName = new KDLabelContainer();
        this.lblMaxLength = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.txtMaxLength = new KDIntTextField();
        this.btnConfirm = new KDButton();
        this.btnCancel = new KDButton();
        this.lblLabelText = new KDLabelContainer();
        this.txtLabelText = new KDTextField();
        this.chkMultiLan = new KDCheckBox();
        this.lblName.setName("lblName");
        this.lblMaxLength.setName("lblMaxLength");
        this.txtName.setName("txtName");
        this.txtMaxLength.setName("txtMaxLength");
        this.txtMaxLength.setPrecision(0);
        this.txtMaxLength.setNegatived(false);
        this.txtMaxLength.setToolTipText("\u6ca1\u6709\u9650\u5236\u5219\u4e3a\u7a7a");
        this.btnConfirm.setName("btnConfirm");
        this.btnCancel.setName("btnCancel");
        this.lblLabelText.setName("lblLabelText");
        this.txtLabelText.setName("txtLabelText");
        this.chkMultiLan.setName("chkMultiLan");
        this.lblName.setBoundLabelText("\u540d\u79f0");
        this.lblName.setBoundLabelLength(80);
        this.lblMaxLength.setBoundLabelText("\u5f55\u5165\u6700\u5927\u957f\u5ea6");
        this.lblMaxLength.setBoundLabelLength(80);
        this.btnConfirm.setText("\u786e\u5b9a");
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewWebCtrlDialog.this.beforeActionPerformed(e);
                try {
                    NewWebCtrlDialog.this.btnConfirm_actionPerformed(e);
                }
                catch (Exception exc) {
                    NewWebCtrlDialog.this.handUIException(exc);
                }
                finally {
                    NewWebCtrlDialog.this.afterActionPerformed(e);
                }
            }
        });
        this.btnCancel.setText("\u53d6\u6d88");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewWebCtrlDialog.this.beforeActionPerformed(e);
                try {
                    NewWebCtrlDialog.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    NewWebCtrlDialog.this.handUIException(exc);
                }
                finally {
                    NewWebCtrlDialog.this.afterActionPerformed(e);
                }
            }
        });
        this.lblLabelText.setBoundLabelText("\u6807\u7b7e\u6587\u5b57");
        this.lblLabelText.setBoundLabelLength(80);
        this.chkMultiLan.setText("\u662f\u5426\u591a\u8bed\u8a00");
        this.chkMultiLan.setSelected(false);
        this.chkMultiLan.setVisible(false);
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 400, 200));
        this.setLayout(null);
        this.lblName.setBounds(new Rectangle(10, 11, 383, 19));
        this.add((Component)this.lblName, null);
        this.lblMaxLength.setBounds(new Rectangle(10, 60, 383, 19));
        this.add((Component)this.lblMaxLength, null);
        this.btnConfirm.setBounds(new Rectangle(240, 170, 73, 21));
        this.add((Component)this.btnConfirm, null);
        this.btnCancel.setBounds(new Rectangle(319, 170, 73, 21));
        this.add((Component)this.btnCancel, null);
        this.lblLabelText.setBounds(new Rectangle(10, 35, 383, 19));
        this.add((Component)this.lblLabelText, null);
        this.chkMultiLan.setBounds(new Rectangle(10, 59, 140, 19));
        this.add((Component)this.chkMultiLan, null);
        this.lblName.setBoundEditor((JComponent)this.txtName);
        this.lblMaxLength.setBoundEditor((JComponent)this.txtMaxLength);
        this.lblLabelText.setBoundEditor((JComponent)this.txtLabelText);
    }

    public void setWebUIObjectInfo(WebUIObjectInfo uiModel) {
        this.uiModel = uiModel;
    }

    public void setNode(WebTreeNode node) {
        this.node = node;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public void setSupportMultiLanguage(boolean isSupportML) {
        this.isSupportML = isSupportML;
        this.chkMultiLan.setSelected(false);
        this.chkMultiLan.setVisible(isSupportML);
        this.chkMultiLan.setVisible(false);
    }

    public ComponentInfo getNewCtrl() {
        return this.newCtrl;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.dataValidate()) {
            return;
        }
        ComponentInfo cInfo = null;
        if ("TextField".equals(this.classType)) {
            cInfo = WebComponentHelper.createTextField(this.uiModel, this.txtName.getText(), this.txtLabelText.getText(), this.chkMultiLan.isSelected());
        } else if ("TextArea".equals(this.classType)) {
            cInfo = WebComponentHelper.createTextArea(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("Number".equals(this.classType)) {
            cInfo = WebComponentHelper.createFormattedTextField(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("Date".equals(this.classType)) {
            cInfo = WebComponentHelper.createDatePicker(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("Time".equals(this.classType)) {
            cInfo = WebComponentHelper.createTimePicker(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("Bool".equals(this.classType)) {
            cInfo = WebComponentHelper.createCheckBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("Enum".equals(this.classType)) {
            cInfo = WebComponentHelper.createComboBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if ("F7".equals(this.classType)) {
            cInfo = WebComponentHelper.createBizPromptBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
        } else if (!StringUtils.isEmpty((String)this.classType)) {
            cInfo = WebComponentHelper.createComponent(this.uiModel, this.classType, this.txtName.getText(), this.txtLabelText.getText());
        } else {
            this.EXIT_STATUS = CANCEL_EXIT;
            this.disposeUIWindow();
            return;
        }
        ComponentInfo parent = (ComponentInfo)this.node.getUserObject();
        Dimension dim = ControlDefaultSizeManager.getDefaultSize((String)cInfo.getClassType());
        Object constraint = ConstraintUtil.createConstraint(parent, dim);
        if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(parent.getClassType())) {
            constraint = this.txtLabelText.getText();
        }
        cInfo.setConfigured(true);
        cInfo.setConstraint(constraint);
        parent.addChild((AbstractUIObjectInfo)this.uiModel, cInfo);
        WebItemInfo item = new WebItemInfo();
        ComponentInfo childField = WebUIEditorHelper.getNeedComponent(cInfo);
        childField.setConfigured(true);
        item.setName(childField.getName());
        item.setLabel(this.txtLabelText.getText());
        item.setLabelLength(100);
        item.setEnabled(true);
        item.setRequired(false);
        item.setConstraint(ConstraintUtil.clone(constraint));
        item.setComponent(childField);
        WebItemCollection items = (WebItemCollection)this.node.getConfigureItems();
        items.add(item);
        if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(parent.getClassType())) {
            item.setConstraint(null);
        }
        if (WebUIEditorHelper.needCreateNode(cInfo)) {
            this.node.add((MutableTreeNode)((Object)WebUIEditorHelper.createConfigureTreeNode(cInfo, this.uiModel, null, true)));
        }
        this.newCtrl = cInfo;
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    protected boolean dataValidate() {
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((String)name)) {
            ExceptionHandler.handleWarn((JComponent)((Object)this), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (EPUtils.checkStringIsChinese(name)) {
            ExceptionHandler.handleWarn((JComponent)((Object)this), (String)"\u63a7\u4ef6\u540d\u5e94\u8be5\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\uff0c\u4e14\u7b2c\u4e00\u4e2a\u5b57\u7b26\u5fc5\u987b\u662f\u5b57\u6bcd");
            return false;
        }
        return true;
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

