/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.commands;

import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ModelUtils;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponentHelper;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebPropertyValueChangeCommand
extends Command {
    private static final Logger logger = Logger.getLogger(WebPropertyValueChangeCommand.class);
    private String property;
    private WebItemInfoAdapter adapter;
    private Object newValue;
    private Object oldValue;
    private String cellDisplayText;

    public WebPropertyValueChangeCommand(String property, WebItemInfoAdapter adapter, Object newValue, String cellDisplayText) {
        if (newValue == null) {
            newValue = "";
        }
        this.property = property;
        this.adapter = adapter;
        this.newValue = newValue;
        this.cellDisplayText = cellDisplayText;
        if ("action_pro".equals(property)) {
            this.oldValue = WebComponentHelper.getPropertyValue(this.adapter.getItem().getComponent(), "action");
            if (newValue == null || "<none>".equals(newValue) || StringUtils.isEmpty((String)newValue.toString())) {
                this.newValue = "";
            }
        }
    }

    public WebPropertyValueChangeCommand(String property, WebItemInfo item, Object newValue, String cellDisplayText) {
        this(property, new WebItemInfoAdapter(item), newValue, cellDisplayText);
    }

    public boolean canExecute() {
        if ("labelcontainertext_pro".equals(this.property) || "visible_pro".equals(this.property) || "enable_pro".equals(this.property) || "requrie_pro".equals(this.property) || "sum_pro".equals(this.property) || "defaultvalue_inf".equals(this.property) || "diaplayformat".equals(this.property) || "editformat".equals(this.property) || "action_pro".equals(this.property)) {
            return true;
        }
        if ("labelcontainerlength_pro".equals(this.property) || "x_pro".equals(this.property) || "y_pro".equals(this.property) || "width_pro".equals(this.property) || "height_pro".equals(this.property) || "maxlength".equalsIgnoreCase(this.property) || "anchor_pro".equals(this.property)) {
            if ("height_pro".equals(this.property) && !ModelUtils.allowHeight(this.adapter.getItem().getComponent().getClassType())) {
                return false;
            }
            if ("maxlength".equalsIgnoreCase(this.property) && this.isInteger(this.newValue) && Integer.valueOf(this.newValue.toString()) < -1) {
                return false;
            }
            return this.isInteger(this.newValue);
        }
        if ("wldwidth_pro".equals(this.property) && (this.isInteger(this.newValue) || ModelUtils.allowWidthPercentage(this.adapter.getItem().getComponent().getClassType()) && this.newValue.toString().endsWith("%"))) {
            try {
                WebLayoutData.Unit.parse((String)this.newValue.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isInteger(Object newValue) {
        try {
            Integer.valueOf(newValue.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void execute() {
        if ("maxlength".equalsIgnoreCase(this.property)) {
            this.oldValue = WebComponentHelper.getPropertyValue(this.adapter.getItem().getComponent(), "maxLength");
            WebComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "maxLength", this.newValue);
        } else if ("labelcontainertext_pro".equals(this.property)) {
            this.oldValue = this.adapter.getItem().getLabel();
            if (this.newValue == null) {
                this.adapter.setLabel("");
            } else {
                this.adapter.setLabel(this.newValue.toString());
            }
        } else if ("labelcontainerlength_pro".equals(this.property)) {
            this.oldValue = new Integer(this.adapter.getItem().getLabelLength());
            this.adapter.setLabelLength(Integer.valueOf(this.newValue.toString()));
        } else if ("x_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            SmartLayoutData sld = (SmartLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            sld.x = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(sld);
        } else if ("y_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            SmartLayoutData sld = (SmartLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            sld.y = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(sld);
        } else if ("width_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            SmartLayoutData sld = (SmartLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            sld.width = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(sld);
        } else if ("height_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            SmartLayoutData sld = (SmartLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            sld.height = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(sld);
        } else if ("anchor_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            SmartLayoutData sld = (SmartLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            sld.autoSize = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(sld);
        } else if ("wldwidth_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            WebLayoutData wld = (WebLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            wld.width = WebLayoutData.Unit.parse((String)this.newValue.toString());
            this.adapter.setConstraint(wld);
        } else if ("wldheight_pro".equals(this.property)) {
            this.oldValue = ConstraintUtil.clone(this.adapter.getConstranit());
            WebLayoutData wld = (WebLayoutData)ConstraintUtil.clone(this.adapter.getConstranit());
            wld.height = Integer.valueOf(this.newValue.toString());
            this.adapter.setConstraint(wld);
        } else if ("action_pro".equals(this.property)) {
            WebComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "actionBinding", this.newValue);
        } else if ("visible_pro".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isVisible());
            this.adapter.getItem().setVisible(Boolean.valueOf(this.newValue.toString()).booleanValue());
            this.adapter.fireProperty("visible_pro", this.oldValue, this.newValue);
        } else if ("requrie_pro".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isRequired());
            this.adapter.getItem().setRequired(Boolean.valueOf(this.newValue.toString()).booleanValue());
            this.adapter.fireProperty("requrie_pro", this.oldValue, this.newValue);
        } else if ("enable_pro".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isEnabled());
            this.adapter.getItem().setEnabled(Boolean.valueOf(this.newValue.toString()).booleanValue());
            this.adapter.fireProperty("enable_pro", this.oldValue, this.newValue);
        } else if ("sum_pro".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isSum());
            this.adapter.getItem().setSum(Boolean.valueOf(this.newValue.toString()).booleanValue());
            this.adapter.fireProperty("sum_pro", this.oldValue, this.newValue);
        } else if ("defaultvalue_inf".equals(this.property)) {
            this.oldValue = this.adapter.getItem().getDefaultValue();
            this.adapter.getItem().setDefaultValue(this.getDefaultValue());
            this.adapter.fireProperty("defaultvalue_inf", this.oldValue, this.newValue);
        }
    }

    public void undo() {
        if ("maxlength".equalsIgnoreCase(this.property)) {
            WebComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "maxLength", this.oldValue);
        } else if ("labelcontainertext_pro".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.setLabel("");
            } else {
                this.adapter.setLabel(this.oldValue.toString());
            }
        } else if ("labelcontainerlength_pro".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.setLabelLength(-1);
            } else {
                this.adapter.setLabelLength(Integer.valueOf(this.oldValue.toString()));
            }
        } else if ("x_pro".equals(this.property) || "y_pro".equals(this.property) || "width_pro".equals(this.property) || "height_pro".equals(this.property) || "anchor_pro".equals(this.property) || "wldwidth_pro".equals(this.property) || "wldheight_pro".equals(this.property)) {
            this.adapter.setConstraint(this.oldValue);
        } else if ("action_pro".equals(this.property)) {
            WebComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "actionBinding", this.oldValue);
        } else if ("visible_pro".equals(this.property)) {
            this.adapter.getItem().setVisible(((Boolean)this.oldValue).booleanValue());
            this.adapter.fireProperty("visible_pro", this.oldValue, this.newValue);
        } else if ("requrie_pro".equals(this.property)) {
            this.adapter.getItem().setRequired(((Boolean)this.oldValue).booleanValue());
            this.adapter.fireProperty("requrie_pro", this.oldValue, this.newValue);
        } else if ("enable_pro".equals(this.property)) {
            this.adapter.getItem().setEnabled(((Boolean)this.oldValue).booleanValue());
            this.adapter.fireProperty("enable_pro", this.oldValue, this.newValue);
        } else if ("sum_pro".equals(this.property)) {
            this.adapter.getItem().setSum(((Boolean)this.oldValue).booleanValue());
            this.adapter.fireProperty("sum_pro", this.oldValue, this.newValue);
        } else if ("defaultvalue_inf".equals(this.property)) {
            this.adapter.getItem().setDefaultValue(this.oldValue.toString());
            this.adapter.fireProperty("defaultvalue_inf", this.oldValue, this.newValue);
        }
    }

    private String getDefaultValue() {
        DataSourceEnum dstype = this.adapter.getItem().getDataSourceType();
        BizDataTypeEnum dtype = this.adapter.getItem().getDataType();
        if (DataSourceEnum.SELF.equals((Object)dstype) || DataSourceEnum.BASEDATAEXT.equals((Object)dstype) ? BizDataTypeEnum.DATE.equals((Object)dtype) : DataSourceEnum.BASEDATA.equals((Object)dstype)) {
            return this.cellDisplayText;
        }
        return this.newValue.toString();
    }

    public PropertyInfo createDisplayFormatProperty(ComboBoxItem item) {
        if (item == null || item.getValue() == null) {
            return null;
        }
        String value = item.getValue().toString();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("diaplayFormat");
        prop.setType(String.class.getName());
        prop.setValue(this.parseStrToDisplayField(value));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEdittFormatProperty(ComboBoxItem item) {
        if (item == null || item.getValue() == null) {
            return null;
        }
        String value = item.getValue().toString();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue(this.parseStrToDisplayField(value));
        prop.setOverride(true);
        return prop;
    }

    public String parseStrToDisplayField(String sDisField) {
        if (StringUtils.isEmpty((String)sDisField)) {
            return "$number$";
        }
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        boolean bAddDisField = false;
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            String sKey = "";
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }
}

