/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.document;

import java.util.Set;
import org.apache.lucene.ep.document.FieldSelector;
import org.apache.lucene.ep.document.FieldSelectorResult;

public class SetBasedFieldSelector
implements FieldSelector {
    private Set fieldsToLoad;
    private Set lazyFieldsToLoad;

    public SetBasedFieldSelector(Set fieldsToLoad, Set lazyFieldsToLoad) {
        this.fieldsToLoad = fieldsToLoad;
        this.lazyFieldsToLoad = lazyFieldsToLoad;
    }

    @Override
    public FieldSelectorResult accept(String fieldName) {
        FieldSelectorResult result = FieldSelectorResult.NO_LOAD;
        if (this.fieldsToLoad.contains(fieldName)) {
            result = FieldSelectorResult.LOAD;
        }
        if (this.lazyFieldsToLoad.contains(fieldName)) {
            result = FieldSelectorResult.LAZY_LOAD;
        }
        return result;
    }
}

