/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.SegmentInfo;
import org.apache.lucene.ep.index.SegmentInfos;
import org.apache.lucene.ep.index.SegmentReader;
import org.apache.lucene.ep.index.SegmentTermDocs;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.index.TermFreqVector;
import org.apache.lucene.ep.index.TermPositions;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;
import org.apache.lucene.ep.store.IndexInput;

public class CheckIndex {
    public static final PrintStream out = null;
    private PrintStream infoStream;
    private Directory dir;
    private static final Logger logger = Logger.getLogger(CheckIndex.class);
    private static boolean assertsOn;

    public CheckIndex(Directory dir) {
        this.dir = dir;
        this.infoStream = out;
    }

    public void setInfoStream(PrintStream out) {
        this.infoStream = out;
    }

    private void msg(String msg) {
        if (this.infoStream != null) {
            this.infoStream.println(msg);
        }
    }

    public static boolean check(Directory dir, boolean doFix) throws IOException {
        return CheckIndex.check(dir, doFix, null);
    }

    public static boolean check(Directory dir, boolean doFix, List onlySegments) throws IOException {
        CheckIndex checker = new CheckIndex(dir);
        Status status = checker.checkIndex(onlySegments);
        if (doFix && !status.clean) {
            checker.fixIndex(status);
        }
        return status.clean;
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status checkIndex(List onlySegments) throws IOException {
        NumberFormat nf = NumberFormat.getInstance();
        SegmentInfos sis = new SegmentInfos();
        Status result = new Status();
        result.dir = this.dir;
        try {
            sis.read(this.dir);
        }
        catch (Throwable t) {
            this.msg("ERROR: could not read any segments file in directory");
            result.missingSegments = true;
            if (this.infoStream != null) {
                logger.error((Object)this.infoStream, t);
            }
            return result;
        }
        int numSegments = sis.size();
        String segmentsFileName = sis.getCurrentSegmentFileName();
        IndexInput input = null;
        try {
            input = this.dir.openInput(segmentsFileName);
        }
        catch (Throwable t) {
            this.msg("ERROR: could not open segments file in directory");
            if (this.infoStream != null) {
                logger.error((Object)this.infoStream, t);
            }
            result.cantOpenSegments = true;
            return result;
        }
        int format = 0;
        try {
            format = input.readInt();
        }
        catch (Throwable t) {
            this.msg("ERROR: could not read segment file version in directory");
            if (this.infoStream != null) {
                logger.error((Object)this.infoStream, t);
            }
            result.missingSegmentVersion = true;
            Status status = result;
            return status;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        String sFormat = "";
        boolean skip = false;
        if (format == -1) {
            sFormat = "FORMAT [Lucene Pre-2.1]";
        }
        if (format == -2) {
            sFormat = "FORMAT_LOCKLESS [Lucene 2.1]";
        } else if (format == -3) {
            sFormat = "FORMAT_SINGLE_NORM_FILE [Lucene 2.2]";
        } else if (format == -4) {
            sFormat = "FORMAT_SHARED_DOC_STORE [Lucene 2.3]";
        } else if (format == -5) {
            sFormat = "FORMAT_CHECKSUM [Lucene 2.4]";
        } else if (format == -6) {
            sFormat = "FORMAT_DEL_COUNT [Lucene 2.4]";
        } else if (format == -7) {
            sFormat = "FORMAT_HAS_PROX [Lucene 2.4]";
        } else if (format == -8) {
            sFormat = "FORMAT_USER_DATA [Lucene 2.9]";
        } else if (format == -9) {
            sFormat = "FORMAT_DIAGNOSTICS [Lucene 2.9]";
        } else if (format < -9) {
            sFormat = "int=" + format + " [newer version of Lucene than this tool]";
            skip = true;
        } else {
            sFormat = format + " [Lucene 1.3 or prior]";
        }
        result.segmentsFileName = segmentsFileName;
        result.numSegments = numSegments;
        result.segmentFormat = sFormat;
        result.userData = sis.getUserData();
        String userDataString = sis.getUserData().size() > 0 ? " userData=" + sis.getUserData() : "";
        this.msg("Segments file=" + segmentsFileName + " numSegments=" + numSegments + " version=" + sFormat + userDataString);
        if (onlySegments != null) {
            result.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
            }
            Iterator it = onlySegments.iterator();
            while (it.hasNext()) {
                if (this.infoStream == null) continue;
                this.infoStream.print(" " + it.next());
            }
            result.segmentsChecked.addAll(onlySegments);
            this.msg(":");
        }
        if (skip) {
            this.msg("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            result.toolOutOfDate = true;
            return result;
        }
        result.newSegments = (SegmentInfos)sis.clone();
        result.newSegments.clear();
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = sis.info(i);
            if (onlySegments != null && !onlySegments.contains(info.name)) continue;
            Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
            result.segmentInfos.add(segInfoStat);
            this.msg("  " + (1 + i) + " of " + numSegments + ": name=" + info.name + " docCount=" + info.docCount);
            segInfoStat.name = info.name;
            segInfoStat.docCount = info.docCount;
            int toLoseDocCount = info.docCount;
            try (IndexReader reader = null;){
                int numDocs;
                String delFileName;
                int docStoreOffset;
                Map diagnostics;
                this.msg("    compound=" + info.getUseCompoundFile());
                segInfoStat.compound = info.getUseCompoundFile();
                this.msg("    hasProx=" + info.getHasProx());
                segInfoStat.hasProx = info.getHasProx();
                this.msg("    numFiles=" + info.files().size());
                segInfoStat.numFiles = info.files().size();
                this.msg("    size (MB)=" + nf.format((double)info.sizeInBytes() / 1048576.0));
                segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
                segInfoStat.diagnostics = diagnostics = info.getDiagnostics();
                if (diagnostics.size() > 0) {
                    this.msg("    diagnostics = " + diagnostics);
                }
                if ((docStoreOffset = info.getDocStoreOffset()) != -1) {
                    this.msg("    docStoreOffset=" + docStoreOffset);
                    segInfoStat.docStoreOffset = docStoreOffset;
                    this.msg("    docStoreSegment=" + info.getDocStoreSegment());
                    segInfoStat.docStoreSegment = info.getDocStoreSegment();
                    this.msg("    docStoreIsCompoundFile=" + info.getDocStoreIsCompoundFile());
                    segInfoStat.docStoreCompoundFile = info.getDocStoreIsCompoundFile();
                }
                if ((delFileName = info.getDelFileName()) == null) {
                    this.msg("    no deletions");
                    segInfoStat.hasDeletions = false;
                } else {
                    this.msg("    has deletions [delFileName=" + delFileName + "]");
                    segInfoStat.hasDeletions = true;
                    segInfoStat.deletionsFileName = delFileName;
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: open reader.........");
                }
                reader = SegmentReader.get(info);
                segInfoStat.openReaderPassed = true;
                toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                if (((SegmentReader)reader).hasDeletions()) {
                    if (((SegmentReader)reader).deletedDocs.count() != info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs deletedDocs.count()=" + ((SegmentReader)reader).deletedDocs.count());
                    }
                    if (((SegmentReader)reader).deletedDocs.count() > ((SegmentReader)reader).maxDoc()) {
                        throw new RuntimeException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader).maxDoc() + " vs deletedDocs.count()=" + ((SegmentReader)reader).deletedDocs.count());
                    }
                    if (info.docCount - numDocs != info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                    }
                    segInfoStat.numDeleted = info.docCount - numDocs;
                    this.msg("OK [" + segInfoStat.numDeleted + " deleted docs]");
                } else {
                    if (info.getDelCount() != 0) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                    }
                    this.msg("OK");
                }
                if (((SegmentReader)reader).maxDoc() != info.docCount) {
                    throw new RuntimeException("SegmentReader.maxDoc() " + ((SegmentReader)reader).maxDoc() + " != SegmentInfos.docCount " + info.docCount);
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: fields..............");
                }
                Collection fieldNames = ((SegmentReader)reader).getFieldNames(IndexReader.FieldOption.ALL);
                this.msg("OK [" + fieldNames.size() + " fields]");
                segInfoStat.numFields = fieldNames.size();
                segInfoStat.fieldNormStatus = this.testFieldNorms(fieldNames, (SegmentReader)reader);
                segInfoStat.termIndexStatus = this.testTermIndex(info, (SegmentReader)reader);
                segInfoStat.storedFieldStatus = this.testStoredFields(info, (SegmentReader)reader, nf);
                segInfoStat.termVectorStatus = this.testTermVectors(info, (SegmentReader)reader, nf);
                if (segInfoStat.fieldNormStatus.error != null) {
                    throw new RuntimeException("Field Norm test failed");
                }
                if (segInfoStat.termIndexStatus.error != null) {
                    throw new RuntimeException("Term Index test failed");
                }
                if (segInfoStat.storedFieldStatus.error != null) {
                    throw new RuntimeException("Stored Field test failed");
                }
                if (segInfoStat.termVectorStatus.error != null) {
                    throw new RuntimeException("Term Vector test failed");
                }
                this.msg("");
            }
            result.newSegments.add(info.clone());
        }
        if (0 == result.numBadSegments) {
            result.clean = true;
            this.msg("No problems were detected with this index.\n");
        } else {
            this.msg("WARNING: " + result.numBadSegments + " broken segments (containing " + result.totLoseDocCount + " documents) detected");
        }
        return result;
    }

    private Status.FieldNormStatus testFieldNorms(Collection fieldNames, SegmentReader reader) {
        Status.FieldNormStatus status;
        block4: {
            status = new Status.FieldNormStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: field norms.........");
                }
                Iterator it = fieldNames.iterator();
                byte[] b = new byte[reader.maxDoc()];
                while (it.hasNext()) {
                    String fieldName = (String)it.next();
                    reader.norms(fieldName, b, 0);
                    ++status.totFields;
                }
                this.msg("OK [" + status.totFields + " fields]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block4;
                logger.error((Object)this.infoStream, e);
            }
        }
        return status;
    }

    private Status.TermIndexStatus testTermIndex(SegmentInfo info, SegmentReader reader) {
        Status.TermIndexStatus status;
        block13: {
            status = new Status.TermIndexStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: terms, freq, prox...");
                }
                TermEnum termEnum = reader.terms();
                TermPositions termPositions = reader.termPositions();
                MySegmentTermDocs myTermDocs = new MySegmentTermDocs(reader);
                int maxDoc = reader.maxDoc();
                while (termEnum.next()) {
                    int delCount;
                    ++status.termCount;
                    Term term = termEnum.term();
                    int docFreq = termEnum.docFreq();
                    termPositions.seek(term);
                    int lastDoc = -1;
                    int freq0 = 0;
                    status.totFreq += (long)docFreq;
                    while (termPositions.next()) {
                        ++freq0;
                        int doc = termPositions.doc();
                        int freq = termPositions.freq();
                        if (doc <= lastDoc) {
                            throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                        }
                        if (doc >= maxDoc) {
                            throw new RuntimeException("term " + term + ": doc " + doc + " >= maxDoc " + maxDoc);
                        }
                        lastDoc = doc;
                        if (freq <= 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                        }
                        int lastPos = -1;
                        status.totPos += (long)freq;
                        for (int j = 0; j < freq; ++j) {
                            int pos = termPositions.nextPosition();
                            if (pos < -1) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                            }
                            if (pos >= lastPos) continue;
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                        }
                    }
                    if (reader.hasDeletions()) {
                        myTermDocs.seek(term);
                        while (myTermDocs.next()) {
                        }
                        delCount = myTermDocs.delCount;
                    } else {
                        delCount = 0;
                    }
                    if (freq0 + delCount == docFreq) continue;
                    throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != num docs seen " + freq0 + " + num docs deleted " + delCount);
                }
                this.msg("OK [" + status.termCount + " terms; " + status.totFreq + " terms/docs pairs; " + status.totPos + " tokens]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block13;
                logger.error((Object)this.infoStream, e);
            }
        }
        return status;
    }

    private Status.StoredFieldStatus testStoredFields(SegmentInfo info, SegmentReader reader, NumberFormat format) {
        Status.StoredFieldStatus status;
        block5: {
            status = new Status.StoredFieldStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: stored fields.......");
                }
                for (int j = 0; j < info.docCount; ++j) {
                    if (reader.isDeleted(j)) continue;
                    ++status.docCount;
                    Document doc = reader.document(j);
                    status.totFields += (long)doc.getFields().size();
                }
                if (status.docCount != reader.numDocs()) {
                    throw new RuntimeException("docCount=" + status.docCount + " but saw " + status.docCount + " undeleted docs");
                }
                this.msg("OK [" + status.totFields + " total field count; avg " + format.format((float)status.totFields / (float)status.docCount) + " fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block5;
                logger.error((Object)this.infoStream, e);
            }
        }
        return status;
    }

    private Status.TermVectorStatus testTermVectors(SegmentInfo info, SegmentReader reader, NumberFormat format) {
        Status.TermVectorStatus status;
        block4: {
            status = new Status.TermVectorStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: term vectors........");
                }
                for (int j = 0; j < info.docCount; ++j) {
                    if (reader.isDeleted(j)) continue;
                    ++status.docCount;
                    TermFreqVector[] tfv = reader.getTermFreqVectors(j);
                    if (tfv == null) continue;
                    status.totVectors += (long)tfv.length;
                }
                this.msg("OK [" + status.totVectors + " total vector count; avg " + format.format((float)status.totVectors / (float)status.docCount) + " term/freq vector fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block4;
                logger.error((Object)this.infoStream, e);
            }
        }
        return status;
    }

    public void fixIndex(Status result) throws IOException {
        if (result.partial) {
            throw new IllegalArgumentException("can only fix an index that was fully checked (this status checked a subset of segments)");
        }
        result.newSegments.commit(result.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    private static boolean assertsOn() {
        assert (CheckIndex.testAsserts());
        return assertsOn;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        boolean doFix = false;
        ArrayList<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-fix")) {
                doFix = true;
                ++i;
                continue;
            }
            if (args[i].equals("-segment")) {
                if (i == args.length - 1) {
                    logger.info((Object)"ERROR: missing name for -segment option");
                    System.exit(1);
                }
                onlySegments.add(args[i + 1]);
                i += 2;
                continue;
            }
            if (indexPath != null) {
                logger.info((Object)("ERROR: unexpected extra argument '" + args[i] + "'"));
                System.exit(1);
            }
            indexPath = args[i];
            ++i;
        }
        if (indexPath == null) {
            logger.info((Object)"\nERROR: index path not specified");
            logger.info((Object)"\nUsage: java org.apache.lucene.ep.index.CheckIndex pathToIndex [-fix] [-segment X] [-segment Y]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n\n**WARNING**: -fix should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -fix, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -fix were\nspecified.  With -fix, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
            System.exit(1);
        }
        if (!CheckIndex.assertsOn()) {
            logger.info((Object)"\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene.ep...', so assertions are enabled");
        }
        if (onlySegments.size() == 0) {
            onlySegments = null;
        } else if (doFix) {
            logger.info((Object)"ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        logger.info((Object)("\nOpening index @ " + indexPath + "\n"));
        FSDirectory dir = null;
        try {
            dir = FSDirectory.open(new File(indexPath));
        }
        catch (Throwable t) {
            logger.info((Object)("ERROR: could not open directory \"" + indexPath + "\"; exiting"));
            logger.error((Object)System.out, t);
            System.exit(1);
        }
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(System.out);
        Status result = checker.checkIndex(onlySegments);
        if (result.missingSegments) {
            System.exit(1);
        }
        if (!result.clean) {
            if (!doFix) {
                logger.info((Object)("WARNING: would write new segments file, and " + result.totLoseDocCount + " documents would be lost, if -fix were specified\n"));
            } else {
                logger.info((Object)("WARNING: " + result.totLoseDocCount + " documents will be lost\n"));
                logger.info((Object)("NOTE: will write new segments file in 5 seconds; this will remove " + result.totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!"));
                for (int s = 0; s < 5; ++s) {
                    Thread.sleep(1000L);
                    logger.info((Object)("  " + (5 - s) + "..."));
                }
                logger.info((Object)"Writing...");
                checker.fixIndex(result);
                logger.info((Object)"OK");
                logger.info((Object)("Wrote new segments file \"" + result.newSegments.getCurrentSegmentFileName() + "\""));
            }
        }
        logger.info((Object)"");
        int exitCode = result != null && result.clean ? 0 : 1;
        System.exit(exitCode);
    }

    private static class MySegmentTermDocs
    extends SegmentTermDocs {
        int delCount;

        MySegmentTermDocs(SegmentReader p) {
            super(p);
        }

        @Override
        public void seek(Term term) throws IOException {
            super.seek(term);
            this.delCount = 0;
        }

        @Override
        protected void skippingDoc() throws IOException {
            ++this.delCount;
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public String segmentFormat;
        public List segmentsChecked = new ArrayList();
        public boolean toolOutOfDate;
        public List segmentInfos = new ArrayList();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public Map userData;

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error = null;
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error = null;
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static class SegmentInfoStatus {
            public String name;
            public int docCount;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public int docStoreOffset = -1;
            public String docStoreSegment;
            public boolean docStoreCompoundFile;
            public boolean hasDeletions;
            public String deletionsFileName;
            public int numDeleted;
            public boolean openReaderPassed;
            int numFields;
            public boolean hasProx;
            public Map diagnostics;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
        }
    }
}

