/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.FieldSelector;
import org.apache.lucene.ep.index.CompoundFileReader;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.DirectoryOwningReader;
import org.apache.lucene.ep.index.DirectoryReader;
import org.apache.lucene.ep.index.IndexCommit;
import org.apache.lucene.ep.index.IndexDeletionPolicy;
import org.apache.lucene.ep.index.SegmentInfos;
import org.apache.lucene.ep.index.StaleReaderException;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.index.TermFreqVector;
import org.apache.lucene.ep.index.TermPositions;
import org.apache.lucene.ep.index.TermVectorMapper;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.store.AlreadyClosedException;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;
import org.apache.lucene.ep.store.IndexInput;
import org.apache.lucene.ep.store.LockObtainFailedException;

public abstract class IndexReader
implements Cloneable {
    private static final Logger logger = Logger.getLogger(IndexReader.class);
    private boolean closed;
    protected boolean hasChanges;
    private int refCount = 1;
    static int DEFAULT_TERMS_INDEX_DIVISOR = 1;
    private boolean disableFakeNorms = false;
    private Directory directory;

    public synchronized int getRefCount() {
        return this.refCount;
    }

    public synchronized void incRef() {
        assert (this.refCount > 0);
        this.ensureOpen();
        ++this.refCount;
    }

    public synchronized void decRef() throws IOException {
        assert (this.refCount > 0);
        this.ensureOpen();
        if (this.refCount == 1) {
            this.commit();
            this.doClose();
        }
        --this.refCount;
    }

    protected IndexReader(Directory directory) {
        this();
        this.directory = directory;
    }

    protected IndexReader() {
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.refCount <= 0) {
            throw new AlreadyClosedException("this IndexReader is closed");
        }
    }

    public static IndexReader open(String path) throws CorruptIndexException, IOException {
        return IndexReader.open(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader open(String path, boolean readOnly) throws CorruptIndexException, IOException {
        FSDirectory dir = FSDirectory.getDirectory(path);
        IndexReader r = null;
        try {
            r = IndexReader.open(dir, null, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
        }
        finally {
            if (r == null) {
                ((Directory)dir).close();
            }
        }
        return new DirectoryOwningReader(r);
    }

    public static IndexReader open(File path) throws CorruptIndexException, IOException {
        return IndexReader.open(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader open(File path, boolean readOnly) throws CorruptIndexException, IOException {
        FSDirectory dir = FSDirectory.getDirectory(path);
        IndexReader r = null;
        try {
            r = IndexReader.open(dir, null, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
        }
        finally {
            if (r == null) {
                ((Directory)dir).close();
            }
        }
        return new DirectoryOwningReader(r);
    }

    public static IndexReader open(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, false, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), null, commit, false, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), null, commit, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, deletionPolicy, null, false, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, deletionPolicy, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, deletionPolicy, null, readOnly, termInfosIndexDivisor);
    }

    public static IndexReader open(IndexCommit commit, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), deletionPolicy, commit, false, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit, IndexDeletionPolicy deletionPolicy, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), deletionPolicy, commit, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), deletionPolicy, commit, readOnly, termInfosIndexDivisor);
    }

    private static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, IndexCommit commit, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return DirectoryReader.open(directory, deletionPolicy, commit, readOnly, termInfosIndexDivisor);
    }

    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    public synchronized IndexReader reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    public synchronized IndexReader reopen(IndexCommit commit) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen(IndexCommit).");
    }

    public synchronized Object clone() {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public Directory directory() {
        this.ensureOpen();
        if (null != this.directory) {
            return this.directory;
        }
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static long lastModified(String directory) throws CorruptIndexException, IOException {
        return IndexReader.lastModified(new File(directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastModified(File fileDirectory) throws CorruptIndexException, IOException {
        try (FSDirectory dir = FSDirectory.getDirectory(fileDirectory);){
            long l = IndexReader.lastModified(dir);
            return l;
        }
    }

    public static long lastModified(final Directory directory2) throws CorruptIndexException, IOException {
        return (Long)new SegmentInfos.FindSegmentsFile(directory2){

            @Override
            public Object doBody(String segmentFileName) throws IOException {
                return new Long(directory2.fileModified(segmentFileName));
            }
        }.run();
    }

    public static long getCurrentVersion(String directory) throws CorruptIndexException, IOException {
        return IndexReader.getCurrentVersion(new File(directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCurrentVersion(File directory) throws CorruptIndexException, IOException {
        try (FSDirectory dir = FSDirectory.getDirectory(directory);){
            long l = IndexReader.getCurrentVersion(dir);
            return l;
        }
    }

    public static long getCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public static Map getCommitUserData(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentUserData(directory);
    }

    public long getVersion() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public Map getCommitUserData() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public void setTermInfosIndexDivisor(int indexDivisor) throws IllegalStateException {
        throw new UnsupportedOperationException("Please pass termInfosIndexDivisor up-front when opening IndexReader");
    }

    public int getTermInfosIndexDivisor() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isOptimized() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public abstract void getTermFreqVector(int var1, String var2, TermVectorMapper var3) throws IOException;

    public abstract void getTermFreqVector(int var1, TermVectorMapper var2) throws IOException;

    public static boolean indexExists(String directory) {
        return IndexReader.indexExists(new File(directory));
    }

    public static boolean indexExists(File directory) {
        return SegmentInfos.getCurrentSegmentGeneration(directory.list()) != -1L;
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return SegmentInfos.getCurrentSegmentGeneration(directory) != -1L;
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public int numDeletedDocs() {
        return this.maxDoc() - this.numDocs();
    }

    public Document document(int n) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.document(n, null);
    }

    public abstract Document document(int var1, FieldSelector var2) throws CorruptIndexException, IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        return this.norms(field) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public synchronized void setNorm(int doc, String field, byte value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doSetNorm(doc, field, value);
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws CorruptIndexException, IOException;

    public void setNorm(int doc, String field, float value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public synchronized void deleteDocument(int docNum) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doDelete(docNum);
    }

    protected abstract void doDelete(int var1) throws CorruptIndexException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDocuments(Term term) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.deleteDocument(docs.doc());
                ++n;
            }
        }
        finally {
            docs.close();
        }
        return n;
    }

    public synchronized void undeleteAll() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doUndeleteAll();
    }

    protected abstract void doUndeleteAll() throws CorruptIndexException, IOException;

    protected synchronized void acquireWriteLock() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        this.ensureOpen();
        this.commit();
    }

    public final synchronized void flush(Map commitUserData) throws IOException {
        this.ensureOpen();
        this.commit(commitUserData);
    }

    protected final synchronized void commit() throws IOException {
        this.commit(null);
    }

    protected final synchronized void commit(Map commitUserData) throws IOException {
        if (this.hasChanges) {
            this.doCommit(commitUserData);
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    void doCommit(Map commitUserData) throws IOException {
        this.doCommit();
    }

    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract Collection getFieldNames(FieldOption var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked();
    }

    public static boolean isLocked(String directory) throws IOException {
        try (FSDirectory dir = FSDirectory.getDirectory(directory);){
            boolean bl = IndexReader.isLocked(dir);
            return bl;
        }
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
    }

    public IndexCommit getIndexCommit() throws IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String filename = null;
        boolean extract = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-extract")) {
                extract = true;
                continue;
            }
            if (filename != null) continue;
            filename = args[i];
        }
        if (filename == null) {
            logger.info((Object)"Usage: org.apache.lucene.ep.index.IndexReader [-extract] <cfsfile>");
            return;
        }
        Directory dir = null;
        CompoundFileReader cfr = null;
        FileOutputStream f = null;
        try {
            File file = new File(filename);
            String dirname = file.getAbsoluteFile().getParent();
            filename = file.getName();
            dir = FSDirectory.open(new File(dirname));
            cfr = new CompoundFileReader(dir, filename);
            Object[] files = cfr.list();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                long len;
                if (extract) {
                    int bufLen;
                    logger.info((Object)("extract " + (String)files[i] + " with " + len + " bytes to local directory..."));
                    IndexInput ii = cfr.openInput((String)files[i]);
                    f = new FileOutputStream((String)files[i]);
                    byte[] buffer = new byte[1024];
                    int chunk = buffer.length;
                    for (len = cfr.fileLength((String)files[i]); len > 0L; len -= (long)bufLen) {
                        bufLen = (int)Math.min((long)chunk, len);
                        ii.readBytes(buffer, 0, bufLen);
                        f.write(buffer, 0, bufLen);
                    }
                    f.close();
                    ii.close();
                    continue;
                }
                logger.info((Object)((String)files[i] + ": " + len + " bytes"));
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"IndexReader.main", (Throwable)ioe);
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
                if (dir != null) {
                    dir.close();
                }
                if (cfr != null) {
                    cfr.close();
                }
            }
            catch (IOException ioe) {
                logger.error((Object)"IndexReader.main", (Throwable)ioe);
            }
        }
    }

    public static Collection listCommits(Directory dir) throws IOException {
        return DirectoryReader.listCommits(dir);
    }

    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    public Object getFieldCacheKey() {
        return this;
    }

    public Object getDeletesCacheKey() {
        return this;
    }

    public long getUniqueTermCount() throws IOException {
        throw new UnsupportedOperationException("this reader does not implement getUniqueTermCount()");
    }

    public boolean getDisableFakeNorms() {
        return this.disableFakeNorms;
    }

    public void setDisableFakeNorms(boolean disableFakeNorms) {
        this.disableFakeNorms = disableFakeNorms;
    }

    public static final class FieldOption {
        private String option;
        public static final FieldOption ALL = new FieldOption("ALL");
        public static final FieldOption INDEXED = new FieldOption("INDEXED");
        public static final FieldOption STORES_PAYLOADS = new FieldOption("STORES_PAYLOADS");
        public static final FieldOption OMIT_TERM_FREQ_AND_POSITIONS;
        public static final FieldOption OMIT_TF;
        public static final FieldOption UNINDEXED;
        public static final FieldOption INDEXED_WITH_TERMVECTOR;
        public static final FieldOption INDEXED_NO_TERMVECTOR;
        public static final FieldOption TERMVECTOR;
        public static final FieldOption TERMVECTOR_WITH_POSITION;
        public static final FieldOption TERMVECTOR_WITH_OFFSET;
        public static final FieldOption TERMVECTOR_WITH_POSITION_OFFSET;

        private FieldOption() {
        }

        private FieldOption(String option) {
            this.option = option;
        }

        public String toString() {
            return this.option;
        }

        static {
            OMIT_TF = OMIT_TERM_FREQ_AND_POSITIONS = new FieldOption("OMIT_TERM_FREQ_AND_POSITIONS");
            UNINDEXED = new FieldOption("UNINDEXED");
            INDEXED_WITH_TERMVECTOR = new FieldOption("INDEXED_WITH_TERMVECTOR");
            INDEXED_NO_TERMVECTOR = new FieldOption("INDEXED_NO_TERMVECTOR");
            TERMVECTOR = new FieldOption("TERMVECTOR");
            TERMVECTOR_WITH_POSITION = new FieldOption("TERMVECTOR_WITH_POSITION");
            TERMVECTOR_WITH_OFFSET = new FieldOption("TERMVECTOR_WITH_OFFSET");
            TERMVECTOR_WITH_POSITION_OFFSET = new FieldOption("TERMVECTOR_WITH_POSITION_OFFSET");
        }
    }
}

