/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.ComplexExplanation;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.DocIdSetIterator;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.Weight;

public class ConstantScoreQuery
extends Query {
    protected final Filter filter;

    public ConstantScoreQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new ConstantWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantScoreQuery)) {
            return false;
        }
        ConstantScoreQuery other = (ConstantScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.filter.equals(other.filter);
    }

    @Override
    public int hashCode() {
        return this.filter.hashCode() + Float.floatToIntBits(this.getBoost());
    }

    protected class ConstantScorer
    extends Scorer {
        final DocIdSetIterator docIdSetIterator;
        final float theScore;
        int doc;

        public ConstantScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            DocIdSetIterator iter;
            super(similarity);
            this.doc = -1;
            this.theScore = w.getValue();
            DocIdSet docIdSet = ConstantScoreQuery.this.filter.getDocIdSet(reader);
            this.docIdSetIterator = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : ((iter = docIdSet.iterator()) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : iter);
        }

        @Override
        public boolean next() throws IOException {
            return this.docIdSetIterator.nextDoc() != Integer.MAX_VALUE;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        @Override
        public int doc() {
            return this.docIdSetIterator.doc();
        }

        @Override
        public int docID() {
            return this.docIdSetIterator.docID();
        }

        @Override
        public float score() throws IOException {
            return this.theScore;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            return this.docIdSetIterator.advance(target) != Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.docIdSetIterator.advance(target);
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class ConstantWeight
    extends Weight {
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Searcher searcher) {
            this.similarity = ConstantScoreQuery.this.getSimilarity(searcher);
        }

        @Override
        public Query getQuery() {
            return ConstantScoreQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ConstantScorer(this.similarity, reader, this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ConstantScorer cs = new ConstantScorer(this.similarity, reader, this);
            boolean exists = cs.docIdSetIterator.advance(doc) == doc;
            ComplexExplanation result = new ComplexExplanation();
            if (exists) {
                result.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + "), product of:");
                result.setValue(this.queryWeight);
                result.setMatch(Boolean.TRUE);
                result.addDetail(new Explanation(ConstantScoreQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + ") doesn't match id " + doc);
                result.setValue(0.0f);
                result.setMatch(Boolean.FALSE);
            }
            return result;
        }
    }
}

