/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import org.apache.lucene.ep.search.ScoreDoc;

public interface ScoreDocComparator {
    public static final ScoreDocComparator RELEVANCE = new ScoreDocComparator(){

        @Override
        public int compare(ScoreDoc i, ScoreDoc j) {
            if (i.score > j.score) {
                return -1;
            }
            if (i.score < j.score) {
                return 1;
            }
            return 0;
        }

        @Override
        public Comparable sortValue(ScoreDoc i) {
            return new Float(i.score);
        }

        @Override
        public int sortType() {
            return 0;
        }
    };
    public static final ScoreDocComparator INDEXORDER = new ScoreDocComparator(){

        @Override
        public int compare(ScoreDoc i, ScoreDoc j) {
            if (i.doc < j.doc) {
                return -1;
            }
            if (i.doc > j.doc) {
                return 1;
            }
            return 0;
        }

        @Override
        public Comparable sortValue(ScoreDoc i) {
            return new Integer(i.doc);
        }

        @Override
        public int sortType() {
            return 1;
        }
    };

    public int compare(ScoreDoc var1, ScoreDoc var2);

    public Comparable sortValue(ScoreDoc var1);

    public int sortType();
}

