/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.store;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexFileNameFilter;
import org.apache.lucene.ep.store.AlreadyClosedException;
import org.apache.lucene.ep.store.IndexInput;
import org.apache.lucene.ep.store.IndexOutput;
import org.apache.lucene.ep.store.Lock;
import org.apache.lucene.ep.store.LockFactory;

public abstract class Directory {
    protected volatile boolean isOpen = true;
    protected LockFactory lockFactory;

    public abstract String[] list() throws IOException;

    public String[] listAll() throws IOException {
        return this.list();
    }

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract void renameFile(String var1, String var2) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    public void sync(String name) throws IOException {
    }

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.openInput(name);
    }

    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(name);
        }
    }

    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
        String[] files = src.listAll();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        byte[] buf = new byte[16384];
        for (int i = 0; i < files.length; ++i) {
            if (!filter.accept(null, files[i])) continue;
            IndexOutput os = null;
            IndexInput is = null;
            try {
                int toRead;
                os = dest.createOutput(files[i]);
                is = src.openInput(files[i]);
                long len = is.length();
                for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                    toRead = readCount + 16384L > len ? (int)(len - readCount) : 16384;
                    is.readBytes(buf, 0, toRead);
                    os.writeBytes(buf, toRead);
                }
                continue;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        if (closeDirSrc) {
            src.close();
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }
}

