/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.util.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.ep.util.cache.Cache;

public class SimpleMapCache
extends Cache {
    Map map;

    public SimpleMapCache() {
        this(new HashMap());
    }

    public SimpleMapCache(Map map) {
        this.map = map;
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    Cache getSynchronizedCache() {
        return new SynchronizedSimpleMapCache(this);
    }

    private static class SynchronizedSimpleMapCache
    extends SimpleMapCache {
        Object mutex;
        SimpleMapCache cache;

        SynchronizedSimpleMapCache(SimpleMapCache cache) {
            this.cache = cache;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set keySet() {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.keySet();
            }
        }

        @Override
        Cache getSynchronizedCache() {
            return this;
        }
    }
}

