/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ep.ui.autocomplete;

import org.fife.ep.ui.autocomplete.BasicCompletion;
import org.fife.ep.ui.autocomplete.CompletionProvider;

public class VariableCompletion
extends BasicCompletion {
    private String type;
    private String definedIn;

    public VariableCompletion(CompletionProvider provider, String name, String type) {
        super(provider, name);
        this.type = type;
    }

    protected void addDefinitionString(StringBuffer sb) {
        sb.append("<html><b>").append(this.getDefinitionString()).append("</b>");
    }

    public String getDefinitionString() {
        StringBuffer sb = new StringBuffer();
        if (this.type != null) {
            sb.append(this.type).append(' ');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getName() {
        return this.getReplacementText();
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        this.addDefinitionString(sb);
        this.possiblyAddDescription(sb);
        this.possiblyAddDefinedIn(sb);
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        return this.getDefinitionString();
    }

    public String getType() {
        return this.type;
    }

    protected void possiblyAddDefinedIn(StringBuffer sb) {
        if (this.definedIn != null) {
            sb.append("<hr>Defined in:");
            sb.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected void possiblyAddDescription(StringBuffer sb) {
        if (this.getShortDescription() != null) {
            sb.append("<hr><br>");
            sb.append(this.getShortDescription());
            sb.append("<br><br><br>");
        }
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

