/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.portal.ContainerPortletFactory;
import com.kingdee.eas.portal.ContainerPortletInfo;
import com.kingdee.eas.portal.DisplayStyleEnum;
import com.kingdee.eas.portal.FlagEnum;
import com.kingdee.eas.portal.IContainerPortlet;
import com.kingdee.eas.portal.IIncPortlets;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.IPortletPreferences;
import com.kingdee.eas.portal.IncPortletsCollection;
import com.kingdee.eas.portal.IncPortletsFactory;
import com.kingdee.eas.portal.IncPortletsInfo;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletCategoryCollection;
import com.kingdee.eas.portal.PortletCategoryInfo;
import com.kingdee.eas.portal.PortletCategoryTreeUtil;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPreferencesFactory;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.app.AbstractContainerPortletFacadeControllerBean;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContainerPortletFacadeControllerBean
extends AbstractContainerPortletFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.app.ContainerPortletFacadeControllerBean");
    private static final MetaDataPK containerPortletQueryPK = new MetaDataPK("com.kingdee.eas.portal.app", "ContainerPortletQuery");

    @Override
    protected List _getContainerPortletList(Context ctx) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        HashMap<String, String> rowMap = null;
        IRowSet rs = null;
        IQueryExecutor exec = this.getQueryExecuter(ctx);
        EntityViewInfo entityViewInfo = exec.getObjectView();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("portletPreferences.id", null, CompareType.IS));
        filter.getFilterItems().add(new FilterItemInfo("portletPreferences.id", (Object)"", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        if (entityViewInfo.getFilter() != null && !StringUtils.isEmpty((String)entityViewInfo.getFilter().toString())) {
            entityViewInfo.getFilter().mergeFilter(filter, "AND");
        } else {
            entityViewInfo.setFilter(filter);
        }
        exec.setObjectView(entityViewInfo);
        rs = exec.executeQuery();
        try {
            while (rs.next()) {
                rowMap = new HashMap<String, String>();
                rowMap.put("id", rs.getString("ID"));
                rowMap.put("portletnumber", rs.getString("PORTLET.PORTLETNUMBER"));
                rowMap.put("portletname", rs.getString("PORTLET.PORTLETNAME"));
                rowMap.put("enable", new Integer(rs.getInt("PORTLET.ENABLE")).toString());
                rowMap.put("displaystyle", rs.getString("STYLE"));
                rowMap.put("description", rs.getString("PORTLET.DESCRIPTION"));
                list.add(rowMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u6784\u9020\u5bb9\u5668portlet\u7ed3\u679c\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        return list;
    }

    private IQueryExecutor getQueryExecuter(Context ctx) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)containerPortletQueryPK);
        EntityViewInfo entityViewInfo = exec.getObjectView();
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("portlet.portletNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        exec.setObjectView(entityViewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = false;
        return exec;
    }

    @Override
    protected HashMap _getContainerPortletById(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> rowMap = new HashMap<String, String>();
        IRowSet rs = null;
        IQueryExecutor exec = this.getQueryExecuter(ctx);
        EntityViewInfo entityViewInfo = exec.getObjectView();
        if (!StringUtils.isEmpty((String)id)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            if (entityViewInfo.getFilter() != null && !StringUtils.isEmpty((String)entityViewInfo.getFilter().toString())) {
                entityViewInfo.getFilter().mergeFilter(filter, "AND");
            } else {
                entityViewInfo.setFilter(filter);
            }
        }
        exec.setObjectView(entityViewInfo);
        rs = exec.executeQuery();
        IPortlet portlet = PortletFactory.getLocalInstance(ctx);
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(id));
        PortletInfo portletInfo = portlet.getPortletInfo((IObjectPK)new ObjectUuidPK(info.getPortlet().getId()));
        try {
            rs.next();
            rowMap.put("id", rs.getString("ID"));
            rowMap.put("portletnumber", rs.getString("PORTLET.PORTLETNUMBER"));
            rowMap.put("portletname_en", portletInfo.getPortletName(new Locale("l1")));
            rowMap.put("portletname_ch", portletInfo.getPortletName(new Locale("l2")));
            rowMap.put("portletname_tw", portletInfo.getPortletName(new Locale("l3")));
            rowMap.put("portletcategoryname", rs.getString("portletcategory.name"));
            rowMap.put("portletcategoryid", rs.getString("portletcategory.id"));
            rowMap.put("enable", new Integer(rs.getInt("PORTLET.ENABLE")).toString());
            rowMap.put("displaystyle", rs.getString("STYLE"));
            rowMap.put("description", rs.getString("PORTLET.DESCRIPTION"));
            rowMap.put("editable", Boolean.valueOf(rs.getBoolean("EDITABLE")).toString());
        }
        catch (SQLException e) {
            logger.error((Object)"\u5728\u83b7\u53d6\u5bb9\u5668portlet\u5185\u5bb9\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
        }
        return rowMap;
    }

    @Override
    protected void _saveContainerPortlet(Context ctx, HashMap infoMap) throws BOSException, EASBizException {
        String containerPortletId = (String)infoMap.get("containerportletid");
        String portletCategoryID = (String)infoMap.get("portletCategoryID");
        String isCover = (String)infoMap.get("isCover");
        String portletCode = (String)infoMap.get("portletnumber");
        String portletName_l1 = (String)infoMap.get("portletname_l1");
        String portletName_l2 = (String)infoMap.get("portletname_l2");
        String portletName_l3 = (String)infoMap.get("portletname_l3");
        String enable = (String)infoMap.get("enable");
        String description = (String)infoMap.get("description");
        String editable = (String)infoMap.get("editable");
        String displayStyle = (String)infoMap.get("displaystyle");
        String[] selectedPortletIds = (String[])infoMap.get("selectedportletids");
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        IPortlet iportlet = PortletFactory.getLocalInstance(ctx);
        IIncPortlets iInc = IncPortletsFactory.getLocalInstance(ctx);
        IPortalServiceFacade service = PortalServiceFacadeFactory.getLocalInstance(ctx);
        if (StringUtils.isEmpty((String)containerPortletId)) {
            PortletExtInfo extInfo = new PortletExtInfo();
            extInfo.setBizInsUrl("/html/portlet/containerportlet/containerPortletSetting.jsp");
            extInfo.setShowTitleArea(1);
            extInfo.setTitle(portletName_l1, new Locale("l1"));
            extInfo.setTitle(portletName_l2, new Locale("l2"));
            extInfo.setTitle(portletName_l3, new Locale("l3"));
            extInfo.setShowTitleAreaBorder(1);
            extInfo.setShowContentAreaBorder(1);
            extInfo.setAttrConfigurable(1);
            PortalUtil.setSuperInfo(ctx, extInfo);
            PortletInfo portletInfo = new PortletInfo();
            if (!StringUtils.isEmpty((String)portletCategoryID)) {
                PortletCategoryInfo pcInfo = new PortletCategoryInfo();
                pcInfo.setId(BOSUuid.read((String)portletCategoryID));
                portletInfo.setPortletCategory(pcInfo);
            }
            portletInfo.setEnable(PortletStateEnum.getEnum(Integer.valueOf(enable)));
            portletInfo.setPortletNumber(portletCode);
            portletInfo.setPortletName(portletName_l1, new Locale("l1"));
            portletInfo.setPortletName(portletName_l2, new Locale("l2"));
            portletInfo.setPortletName(portletName_l3, new Locale("l3"));
            portletInfo.setDescription(description);
            portletInfo.setPortletDefineId("98");
            portletInfo.setFlag(FlagEnum.CONTAINER_FLAG);
            portletInfo.setId(BOSUuid.create((BOSObjectType)portletInfo.getBOSType()));
            portletInfo.setPortletExt(extInfo);
            service.addPortlet(portletInfo);
            ContainerPortletInfo info = new ContainerPortletInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setStyle(DisplayStyleEnum.getEnum(displayStyle));
            info.setEditable(Boolean.valueOf(editable));
            info.setPortlet(portletInfo);
            iCon.addnew(info);
            IncPortletsInfo incInfo = null;
            for (int i = 0; i < selectedPortletIds.length; ++i) {
                incInfo = new IncPortletsInfo();
                incInfo.setOrderNum(i);
                incInfo.setContainerPortlet(info);
                incInfo.setPortlet(iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK(selectedPortletIds[i])));
                incInfo.setId(BOSUuid.create((BOSObjectType)incInfo.getBOSType()));
                iInc.addnew(incInfo);
            }
        } else {
            ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(containerPortletId));
            PortletInfo portletInfo = iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK(info.getPortlet().getId()));
            PortletExtInfo extInfo = portletInfo.getPortletExt();
            extInfo.setTitle(portletName_l1, new Locale("l1"));
            extInfo.setTitle(portletName_l2, new Locale("l2"));
            extInfo.setTitle(portletName_l3, new Locale("l3"));
            portletInfo.setPortletExt(extInfo);
            portletInfo.setEnable(PortletStateEnum.getEnum(Integer.valueOf(enable)));
            if (!StringUtils.isEmpty((String)portletCategoryID)) {
                PortletCategoryInfo pcInfo = new PortletCategoryInfo();
                pcInfo.setId(BOSUuid.read((String)portletCategoryID));
                portletInfo.setPortletCategory(pcInfo);
            }
            portletInfo.setPortletNumber(portletCode);
            portletInfo.setPortletName(portletName_l1, new Locale("l1"));
            portletInfo.setPortletName(portletName_l2, new Locale("l2"));
            portletInfo.setPortletName(portletName_l3, new Locale("l3"));
            portletInfo.setDescription(description);
            service.update(portletInfo.getId(), portletInfo);
            info.setStyle(DisplayStyleEnum.getEnum(displayStyle));
            info.setEditable(Boolean.valueOf(editable));
            iCon.update((IObjectPK)new ObjectUuidPK(containerPortletId), info);
            iInc.delete("where containerPortlet = '" + containerPortletId + "'");
            IncPortletsInfo incInfo = null;
            for (int i = 0; i < selectedPortletIds.length; ++i) {
                incInfo = new IncPortletsInfo();
                incInfo.setOrderNum(i);
                incInfo.setContainerPortlet(info);
                incInfo.setPortlet(iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK(selectedPortletIds[i])));
                incInfo.setId(BOSUuid.create((BOSObjectType)incInfo.getBOSType()));
                iInc.addnew(incInfo);
            }
            if (Boolean.valueOf(isCover).booleanValue()) {
                StringBuffer deleteSql = new StringBuffer();
                deleteSql.append("delete from T_Portal_IncPortlets").append(" where FContainerPortletID in").append(" (select FID from T_Portal_ContainerPortlet where FParentID=?)");
                Object[] param = new Object[]{containerPortletId};
                DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])param);
                iCon.delete("where parent = '" + containerPortletId + "'");
            }
        }
        service.refreshPortletCache();
    }

    @Override
    protected List _getPortletListById(Context ctx, String id) throws BOSException, EASBizException {
        return this._getPortletListById(ctx, id, true);
    }

    @Override
    protected void _deleteContainerPortletById(Context ctx, String id) throws BOSException, EASBizException {
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(id));
        PortletInfo portletInfo = info.getPortlet();
        IPortalServiceFacade service = PortalServiceFacadeFactory.getLocalInstance(ctx);
        service.deletePortlet(portletInfo.getId().toString());
        service.refreshPortletCache();
    }

    @Override
    protected void _enableContainerPortlet(Context ctx, String id) throws BOSException, EASBizException {
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(id));
        PortletInfo portletInfo = info.getPortlet();
        IPortalServiceFacade service = PortalServiceFacadeFactory.getLocalInstance(ctx);
        service.enablePortlet(portletInfo.getId().toString());
        service.refreshPortletCache();
    }

    @Override
    protected void _disableContainerPortlet(Context ctx, String id) throws BOSException, EASBizException {
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(id));
        PortletInfo portletInfo = info.getPortlet();
        IPortalServiceFacade service = PortalServiceFacadeFactory.getLocalInstance(ctx);
        service.disablePortlet(portletInfo.getId().toString());
        service.refreshPortletCache();
    }

    private List array2List(String[] arr) {
        ArrayList<String> list = new ArrayList<String>();
        if (arr == null) {
            return list;
        }
        for (int i = 0; i < arr.length; ++i) {
            list.add(arr[i]);
        }
        return list;
    }

    @Override
    protected void _savePortletsListForSet(Context ctx, HashMap infoMap) throws BOSException, EASBizException {
        String containerPortletId = (String)infoMap.get("containerportletid");
        String isUpdate = (String)infoMap.get("isupdate");
        String portletPreferencesID = (String)infoMap.get("portletpreferencesid");
        String displayStyle = (String)infoMap.get("displaystyle");
        String[] selectedPortletIds = (String[])infoMap.get("selectedportlets");
        String[] newIncIds = (String[])infoMap.get("newIncIds");
        IContainerPortlet iCon = ContainerPortletFactory.getLocalInstance(ctx);
        IPortlet iportlet = PortletFactory.getLocalInstance(ctx);
        IPortletPreferences iportletPreferences = PortletPreferencesFactory.getLocalInstance(ctx);
        IIncPortlets iInc = IncPortletsFactory.getLocalInstance(ctx);
        ContainerPortletInfo info = iCon.getContainerPortletInfo((IObjectPK)new ObjectUuidPK(containerPortletId));
        IncPortletsCollection incColl = iInc.getIncPortletsCollection("where containerPortlet = '" + containerPortletId + "' order by orderNum ASC");
        IncPortletsInfo tmpIncInfo = null;
        PortletInfo tmpPortletInfo = null;
        HashMap<String, IncPortletsInfo> oldMap = new HashMap<String, IncPortletsInfo>();
        ArrayList<String[]> disableList = new ArrayList<String[]>();
        for (int j = 0; j < incColl.size(); ++j) {
            tmpIncInfo = incColl.get(j);
            String oldId = tmpIncInfo.getId().toString();
            String incPortletPortletId = tmpIncInfo.getPortlet().getId().toString();
            tmpPortletInfo = iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK(incPortletPortletId));
            if (0 == tmpPortletInfo.getEnable().getValue()) {
                String[] s = new String[]{"" + j, oldId, incPortletPortletId};
                disableList.add(s);
            }
            oldMap.put(oldId, tmpIncInfo);
        }
        List tmpPortletList = this.array2List(selectedPortletIds);
        List tmpIncList = this.array2List(newIncIds);
        for (String[] values : disableList) {
            int index = Integer.valueOf(values[0]);
            if (index > tmpIncList.size()) {
                tmpIncList.add(values[1]);
                tmpPortletList.add(values[1]);
                continue;
            }
            tmpIncList.add(index, values[1]);
            tmpPortletList.add(index, values[2]);
        }
        if (!Boolean.valueOf(isUpdate).booleanValue()) {
            PortletInfo portletInfo = info.getPortlet();
            PortletPreferencesInfo preferencesInfo = iportletPreferences.getPortletPreferencesInfo((IObjectPK)new ObjectUuidPK(portletPreferencesID));
            ContainerPortletInfo insInfo = new ContainerPortletInfo();
            insInfo.setId(BOSUuid.create((BOSObjectType)insInfo.getBOSType()));
            insInfo.setStyle(DisplayStyleEnum.getEnum(displayStyle));
            insInfo.setEditable(info.isEditable());
            insInfo.setPortlet(portletInfo);
            insInfo.setParent(info);
            insInfo.setPortletPreferences(preferencesInfo);
            iCon.addnew(insInfo);
            IncPortletsInfo incInfo = null;
            for (int i = 0; i < tmpPortletList.size(); ++i) {
                incInfo = new IncPortletsInfo();
                incInfo.setOrderNum(i);
                incInfo.setContainerPortlet(insInfo);
                incInfo.setPortlet(iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK((String)tmpPortletList.get(i))));
                incInfo.setId(BOSUuid.create((BOSObjectType)incInfo.getBOSType()));
                iInc.addnew(incInfo);
            }
        } else {
            info.setStyle(DisplayStyleEnum.getEnum(displayStyle));
            iCon.update((IObjectPK)new ObjectUuidPK(containerPortletId), info);
            IncPortletsInfo incInfo = null;
            for (int i = 0; i < tmpIncList.size(); ++i) {
                String incId = (String)tmpIncList.get(i);
                if (oldMap.containsKey(incId)) {
                    incInfo = (IncPortletsInfo)oldMap.get(incId);
                    incInfo.setOrderNum(i);
                    iInc.update((IObjectPK)new ObjectUuidPK(incId), incInfo);
                    oldMap.remove(incId);
                    continue;
                }
                incInfo = new IncPortletsInfo();
                incInfo.setOrderNum(i);
                incInfo.setContainerPortlet(info);
                incInfo.setPortlet(iportlet.getPortletInfo((IObjectPK)new ObjectUuidPK((String)tmpPortletList.get(i))));
                incInfo.setId(BOSUuid.create((BOSObjectType)incInfo.getBOSType()));
                iInc.addnew(incInfo);
            }
            Iterator iterator = oldMap.keySet().iterator();
            StringBuffer sb = new StringBuffer();
            while (iterator.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(iterator.next()).append("'");
            }
            if (sb.length() > 0) {
                iInc.delete("where id in (" + sb.toString() + ")");
            }
        }
    }

    @Override
    protected List _getPortletListById(Context ctx, String id, boolean containDisablePortlet) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        HashMap<String, String> rowMap = null;
        if (StringUtils.isEmpty((String)id)) {
            return list;
        }
        StringBuffer selectedSql = new StringBuffer();
        selectedSql.append("select a.FID as id, a.FPortletID as portletId,").append(" b.FPortletName_").append(ctx.getLocale()).append(" as portletName,").append(" b.FPortletDefineID as portletDefineId,").append(" c.FBizInsUrl as bizInsUrl,").append(" c.FTitle_").append(ctx.getLocale()).append(" as portletNameExt").append(" from T_Portal_IncPortlets a, T_Portal_Portlet b").append(" left join T_Portal_PortletExt c on c.FID = b.FPortletExtID").append(" where a.FPortletID = b.FID").append(" and a.FContainerPortletID='").append(id).append("'");
        if (!containDisablePortlet) {
            selectedSql.append(" and b.FEnable = 1");
        }
        selectedSql.append(" order by a.FOrderNum ASC");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectedSql.toString());
        try {
            while (rs.next()) {
                rowMap = new HashMap<String, String>();
                rowMap.put("id", rs.getString("id"));
                rowMap.put("portletid", rs.getString("portletId"));
                rowMap.put("portletname", rs.getString("portletName"));
                rowMap.put("portletnameext", rs.getString("portletNameExt"));
                rowMap.put("portletdefineid", rs.getString("portletDefineId"));
                rowMap.put("bizinsurl", rs.getString("bizInsUrl"));
                list.add(rowMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6portlet\u7ed3\u679c\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        return list;
    }

    @Override
    protected String _getPortlets(Context ctx, String id) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        IRowSet rs = this.getAllUsablePortlets(ctx, id);
        Map portletsMap = this.sortOutPortlets2Json(rs, ctx.getLocale());
        PortletCategoryCollection pcc = PortletCategoryTreeUtil.getAllPortletCategory(ctx);
        Map pcMap = PortletCategoryTreeUtil.getPortletCategoryMap(pcc);
        JSONArray reply = PortletCategoryTreeUtil.makePortletsTreeData(locale, pcMap, "root", portletsMap);
        return reply.toString();
    }

    private IRowSet getAllUsablePortlets(Context ctx, String containerPortletId) throws BOSException {
        IRowSet rs = null;
        StringBuffer listSql = new StringBuffer();
        listSql.append("SELECT FID AS ID, FPortletCategoryID AS PortletCategoryID,").append(" FPortletName_").append(ctx.getLocale()).append(" AS PORTLETNAME").append(" FROM T_Portal_Portlet ").append(" WHERE (FEnable = 1) and (FFlag != '008' or FFlag is null)");
        if (!StringUtils.isEmpty((String)containerPortletId)) {
            listSql.append(" and FID not in (select FPortletID from T_Portal_IncPortlets where FContainerPortletID=?)");
            Object[] param = new Object[]{containerPortletId};
            rs = DbUtil.executeQuery((Context)ctx, (String)listSql.toString(), (Object[])param);
        } else {
            rs = DbUtil.executeQuery((Context)ctx, (String)listSql.toString());
        }
        return rs;
    }

    private Map sortOutPortlets2Json(IRowSet rs, Locale locale) {
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray portletsInfoArray = new JSONArray();
        int number = 1;
        try {
            while (rs.next()) {
                String portletCategoryID = rs.getString("PortletCategoryID");
                if (StringUtils.isEmpty((String)portletCategoryID)) {
                    portletCategoryID = "XkGI/dDGlkWJhX5ZEW9lOEPH2a4=";
                }
                portletsInfoArray = !map.containsKey(portletCategoryID) ? new JSONArray() : (JSONArray)map.get(portletCategoryID);
                JSONObject portletInfo = new JSONObject();
                portletInfo.put("id", (Object)rs.getString("ID"));
                portletInfo.put("iconCls", (Object)"x-tree-node-leaf-kd");
                portletInfo.put("text", (Object)rs.getString("PORTLETNAME"));
                portletInfo.put("leaf", (Object)new Boolean(true));
                portletsInfoArray.put((Object)portletInfo);
                map.put(portletCategoryID, portletsInfoArray);
                ++number;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f85\u9009portlet\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        return map;
    }
}

