/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.AbstractPagesInfo;
import com.kingdee.eas.portal.AreaTemplateCollection;
import com.kingdee.eas.portal.AreaTemplateInfo;
import com.kingdee.eas.portal.ColCollection;
import com.kingdee.eas.portal.ColInfo;
import com.kingdee.eas.portal.IPage;
import com.kingdee.eas.portal.IPageFacade;
import com.kingdee.eas.portal.IPages;
import com.kingdee.eas.portal.IPortalFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.IPortletFacade;
import com.kingdee.eas.portal.LayoutInfo;
import com.kingdee.eas.portal.LayoutTemplateFactory;
import com.kingdee.eas.portal.LayoutTemplateInfo;
import com.kingdee.eas.portal.PageCollection;
import com.kingdee.eas.portal.PageDescriptionInfo;
import com.kingdee.eas.portal.PageFacadeFactory;
import com.kingdee.eas.portal.PageFactory;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PageStateEnum;
import com.kingdee.eas.portal.PagesFactory;
import com.kingdee.eas.portal.PagesInfo;
import com.kingdee.eas.portal.PortalFacadeFactory;
import com.kingdee.eas.portal.PortletCategoryCollection;
import com.kingdee.eas.portal.PortletCategoryTreeUtil;
import com.kingdee.eas.portal.PortletFacadeFactory;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPreferencesCollection;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.TabInfo;
import com.kingdee.eas.portal.WindowState;
import com.kingdee.eas.portal.app.AbstractTabDesignServiceFacadeControllerBean;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TabDesignServiceFacadeControllerBean
extends AbstractTabDesignServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.app.TabDesignServiceFacadeControllerBean");
    private static final String METHOD_APPLYTAB = "applyTab";
    private static final String METHOD_ENABLETAB = "enableTab";
    private static final String METHOD_DISABLETAB = "disableTab";
    private static final String METHOD_BLANKOUTTAB = "blankOutTab";
    private static final String METHOD_SETDEFAULTOPEN = "setTabDefaultOpen";
    private static final String OPERSTATE_ADDNEW = "addNew";
    private static final String OPERSTATE_UPDATE = "update";
    private static final String MARK = "edited";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String TRUE = "true";
    private static final String SHOWCREATERPAGES = "ShowCreaterPages";

    @Override
    protected String _loadTreeTabs(Context ctx, String sysType, String tabStyle) throws BOSException, EASBizException {
        JSONArray treeData;
        int tabType = 0;
        if (sysType == null) {
            sysType = "1";
            tabType = 1;
        } else if ("0".equals(sysType)) {
            tabType = 7;
        } else if ("1".equals(sysType)) {
            tabType = 1;
        } else if ("2".equals(sysType)) {
            tabType = 3;
        }
        if (tabStyle == null) {
            tabStyle = "0";
        }
        if (tabStyle.equals("1")) {
            --tabType;
        }
        if ((treeData = this.getTabTreeData(tabType, ctx)) != null) {
            return treeData.toString();
        }
        return null;
    }

    @Override
    protected String _loadPageInfoByPageId(Context ctx, String pageId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("pageDescription.*"));
        selector.add(new SelectorItemInfo("tab.*"));
        selector.add(new SelectorItemInfo("tab.layout.*"));
        selector.add(new SelectorItemInfo("tab.layout.cols.*"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.*"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pageId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IPage iPage = PageFactory.getLocalInstance(ctx);
        CoreBaseCollection pageCollection = iPage.getCollection(viewInfo);
        PageInfo pageInfo = null;
        if (pageCollection != null && pageCollection.size() > 0) {
            pageInfo = (PageInfo)pageCollection.get(0);
            JSONObject pageInfoJSON = this.makePageInfo(ctx, pageInfo);
            return pageInfoJSON.toString();
        }
        return null;
    }

    @Override
    protected String _save(Context ctx, String json) throws BOSException, EASBizException {
        try {
            String parentPageId;
            JSONObject subimtData = new JSONObject(json);
            String sysType = subimtData.getString("sysType");
            String operState = subimtData.getString("operState");
            int operType = subimtData.getInt("operType");
            JSONObject pageInfoJson = (JSONObject)subimtData.get("pageInfo");
            JSONObject descInfoJson = (JSONObject)pageInfoJson.get("descInfo");
            String pageId = pageInfoJson.get("id").toString();
            JSONObject tabInfoJson = null;
            if (pageInfoJson.has("tabInfo")) {
                tabInfoJson = (JSONObject)pageInfoJson.get("tabInfo");
            }
            PageInfo pageInfo = new PageInfo();
            PageInfo pageOldInfo = null;
            PageInfo pageOldInfo2 = null;
            pageInfo.setPages(this.getPagesInfo(ctx, sysType));
            boolean bFlag = false;
            IPage iPage = PageFactory.getLocalInstance(ctx);
            if (pageId.length() <= 0) {
                pageInfo.setId(BOSUuid.create((BOSObjectType)pageInfo.getBOSType()));
                pageInfo.setIsDefaultOpen(0);
                if (operType == 0) {
                    pageInfo.setPageDescription(this.createPageDescriptionInfo(sysType, descInfoJson, PageStateEnum.PAGE_DEF, bFlag));
                } else {
                    pageInfo.setPageDescription(this.createPageDescriptionInfo(sysType, descInfoJson, PageStateEnum.PAGE_RUN, bFlag));
                }
                pageInfo.setNumber(PortalUtil.getCodeRuleNumber());
                pageInfo.setOrderNum(this.getUserPageNum(ctx, sysType));
            } else {
                pageOldInfo = iPage.getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
                if (pageOldInfo != null) {
                    if (operType == 0) {
                        if (pageOldInfo.getPageDescription().getPageState().getValue() != PageStateEnum.PAGE_DEF.getValue()) {
                            pageInfo.setId(BOSUuid.create((BOSObjectType)pageInfo.getBOSType()));
                            pageInfo.setToPage(pageOldInfo.getId().toString());
                            pageInfo.setNumber(PortalUtil.getCodeRuleNumber());
                        } else {
                            bFlag = true;
                            pageInfo.setId(pageOldInfo.getId());
                            pageInfo.setDisplayName(pageOldInfo.getDisplayName());
                            pageInfo.setNumber(pageOldInfo.getNumber());
                            pageInfo.setToPage(pageOldInfo.getToPage());
                        }
                        pageInfo.setIsDefaultOpen(0);
                        pageInfo.setPageDescription(this.createPageDescriptionInfo(sysType, descInfoJson, PageStateEnum.PAGE_DEF, bFlag));
                    } else {
                        bFlag = true;
                        if (pageOldInfo.getToPage() != null) {
                            pageOldInfo2 = pageOldInfo;
                            pageOldInfo = (PageInfo)iPage.getValue((IObjectPK)new ObjectUuidPK(pageOldInfo.getToPage()));
                            pageInfo.setPageDescription(this.createPageDescriptionInfo(sysType, descInfoJson, pageOldInfo.getPageDescription().getPageState(), bFlag));
                        } else {
                            pageInfo.setPageDescription(this.createPageDescriptionInfo(sysType, descInfoJson, PageStateEnum.PAGE_RUN, bFlag));
                        }
                        pageInfo.setId(pageOldInfo.getId());
                        pageInfo.setNumber(PortalUtil.getCodeRuleNumber());
                        pageInfo.setToPage(null);
                        pageInfo.setIsDefaultOpen(pageOldInfo.getIsDefaultOpen());
                        pageInfo.setMark(MARK);
                    }
                    pageInfo.setOrderNum(pageOldInfo.getOrderNum());
                    pageInfo.setFromPage(pageOldInfo.getFromPage());
                    pageInfo.setCopyTime(pageOldInfo.getCopyTime());
                    pageInfo.setParent(pageOldInfo.getParent());
                    pageInfo.setIsDirectory(pageOldInfo.getIsDirectory());
                    pageInfo.setDisplayStyle(pageOldInfo.getDisplayStyle());
                    pageInfo.setIsLeaf(pageOldInfo.isIsLeaf());
                }
            }
            String description = pageInfoJson.getString("description");
            String[] desc = this.getDescriptionArray(description, ctx.getLocale().toString());
            Locale locale1 = new Locale("l1");
            Locale locale2 = new Locale("l2");
            Locale locale3 = new Locale("l3");
            pageInfo.setDescription(desc[0], locale1);
            pageInfo.setDescription(desc[1], locale2);
            pageInfo.setDescription(desc[2], locale3);
            pageInfo.setName(pageInfoJson.getString("name_en"), locale1);
            pageInfo.setName(pageInfoJson.getString("name_ch"), locale2);
            pageInfo.setName(pageInfoJson.getString("name_tw"), locale3);
            pageInfo.setTitle(pageInfoJson.getString("title_en"), locale1);
            pageInfo.setTitle(pageInfoJson.getString("title_ch"), locale2);
            pageInfo.setTitle(pageInfoJson.getString("title_tw"), locale3);
            pageInfo.setPageNumber(pageInfoJson.getString("pageNumber"));
            int isDirectory = 0;
            if (pageInfoJson.has("isDirectory")) {
                isDirectory = pageInfoJson.getInt("isDirectory");
            }
            pageInfo.setIsDirectory(isDirectory);
            if (pageInfoJson.has("pages") && !StringUtils.isEmpty((String)(parentPageId = pageInfoJson.getString("pages")))) {
                PageInfo parentPageInfo = iPage.getPageInfo((IObjectPK)new ObjectUuidPK(parentPageId));
                pageInfo.setParent(parentPageInfo);
            }
            if (pageInfoJson.has("displayStyle")) {
                pageInfo.setDisplayStyle(pageInfoJson.getInt("displayStyle"));
            }
            if (pageInfoJson.has("tabInfo")) {
                pageInfo.setTab(this.createTabInfo(ctx, pageOldInfo, tabInfoJson, bFlag));
            }
            if (pageOldInfo2 != null) {
                boolean isLeaf = pageOldInfo.isIsLeaf();
                CoreBaseCollection pageCollection = this.getPageFromParent(ctx, pageOldInfo.getId().toString());
                if (pageOldInfo.getIsDirectory() == 1) {
                    pageOldInfo.setIsLeaf(true);
                    iPage.tosubmit(pageOldInfo);
                    this._updateParentPage(iPage, pageCollection, null);
                }
                iPage.submitPageData(pageInfo, pageOldInfo2.getId(), pageOldInfo.getId());
                if (pageOldInfo.getIsDirectory() == 1) {
                    pageInfo.setIsLeaf(isLeaf);
                    iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
                    this._updateParentPage(iPage, pageCollection, pageInfo);
                }
            } else {
                if (bFlag && pageInfo.isIsLeaf()) {
                    iPage.submitPageData(pageInfo, pageOldInfo.getId(), null);
                } else {
                    iPage.tosubmit(pageInfo);
                }
                if (pageInfo.getPageDescription().getSysPage() == 2 && !OPERSTATE_ADDNEW.equals(operState)) {
                    PageFacadeFactory.getLocalInstance(ctx).updatepage(pageInfo.getId().toString());
                }
            }
            this.afterMethod(ctx, operState, sysType);
            return pageInfo.getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)"\u4fdd\u5b58\u9875\u7b7e\u6570\u636e\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private String[] getDescriptionArray(String desc, String locale) {
        String[] description = new String[]{"", "", ""};
        if ("l1".equals(locale)) {
            description[0] = desc;
        } else if ("l2".equals(locale)) {
            description[1] = desc;
            description[2] = STConverter.sc2tc((String)desc);
        } else if ("l3".equals(locale)) {
            description[2] = desc;
            description[1] = STConverter.sc2tc((String)desc);
        }
        return description;
    }

    protected void _updateParentPage(IPage iPage, CoreBaseCollection pageCollection, PageInfo parentPage) throws BOSException, EASBizException {
        if (pageCollection != null) {
            for (int i = 0; i < pageCollection.size(); ++i) {
                PageInfo page = (PageInfo)pageCollection.get(i);
                page.setParent(parentPage);
                iPage.tosubmit(page);
            }
        }
    }

    protected CoreBaseCollection getPageFromParent(Context ctx, String parentPageId) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("page.*"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentPageId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IPage iPage = PageFactory.getLocalInstance(ctx);
        CoreBaseCollection pageCollection = iPage.getCollection(viewInfo);
        return pageCollection;
    }

    @Override
    protected String _enableTab(Context ctx, String pageId, String sysType) throws BOSException, EASBizException {
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        if (descInfo.getIsTab() == 1 && (pageInfo.isIsLeaf() || pageInfo.getIsDirectory() == 1)) {
            descInfo.setPageState(PageStateEnum.PAGE_RUN);
            if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 0) {
                IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
                iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, 20);
            } else if (descInfo.getSysPage() == 2 && descInfo.getChangeable() == 0) {
                IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
                PageCollection pagecol = (PageCollection)iPageFacade.getPageCol(pageInfo, String.valueOf(30));
                Iterator it = pagecol.iterator();
                while (it.hasNext()) {
                    PageInfo info = (PageInfo)it.next();
                    info.getPageDescription().setPageState(PageStateEnum.PAGE_RUN);
                    iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info, 20);
                }
            } else if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 1) {
                IPage iPage = PageFactory.getLocalInstance(ctx);
                iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
                IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
                iPageFacade.updatePersonalPage(pageInfo.getId().toString(), PageStateEnum.PAGE_RUN);
            } else {
                IPage iPage = PageFactory.getLocalInstance(ctx);
                iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
            }
        }
        this.afterMethod(ctx, METHOD_ENABLETAB, sysType);
        return TRUE;
    }

    private void updateSubPageState(Context ctx, PageInfo pageInfo, PageStateEnum state, String sysType) throws BOSException, EASBizException {
        StringBuffer getSubPageSql = new StringBuffer();
        getSubPageSql.append("select t1.fid FID from t_portal_page t1, t_portal_pagedescription t3 where t1.fparentid = '");
        getSubPageSql.append(pageInfo.getId());
        getSubPageSql.append("' ");
        getSubPageSql.append("and t1.fpagedescriptionid = t3.fid and t3.fpagestate ");
        if (PageStateEnum.PAGE_STOP.equals((Object)state)) {
            getSubPageSql.append(" = ").append(PageStateEnum.PAGE_RUN.getValue());
        } else if (PageStateEnum.PAGE_DEL.equals((Object)state)) {
            getSubPageSql.append(" <> ").append(PageStateEnum.PAGE_DEL.getValue());
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getSubPageSql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String id = rowSet.getString("FID");
                    if (PageStateEnum.PAGE_STOP.equals((Object)state)) {
                        this._disableTab(ctx, id, sysType);
                        continue;
                    }
                    if (!PageStateEnum.PAGE_DEL.equals((Object)state)) continue;
                    this._blankOutTab(ctx, id, sysType);
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _disableTab(Context ctx, String pageId, String sysType) throws BOSException, EASBizException {
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        if (descInfo.getIsTab() == 1 && (pageInfo.isIsLeaf() || pageInfo.getIsDirectory() == 1)) {
            descInfo.setPageState(PageStateEnum.PAGE_STOP);
            IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
            if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 0) {
                iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, 30);
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_STOP, sysType);
                }
            } else if (descInfo.getSysPage() == 2 && descInfo.getChangeable() == 0) {
                PageCollection pagecol = (PageCollection)iPageFacade.getPageCol(pageInfo, String.valueOf(20));
                Iterator it = pagecol.iterator();
                while (it.hasNext()) {
                    PageInfo info = (PageInfo)it.next();
                    info.getPageDescription().setPageState(PageStateEnum.PAGE_STOP);
                    iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info, 30);
                    if (pageInfo.isIsLeaf()) continue;
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_STOP, sysType);
                }
            } else if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 1) {
                IPage iPage = PageFactory.getLocalInstance(ctx);
                iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
                iPageFacade.updatePersonalPage(pageInfo.getId().toString(), PageStateEnum.PAGE_STOP);
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_STOP, sysType);
                }
            } else {
                iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, 30);
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_STOP, sysType);
                }
            }
        }
        this.afterMethod(ctx, METHOD_DISABLETAB, sysType);
        return TRUE;
    }

    @Override
    protected String _blankOutTab(Context ctx, String pageId, String sysType) throws BOSException, EASBizException {
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        if (descInfo.getIsTab() == 1 && (pageInfo.isIsLeaf() || pageInfo.getIsDirectory() == 1)) {
            descInfo.setPageState(PageStateEnum.PAGE_DEL);
            IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
            if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 0) {
                iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, 40);
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_DEL, sysType);
                }
            } else if (descInfo.getSysPage() == 2 && descInfo.getChangeable() == 0) {
                PageCollection pagecol = (PageCollection)iPageFacade.getPageCol(pageInfo, String.valueOf(30));
                Iterator it = pagecol.iterator();
                while (it.hasNext()) {
                    PageInfo info = (PageInfo)it.next();
                    info.getPageDescription().setPageState(PageStateEnum.PAGE_DEL);
                    iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info, 40);
                    if (pageInfo.isIsLeaf()) continue;
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_DEL, sysType);
                }
            } else if (descInfo.getSysPage() == 1 && descInfo.getChangeable() == 1) {
                IPage iPage = PageFactory.getLocalInstance(ctx);
                iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
                iPageFacade.updatePersonalPage(pageInfo.getId().toString());
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_DEL, sysType);
                }
                if (descInfo.getControlable() == 1) {
                    ArrayList<BOSUuid> tempList = new ArrayList<BOSUuid>(1);
                    tempList.add(pageInfo.getId());
                    DiscretePermissionFactory.getLocalInstance((Context)ctx).removeDiscretePermsByBoId(pageInfo.getBOSType(), tempList);
                }
            } else {
                iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, 40);
                if (!pageInfo.isIsLeaf()) {
                    this.updateSubPageState(ctx, pageInfo, PageStateEnum.PAGE_DEL, sysType);
                }
            }
            iPageFacade.updatePageDef(pageInfo.getId().toString());
            this.afterMethod(ctx, METHOD_BLANKOUTTAB, sysType);
        }
        return TRUE;
    }

    @Override
    protected String _applyTab(Context ctx, String pageId, String sysType) throws BOSException, EASBizException {
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        IPage iPage = PageFactory.getLocalInstance(ctx);
        if (descInfo.getIsTab() == 1 && (pageInfo.isIsLeaf() || pageInfo.getIsDirectory() == 1)) {
            pageInfo.getPageDescription().setPageState(PageStateEnum.PAGE_RUN);
            if (pageInfo.getToPage() != null) {
                BOSUuid oldID = pageInfo.getId();
                PageInfo toPageInfo = (PageInfo)iPage.getValue((IObjectPK)new ObjectUuidPK(pageInfo.getToPage()));
                pageInfo.setId(toPageInfo.getId());
                pageInfo.setNumber(PortalUtil.getCodeRuleNumber());
                pageInfo.getPageDescription().setId(toPageInfo.getPageDescription().getId());
                pageInfo.setToPage(null);
                pageInfo.setOrderNum(toPageInfo.getOrderNum());
                pageInfo.setIsDefaultOpen(toPageInfo.getIsDefaultOpen());
                if (toPageInfo.getIsDirectory() == 1) {
                    pageInfo.setIsLeaf(toPageInfo.isIsLeaf());
                }
                iPage.submitPageData(pageInfo, oldID, null);
            } else {
                iPage.update((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (CoreBaseInfo)pageInfo);
            }
        }
        this.afterMethod(ctx, METHOD_APPLYTAB, sysType);
        return TRUE;
    }

    @Override
    protected String _setTabDefaultOpen(Context ctx, String pageId, String sysType) throws BOSException, EASBizException {
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(pageId));
        IPortalFacade iPortalFacade = PortalFacadeFactory.getLocalInstance(ctx);
        iPortalFacade.isDefaultOpen(pageInfo.getId().toString(), sysType);
        this.afterMethod(ctx, METHOD_SETDEFAULTOPEN, sysType);
        return TRUE;
    }

    @Override
    protected String _moveUp(Context ctx, String currentPageId, String upPageId) throws BOSException, EASBizException {
        JSONObject reply = new JSONObject();
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(currentPageId));
        PageInfo upInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(upPageId));
        int orderNum = pageInfo.getOrderNum();
        pageInfo.setOrderNum(upInfo.getOrderNum());
        upInfo.setOrderNum(orderNum);
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, (IObjectPK)new ObjectUuidPK(upInfo.getId().toString()), (IObjectValue)upInfo);
        reply.put("flag", true);
        reply.put("desc", (Object)"");
        return reply.toString();
    }

    @Override
    protected String _moveDown(Context ctx, String currentPageId, String downPageId) throws BOSException, EASBizException {
        JSONObject reply = new JSONObject();
        PageInfo pageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(currentPageId));
        PageInfo downInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(downPageId));
        int orderNum = pageInfo.getOrderNum();
        pageInfo.setOrderNum(downInfo.getOrderNum());
        downInfo.setOrderNum(orderNum);
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        iPageFacade.updatePage((IObjectPK)new ObjectUuidPK(pageInfo.getId().toString()), (IObjectValue)pageInfo, (IObjectPK)new ObjectUuidPK(downInfo.getId().toString()), (IObjectValue)downInfo);
        reply.put("result", true);
        return reply.toString();
    }

    @Override
    protected String _getPortlets(Context ctx, String sysType) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        IRowSet rs = this.getAllUsablePortlets(ctx, sysType);
        Map portletsMap = this.sortOutPortlets2Json(rs, locale);
        PortletCategoryCollection pcc = PortletCategoryTreeUtil.getAllPortletCategory(ctx);
        Map pcMap = PortletCategoryTreeUtil.getPortletCategoryMap(pcc);
        JSONArray reply = PortletCategoryTreeUtil.makePortletsTreeData(locale, pcMap, "root", portletsMap);
        return reply.toString();
    }

    private IRowSet getAllUsablePortlets(Context ctx, String sysType) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fid id, p.fportletnumber portletnumber, p.fportletcategoryid portletcategoryid");
        sb.append(", p.fportletname_").append(locale).append(" portletname");
        sb.append(", p.fdescription_").append(locale).append(" description");
        sb.append(" from t_portal_portlet p");
        sb.append(" where p.fenable = 1");
        if (!"1".equals(sysType)) {
            IPortletFacade iPortletFacade = PortletFacadeFactory.getLocalInstance(ctx);
            String strTemp = iPortletFacade.getPermissionPortlet();
            if (strTemp == null || strTemp.length() <= 0) {
                strTemp = "''";
            }
            sb.append(" and ( p.fid in(").append(strTemp).append(")");
            sb.append(" or p.fdefinecheck = 0 )");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private String processLongPortletName(String portletName, Locale locale) {
        if (portletName != null && portletName.length() > 10) {
            return portletName.substring(0, 10) + "...";
        }
        if (portletName == null) {
            if ("l1".equals(locale.toString())) {
                return "default";
            }
            return "\u9ed8\u8ba4";
        }
        return portletName;
    }

    private Map sortOutPortlets2Json(IRowSet rs, Locale locale) {
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray portletsInfoArray = new JSONArray();
        int number = 1;
        int portletsSize = rs.size();
        try {
            while (rs.next()) {
                String portletCategoryID = rs.getString("portletcategoryid");
                if (StringUtils.isEmpty((String)portletCategoryID)) {
                    portletCategoryID = "XkGI/dDGlkWJhX5ZEW9lOEPH2a4=";
                }
                portletsInfoArray = !map.containsKey(portletCategoryID) ? new JSONArray() : (JSONArray)map.get(portletCategoryID);
                String portletName = rs.getString("portletName");
                JSONObject portletInfo = new JSONObject();
                portletInfo.put("id", (Object)String.valueOf(number));
                if (number == 1) {
                    portletInfo.put("totalPortletNum", portletsSize);
                }
                portletInfo.put("qtip", (Object)rs.getString("description"));
                portletInfo.put("portletId", (Object)rs.getString("id"));
                portletInfo.put("portletCategoryId", (Object)portletCategoryID);
                portletInfo.put("iconCls", (Object)"x-tree-node-leaf-kd");
                portletInfo.put("text", (Object)this.processLongPortletName(portletName, locale));
                portletInfo.put("leaf", (Object)new Boolean(true));
                portletsInfoArray.put((Object)portletInfo);
                map.put(portletCategoryID, portletsInfoArray);
                ++number;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f85\u9009portlet\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        return map;
    }

    private boolean isNeedUpdateAfterMethod(String methodName) {
        if (methodName == null) {
            return false;
        }
        return methodName.equals(METHOD_APPLYTAB) || methodName.equals(METHOD_ENABLETAB) || methodName.equals(METHOD_BLANKOUTTAB) || methodName.equals(METHOD_DISABLETAB) || methodName.equals(METHOD_SETDEFAULTOPEN) || methodName.equals(OPERSTATE_ADDNEW) || methodName.equals(OPERSTATE_UPDATE);
    }

    private void afterMethod(Context ctx, String methodName, String sysType) {
        if (!this.isNeedUpdateAfterMethod(methodName)) {
            return;
        }
        try {
            IPageFacade pageFacade = PageFacadeFactory.getLocalInstance(ctx);
            if ("1".equals(sysType)) {
                pageFacade.updateNeedState(null, null, 1);
            } else if ("2".equals(sysType)) {
                pageFacade.updateNeedState(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), 1);
            }
        }
        catch (BOSException e1) {
            logger.info((Object)"Bos", (Throwable)e1);
        }
        catch (EASBizException e2) {
            logger.info((Object)"eas", (Throwable)e2);
        }
    }

    private JSONArray getTabTreeData(int tabType, Context ctx) throws BOSException, EASBizException {
        int i;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("page.*"));
        selector.add(new SelectorItemInfo("page.pageDescription.*"));
        selector.add(new SelectorItemInfo("page.tab.*"));
        selector.add(new SelectorItemInfo("page.tab.layout.*"));
        selector.add(new SelectorItemInfo("page.tab.layout.cols.*"));
        selector.add(new SelectorItemInfo("page.tab.layout.cols.portlets.*"));
        selector.add(new SelectorItemInfo("page.creator.*"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemInfo sorterInfo = new SorterItemInfo("createtime");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        boolean isadmin = false;
        boolean onlyShowCreatePages = false;
        if (UserType.SYSTEM.equals((Object)ContextUtil.getCurrentUserInfo((Context)ctx).getType())) {
            isadmin = true;
        } else {
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)SHOWCREATERPAGES);
            logger.info((Object)"==================================================================");
            logger.info((Object)("==getTabTreeData ShowCreaterPages paramValue is: " + paramValue));
            if (TRUE.equals(paramValue)) {
                onlyShowCreatePages = true;
            }
        }
        FilterInfo filter = new FilterInfo();
        switch (tabType) {
            case 0: {
                filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"1", CompareType.EQUALS));
                break;
            }
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"1", CompareType.EQUALS));
                break;
            }
            case 2: 
            case 6: {
                filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"0", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId(), CompareType.EQUALS));
                filter.setMaskString("#0 AND #1 AND #2");
                break;
            }
            case 3: 
            case 7: {
                filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"0", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId(), CompareType.EQUALS));
                filter.setMaskString("#0 AND #1 AND #2");
                break;
            }
            default: {
                filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"0", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId(), CompareType.EQUALS));
                filter.setMaskString("#0 AND #1 AND #2");
            }
        }
        viewInfo.setFilter(filter);
        CoreBaseCollection baseCollection = null;
        AbstractPagesInfo pagesInfo = null;
        PageInfo pageInfo = null;
        PageStateEnum pageState = null;
        int isDirectory = 0;
        ArrayList<PageInfo> pageInfoList = new ArrayList<PageInfo>();
        ArrayList subPageInfoList = new ArrayList();
        ArrayList<PageInfo> tmpPageInfoList = new ArrayList<PageInfo>();
        ArrayList<PageInfo> tmpSubPageInfoList = new ArrayList<PageInfo>();
        ArrayList<PageInfo> tmpSubPageDirInfo = new ArrayList<PageInfo>();
        ArrayList<PageInfo> tmpUnPubPageDirInfo = new ArrayList<PageInfo>();
        IPages iPages = PagesFactory.getLocalInstance(ctx);
        baseCollection = iPages.getCollection(viewInfo);
        int n = baseCollection.size();
        if (n > 0) {
            pagesInfo = (PagesInfo)baseCollection.get(0);
        }
        PageCollection pageCollection = null;
        pageCollection = pagesInfo.getPage();
        int nSize = pageCollection.size();
        boolean bFlag = false;
        List pagelist = null;
        logger.info((Object)("==onlyShowCreatePages1: " + onlyShowCreatePages));
        if (isadmin) {
            logger.info((Object)"==isadmin true");
        }
        if (!isadmin && onlyShowCreatePages && (tabType == 1 || tabType == 0)) {
            logger.info((Object)("==onlyShowCreatePages2: " + onlyShowCreatePages));
            pagelist = this.getPagesList(ctx);
        }
        for (i = 0; i < nSize; ++i) {
            pageInfo = pageCollection.get(i);
            if (!isadmin && onlyShowCreatePages && (tabType == 1 || tabType == 0) && pagelist != null && !pagelist.contains(pageInfo.getId().toString().trim())) continue;
            bFlag = false;
            if (pageInfo.getParent() == null) {
                pageState = pageInfo.getPageDescription().getPageState();
                isDirectory = pageInfo.getIsDirectory();
                switch (tabType) {
                    case 0: {
                        if (pageState.equals((Object)PageStateEnum.PAGE_DEF)) {
                            bFlag = true;
                            if (pageInfo.getIsDirectory() != 1) break;
                            tmpUnPubPageDirInfo.add(pageInfo);
                            break;
                        }
                        if (isDirectory != 1 || !pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP)) break;
                        tmpPageInfoList.add(pageInfo);
                        break;
                    }
                    case 1: {
                        if (!pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP)) break;
                        bFlag = true;
                        break;
                    }
                    case 2: {
                        if (pageState.equals((Object)PageStateEnum.PAGE_DEF) && pageInfo.getPages() != null) {
                            bFlag = true;
                            if (pageInfo.getIsDirectory() != 1) break;
                            tmpUnPubPageDirInfo.add(pageInfo);
                            break;
                        }
                        if (isDirectory != 1 || !pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP)) break;
                        tmpPageInfoList.add(pageInfo);
                        break;
                    }
                    case 3: {
                        if (!pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP) || pageInfo.getPages() == null) break;
                        bFlag = true;
                        break;
                    }
                    case 6: {
                        if (pageState.equals((Object)PageStateEnum.PAGE_DEF) && pageInfo.getPageDescription().getSysPage() != 2) {
                            bFlag = true;
                            if (pageInfo.getIsDirectory() != 1) break;
                            tmpUnPubPageDirInfo.add(pageInfo);
                            break;
                        }
                        if (isDirectory != 1 || !pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP)) break;
                        tmpPageInfoList.add(pageInfo);
                        break;
                    }
                    case 7: {
                        if (!pageState.equals((Object)PageStateEnum.PAGE_RUN) && !pageState.equals((Object)PageStateEnum.PAGE_STOP) || pageInfo.getPageDescription().getSysPage() == 2) break;
                        bFlag = true;
                        break;
                    }
                }
                if (!bFlag) continue;
                pageInfoList.add(pageInfo);
                continue;
            }
            pageState = pageInfo.getPageDescription().getPageState();
            if ((tabType == 1 || tabType == 3 || tabType == 7) && (pageState.equals((Object)PageStateEnum.PAGE_RUN) || pageState.equals((Object)PageStateEnum.PAGE_STOP))) {
                subPageInfoList.add(pageInfo);
            } else if ((tabType == 0 || tabType == 2 || tabType == 6) && pageState.equals((Object)PageStateEnum.PAGE_DEF)) {
                subPageInfoList.add(pageInfo);
                if (pageInfo.getIsDirectory() == 1) {
                    tmpUnPubPageDirInfo.add(pageInfo);
                }
            } else if ((tabType == 0 || tabType == 2 || tabType == 6) && pageInfo.getIsDirectory() == 1 && (pageState.equals((Object)PageStateEnum.PAGE_RUN) || pageState.equals((Object)PageStateEnum.PAGE_STOP))) {
                tmpSubPageDirInfo.add(pageInfo);
            }
            if (tabType != 0 && tabType != 2 && tabType != 6 || pageState.equals((Object)PageStateEnum.PAGE_DEL)) continue;
            tmpSubPageInfoList.add(pageInfo);
        }
        if (tabType == 0 || tabType == 2 || tabType == 6) {
            PageInfo tmpPageInfo;
            for (i = 0; i < tmpUnPubPageDirInfo.size(); ++i) {
                tmpPageInfo = (PageInfo)tmpUnPubPageDirInfo.get(i);
                if (tmpPageInfo.isIsLeaf()) continue;
                ArrayList al = this.addUnPublistPage(tmpPageInfo, tmpSubPageInfoList);
                subPageInfoList = this.addArrayList(al, subPageInfoList);
            }
            for (i = 0; i < tmpSubPageDirInfo.size(); ++i) {
                tmpPageInfo = (PageInfo)tmpSubPageDirInfo.get(i);
                if (!this.isDirectoryUnPublish(tmpPageInfo, tmpSubPageInfoList) || subPageInfoList.contains(tmpPageInfo)) continue;
                subPageInfoList.add(tmpPageInfo);
            }
            for (i = 0; i < tmpPageInfoList.size(); ++i) {
                tmpPageInfo = (PageInfo)tmpPageInfoList.get(i);
                if (!this.isDirectoryUnPublish(tmpPageInfo, subPageInfoList)) continue;
                pageInfoList.add(tmpPageInfo);
            }
        }
        logger.info((Object)"==================================================================");
        if (pageInfoList.size() > 0) {
            return this.makePageDirectoryData(null, pageInfoList, subPageInfoList, 0, ctx);
        }
        return null;
    }

    private ArrayList addUnPublistPage(PageInfo pageInfo, ArrayList subPageInfoList) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < subPageInfoList.size(); ++i) {
            PageInfo tmpPageInfo = (PageInfo)subPageInfoList.get(i);
            if (tmpPageInfo.getParent() == null || !tmpPageInfo.getParent().getId().equals((Object)pageInfo.getId())) continue;
            PageStateEnum pageState = tmpPageInfo.getPageDescription().getPageState();
            if (!pageState.equals((Object)PageStateEnum.PAGE_DEF)) {
                result.add(tmpPageInfo);
            }
            if (tmpPageInfo.isIsLeaf()) continue;
            result = this.addArrayList(this.addUnPublistPage(tmpPageInfo, subPageInfoList), result);
        }
        return result;
    }

    private ArrayList addArrayList(ArrayList fromArray, ArrayList toArray) {
        for (int i = 0; i < fromArray.size(); ++i) {
            PageInfo pageInfo = (PageInfo)fromArray.get(i);
            if (toArray.contains(pageInfo)) continue;
            toArray.add(pageInfo);
        }
        return toArray;
    }

    private boolean isDirectoryUnPublish(PageInfo pageInfo, ArrayList subPageInfoList) {
        boolean flag = false;
        int isDirectory = pageInfo.getIsDirectory();
        PageStateEnum pageState = null;
        int subIsDirectory = 0;
        if (isDirectory == 1) {
            for (int i = 0; i < subPageInfoList.size(); ++i) {
                boolean subFlag;
                PageInfo subPageInfo = (PageInfo)subPageInfoList.get(i);
                PageInfo parentPage = subPageInfo.getParent();
                if (pageInfo == null || !pageInfo.getId().equals((Object)parentPage.getId())) continue;
                subIsDirectory = subPageInfo.getIsDirectory();
                pageState = subPageInfo.getPageDescription().getPageState();
                if (pageState.equals((Object)PageStateEnum.PAGE_DEF)) {
                    flag = true;
                    break;
                }
                if (subIsDirectory != 1 || !(subFlag = this.isDirectoryUnPublish(subPageInfo, subPageInfoList))) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private List getPagesList(Context ctx) throws BOSException {
        logger.info((Object)("==getPagesList userid---" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        String sqlStr = "select id where creator.id ='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
        IPage ipage = PageFactory.getLocalInstance(ctx);
        PageCollection pagesIdList = ipage.getPageCollection(sqlStr);
        return ToolUtils.transCol2ListByPeroperty((AbstractObjectCollection)pagesIdList, (IObjectCol2List)new IObjectCol2List(){

            public String getList(Object obj) {
                return ((PageInfo)obj).getId().toString().trim();
            }
        });
    }

    private String getPageDescInfoSummary(PageInfo pageInfo, Context ctx) {
        String strDesc;
        String str = "";
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        str = descInfo.getSysPage() == 1 ? str + "\u3010" + pageInfo.getName() + "\u3011" : str + pageInfo.getName();
        if (pageInfo.getIsDefaultOpen() == 1) {
            String defaultStr = ResourceListenerManager.getString((IMetaDataPK)new MetaDataPK("com.kingdee.eas.portal.portalPublic"), (BOSObjectType)MetaDataTypeList.RESOURCE_TYPE, (Locale)ctx.getLocale(), (String)"defaultOpen");
            if (StringUtils.isEmpty((String)defaultStr)) {
                defaultStr = EASCommonResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"defaultOpen", (Locale)ctx.getLocale());
            }
            str = str + "(" + defaultStr + ")  ";
        }
        if (descInfo.getPageState().equals((Object)PageStateEnum.PAGE_DEF)) {
            str = str + "(" + PageStateEnum.PAGE_DEF.getAlias() + ") ";
        } else if (descInfo.getPageState().equals((Object)PageStateEnum.PAGE_RUN)) {
            str = str + "(" + PageStateEnum.PAGE_RUN.getAlias() + ") ";
        } else if (descInfo.getPageState().equals((Object)PageStateEnum.PAGE_STOP)) {
            str = str + "(" + PageStateEnum.PAGE_STOP.getAlias() + ") ";
        }
        if ("\u555f\u7528".indexOf(str) > 0) {
            logger.info((Object)("Bug(BT430743)\u8ddf\u8e2a\uff1a\u68c0\u67e5\u662f\u5426\u51fa\u73b0\u5728\u7b80\u4f53\u73af\u5883\u4e0b\u201c\u542f\u7528\u201d\u4e3a\u7e41\u4f53\u7684\u95ee\u9898\u3002\u5f53\u524d\u73af\u5883\uff1a  \u9700\u8981\u68c0\u67e5\u7684\u5b57\u7b26\u4e32=" + str + "  ,ctx.getLocale().getCountry()=" + ctx.getLocale().getCountry() + "  ,ContextUtils.getOriginalLocaleFromEnv().getCountry()=" + ContextUtils.getOriginalLocaleFromEnv().getCountry() + "  ,LocaleUtils.getDefaultLocale().getCountry()=" + LocaleUtils.getDefaultLocale().getCountry()));
        }
        if (descInfo.getControlable() == 1) {
            str = str + " (" + EASCommonResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"needAthourized", (Locale)ctx.getLocale()) + ") ";
        }
        if ((strDesc = pageInfo.getDescription()) != null && !strDesc.equals("")) {
            str = str + strDesc;
        }
        return str;
    }

    private JSONArray makePageDirectoryData(PageInfo pageInfo, ArrayList pageInfoList, ArrayList subPageInfoList, int treeId, Context ctx) throws BOSException {
        JSONArray pageInfoArray = new JSONArray();
        JSONObject lastSubPage = new JSONObject();
        boolean leafFlag = false;
        boolean isTopLevel = true;
        if (pageInfoList == null) {
            pageInfoList = subPageInfoList;
            isTopLevel = false;
        }
        for (int i = 0; i < pageInfoList.size(); ++i) {
            PageInfo subPageInfo = (PageInfo)pageInfoList.get(i);
            JSONObject pageNodeInfo = new JSONObject();
            JSONArray directoryArray = new JSONArray();
            PageInfo parentPage = subPageInfo.getParent();
            leafFlag = true;
            if ((parentPage == null || !parentPage.getId().equals((Object)pageInfo.getId())) && !isTopLevel) continue;
            int isDirectory = subPageInfo.getIsDirectory();
            if (isDirectory == 1) {
                directoryArray = this.makePageDirectoryData(subPageInfo, null, subPageInfoList, treeId + 1, ctx);
                if (directoryArray.length() < 1) {
                    leafFlag = true;
                } else {
                    leafFlag = false;
                    lastSubPage = (JSONObject)directoryArray.get(directoryArray.length() - 1);
                    treeId = lastSubPage.getInt("id");
                }
            }
            PageDescriptionInfo descInfo = subPageInfo.getPageDescription();
            JSONObject descInfoJson = new JSONObject();
            descInfoJson.put("isTab", (Object)new Integer(descInfo.getIsTab()));
            descInfoJson.put("sysPage", (Object)new Integer(descInfo.getSysPage()));
            descInfoJson.put("changeable", (Object)new Integer(descInfo.getChangeable()));
            descInfoJson.put("visibleable", (Object)new Integer(descInfo.getVisibleable()));
            descInfoJson.put("pageState", (Object)new Integer(descInfo.getPageState().getValue()));
            pageNodeInfo.put("id", (Object)String.valueOf(treeId + 1));
            pageNodeInfo.put("pageId", (Object)subPageInfo.getId().toString());
            pageNodeInfo.put("text", (Object)this.getPageDescInfoSummary(subPageInfo, ctx));
            pageNodeInfo.put("isLeaf", (Object)new Boolean(subPageInfo.isIsLeaf()));
            pageNodeInfo.put("hasSubPage", this.isExitSubPage(ctx, subPageInfo));
            pageNodeInfo.put("visible", (Object)new Integer(subPageInfo.getVisible()));
            pageNodeInfo.put("isDefaultOpen", (Object)new Integer(subPageInfo.getIsDefaultOpen()));
            pageNodeInfo.put("descInfo", (Object)descInfoJson);
            if (subPageInfo.getIsDirectory() == 1) {
                pageNodeInfo.put("iconCls", (Object)"x-tree-node-kd");
            }
            pageNodeInfo.put("leaf", leafFlag);
            pageNodeInfo.put("expanded", (Object)new Boolean(false));
            pageNodeInfo.put("isDirectory", (Object)new Integer(subPageInfo.getIsDirectory()));
            if (!leafFlag) {
                pageNodeInfo.put("children", (Object)directoryArray);
                pageNodeInfo.put("hasRunSubPage", this.isExitPageState(directoryArray, PageStateEnum.PAGE_RUN));
            } else {
                pageNodeInfo.put("hasRunSubPage", false);
            }
            if (!isTopLevel) {
                pageNodeInfo.put("parentPageId", (Object)parentPage.getId().toString());
            }
            pageNodeInfo.put("level", (Object)new Integer(subPageInfo.getLevel()));
            pageInfoArray.put((Object)pageNodeInfo);
            ++treeId;
        }
        return pageInfoArray;
    }

    private boolean isExitPageState(JSONArray childrenArray, PageStateEnum state) {
        boolean flag = false;
        int pageState = new Integer(state.getValue());
        for (int i = 0; i < childrenArray.length(); ++i) {
            JSONArray childArray;
            JSONObject child = childrenArray.getJSONObject(i);
            JSONObject descInfo = child.getJSONObject("descInfo");
            int childState = descInfo.getInt("pageState");
            if (pageState == childState) {
                return true;
            }
            if (!child.has("children") || !(flag = this.isExitPageState(childArray = child.getJSONArray("children"), state))) continue;
            return flag;
        }
        return flag;
    }

    private boolean isExitSubPage(Context ctx, PageInfo pageInfo) throws BOSException {
        boolean flag = false;
        StringBuffer getSubPageSql = new StringBuffer();
        getSubPageSql.append("select count(t1.fid) NUM from t_portal_page t1, t_portal_pagedescription t3 where t1.fparentid = '");
        getSubPageSql.append(pageInfo.getId());
        getSubPageSql.append("' ");
        getSubPageSql.append("and t1.fpagedescriptionid = t3.fid and t3.fpagestate <> ");
        getSubPageSql.append(PageStateEnum.PAGE_DEL.getValue());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getSubPageSql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                int num = rowSet.getInt("NUM");
                flag = num > 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flag;
    }

    private JSONObject makePageInfo(Context ctx, PageInfo pageInfo) throws EASBizException, BOSException, UuidException {
        TabInfo tabInfo = pageInfo.getTab();
        PageDescriptionInfo descInfo = pageInfo.getPageDescription();
        JSONObject pageInfoJSON = new JSONObject();
        JSONObject descInfoJSON = new JSONObject();
        JSONObject tabInfoJSON = new JSONObject();
        descInfoJSON.put("sysPage", (Object)new Integer(descInfo.getSysPage()));
        descInfoJSON.put("visibleable", (Object)new Integer(descInfo.getVisibleable()));
        descInfoJSON.put("changeable", (Object)new Integer(descInfo.getChangeable()));
        descInfoJSON.put("controlable", (Object)new Integer(descInfo.getControlable()));
        descInfoJSON.put("isTab", (Object)new Integer(descInfo.getIsTab()));
        descInfoJSON.put("pageState", (Object)new Integer(descInfo.getPageState().getValue()));
        if (tabInfo != null) {
            LayoutInfo layoutInfo = tabInfo.getLayout();
            String templateId = "";
            if (layoutInfo.getTemplate() != null) {
                templateId = layoutInfo.getTemplate().getId().toString();
            }
            ColCollection cc = layoutInfo.getCols();
            JSONArray cols = new JSONArray();
            JSONArray portletsId = new JSONArray();
            JSONObject layoutConfig = new JSONObject();
            int DESIGN_WIDTH = 562;
            layoutConfig.put(WIDTH, 562);
            layoutConfig.put(HEIGHT, 390);
            JSONArray cells = new JSONArray();
            for (int i = 0; i < cc.size(); ++i) {
                ColInfo colInfo = cc.get(i);
                PortletPreferencesCollection ppc = colInfo.getPortlets();
                JSONObject col = new JSONObject();
                JSONArray portlets = new JSONArray();
                JSONObject cell = new JSONObject();
                int orderNum = colInfo.getOrderNum();
                int areaFloat = colInfo.getAreaFloat();
                float marginLeft = colInfo.getMarginLeft();
                float marginRight = colInfo.getMarginRight();
                float areaWidth = colInfo.getAreaWidth();
                StringBuffer areaFloatStr = new StringBuffer("'portal-area-design-");
                String widthStr = "";
                StringBuffer marginStr = new StringBuffer();
                if (areaFloat == 0) {
                    areaFloatStr.append("left'");
                } else if (areaFloat == 1) {
                    areaFloatStr.append("right'");
                } else if (areaFloat == 2) {
                    areaFloatStr.append("none'");
                }
                marginStr.append("'0 ");
                if (marginRight == 0.0f) {
                    marginStr.append("0 ");
                } else {
                    marginStr.append(marginRight * 562.0f / 1024.0f).append("px ");
                }
                marginStr.append("0 ");
                if (marginLeft == 0.0f) {
                    marginStr.append("0'");
                } else {
                    marginStr.append(marginLeft * 562.0f / 1024.0f).append("px'");
                }
                if (areaWidth == 0.0f) {
                    widthStr = "auto";
                } else if (areaWidth > 0.0f && areaWidth < 1.0f) {
                    widthStr = areaWidth * 100.0f + "%";
                } else if (areaWidth > 1.0f) {
                    widthStr = areaWidth * (float)DESIGN_WIDTH / 1024.0f + "";
                }
                JSONObject styleConfig = new JSONObject();
                styleConfig.put("margin", (Object)marginStr);
                styleConfig.put(WIDTH, (Object)widthStr);
                if (templateId.equals("fTTN+uuUF0ypHBwoy/L+VeEahKQ=") && orderNum > 1 || "6RsE0BuNIk2AFLoDxOyjEeEahKQ=".equals(templateId)) {
                    styleConfig.put(HEIGHT, (Object)"50%");
                } else if ("EkmYaBusnkeEMMKXSACMS+EahKQ=".equals(templateId)) {
                    styleConfig.put(HEIGHT, (Object)"33.333298%");
                } else {
                    styleConfig.put(HEIGHT, (Object)"100%");
                }
                cell.put("cssConfig", (Object)areaFloatStr);
                cell.put("styleConfig", (Object)styleConfig);
                cells.put(orderNum - 1, (Object)cell);
                cells.put(i, (Object)cell);
                for (int j = 0; j < ppc.size(); ++j) {
                    PortletPreferencesInfo pp = ppc.get(j);
                    IPortlet iPortlet = PortletFactory.getLocalInstance(ctx);
                    PortletInfo portletInfo = iPortlet.getPortletInfo((IObjectPK)new ObjectUuidPK(pp.getPortletID()));
                    String title = portletInfo.getPortletName(ctx.getLocale());
                    String pcId = "XkGI/dDGlkWJhX5ZEW9lOEPH2a4=";
                    if (portletInfo.getPortletCategory() != null) {
                        pcId = portletInfo.getPortletCategory().getId().toString();
                    }
                    JSONObject portlet = new JSONObject();
                    if (title == null) {
                        title = ctx.getLocale().toString().equals("l1") ? "default" : (ctx.getLocale().toString().equals("l2") ? "\u9ed8\u8ba4" : (ctx.getLocale().toString().equals("l3") ? "\u9ed8\u8ba4" : "\u9ed8\u8ba4"));
                    }
                    portlet.put("title", (Object)title);
                    portlet.put("portletId", (Object)pp.getPortletID());
                    portlet.put("portletCategoryId", (Object)pcId);
                    portlets.put(j, (Object)portlet);
                    portletsId.put((Object)pp.getPortletID());
                }
                col.put("orderNum", (Object)new Integer(i));
                col.put("portlets", (Object)portlets);
                cols.put(i, (Object)col);
            }
            layoutConfig.put("cells", (Object)cells);
            JSONObject layoutData = new JSONObject();
            layoutData.put("cols", (Object)cols);
            JSONObject layout = new JSONObject();
            layout.put("layoutId", null);
            layout.put("templateId", (Object)templateId);
            layout.put("layoutConfig", (Object)layoutConfig);
            layout.put("layoutData", (Object)layoutData);
            layout.put("portletsId", (Object)portletsId);
            tabInfoJSON.put("layout", (Object)layout);
            tabInfoJSON.put("maximizedPortlet", (Object)tabInfo.getMaximizedPortlet());
            tabInfoJSON.put("moveable", (Object)new Integer(tabInfo.getMoveable()));
            tabInfoJSON.put("closeable", (Object)new Integer(tabInfo.getCloseable()));
            tabInfoJSON.put("maxminable", (Object)new Integer(tabInfo.getMaxminable()));
            tabInfoJSON.put("singlePortlet", (Object)new Integer(tabInfo.getSinglePortlet()));
            tabInfoJSON.put("borderVisible", (Object)new Integer(tabInfo.getBorderVisible()));
            tabInfoJSON.put("autofreshable", (Object)new Integer(tabInfo.getAutofreshable()));
            pageInfoJSON.put("tabInfo", (Object)tabInfoJSON);
        }
        pageInfoJSON.put("descInfo", (Object)descInfoJSON);
        pageInfoJSON.put("id", (Object)pageInfo.getId().toString());
        pageInfoJSON.put("orderNum", (Object)new Integer(pageInfo.getOrderNum()));
        pageInfoJSON.put("isDefaultOpen", (Object)new Integer(pageInfo.getIsDefaultOpen()));
        pageInfoJSON.put("title_en", (Object)pageInfo.getTitle(new Locale("l1")));
        pageInfoJSON.put("title_ch", (Object)pageInfo.getTitle(new Locale("l2")));
        pageInfoJSON.put("title_tw", (Object)pageInfo.getTitle(new Locale("l3")));
        pageInfoJSON.put("pageNumber", (Object)pageInfo.getPageNumber());
        pageInfoJSON.put("name_en", (Object)pageInfo.getName(new Locale("l1")));
        pageInfoJSON.put("name_ch", (Object)pageInfo.getName(new Locale("l2")));
        pageInfoJSON.put("name_tw", (Object)pageInfo.getName(new Locale("l3")));
        pageInfoJSON.put("visible", (Object)new Integer(pageInfo.getVisible()));
        pageInfoJSON.put("description", (Object)pageInfo.getDescription(ctx.getLocale()));
        pageInfoJSON.put("fromPage", (Object)(pageInfo.getFromPage() == null ? new String("") : pageInfo.getFromPage()));
        pageInfoJSON.put("toPage", (Object)(pageInfo.getToPage() == null ? new String("") : pageInfo.getToPage()));
        pageInfoJSON.put("displayStyle", (Object)new Integer(pageInfo.getDisplayStyle()));
        pageInfoJSON.put("level", pageInfo.getLevel());
        PageInfo parentPage = pageInfo.getParent();
        if (parentPage != null) {
            BOSUuid parentPageId = pageInfo.getParent().getId();
            PageInfo parentPageInfo = PageFactory.getLocalInstance(ctx).getPageInfo((IObjectPK)new ObjectUuidPK(parentPageId));
            String name_en = parentPageInfo == null ? "" : parentPageInfo.getName(new Locale("l1"));
            String name_ch = parentPageInfo == null ? "" : parentPageInfo.getName(new Locale("l2"));
            String name_tw = parentPageInfo == null ? "" : parentPageInfo.getName(new Locale("l3"));
            pageInfoJSON.put("parentName_en", (Object)name_en);
            pageInfoJSON.put("parentName_ch", (Object)name_ch);
            pageInfoJSON.put("parentName_tw", (Object)name_tw);
        }
        return pageInfoJSON;
    }

    private PagesInfo getPagesInfo(Context ctx, String sysType) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        FilterInfo filter = new FilterInfo();
        if ("1".equals(sysType)) {
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"1", CompareType.EQUALS));
            viewInfo.setFilter(filter);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"0", CompareType.EQUALS));
            filter.setMaskString(" #0 AND #1 AND #2");
            viewInfo.setFilter(filter);
        }
        SorterItemInfo sorterInfo = new SorterItemInfo("createtime");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        IPages iPages = PagesFactory.getLocalInstance(ctx);
        PagesInfo pagesInfo = null;
        CoreBaseCollection pagesCollection = null;
        if (iPages.exists(filter)) {
            pagesCollection = iPages.getCollection(viewInfo);
            if (pagesCollection != null && pagesCollection.size() > 0) {
                pagesInfo = (PagesInfo)pagesCollection.get(0);
            }
        } else {
            int numSysType = -1;
            pagesInfo = new PagesInfo();
            numSysType = "0".equals(sysType) ? 0 : ("1".equals(sysType) ? 1 : 2);
            pagesInfo.setIsDefault(numSysType);
            pagesInfo.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            pagesInfo.setId(BOSUuid.read((String)iPages.addnew((CoreBaseInfo)pagesInfo).toString()));
        }
        return pagesInfo;
    }

    private PageDescriptionInfo createPageDescriptionInfo(String sysType, JSONObject descInfoJson, PageStateEnum tempEnum, boolean bFlag) {
        PageDescriptionInfo descInfo = new PageDescriptionInfo();
        PortalUtil.setSuperInfo(descInfo);
        descInfo.setPageState(tempEnum);
        descInfo.setVisibleable(descInfoJson.getInt("visibleable") == 0 ? 0 : 1);
        descInfo.setChangeable(descInfoJson.getInt("changeable") == 0 ? 0 : 1);
        descInfo.setControlable(descInfoJson.getInt("controlable") == 0 ? 0 : 1);
        descInfo.setIsTab(1);
        if (sysType.equals("1")) {
            descInfo.setSysPage(1);
        } else if (sysType.equals("0")) {
            descInfo.setSysPage(0);
        } else {
            descInfo.setSysPage(2);
        }
        return descInfo;
    }

    private int getUserPageNum(Context ctx, String sysType) throws EASBizException, BOSException {
        IPortalFacade iPortalFacade = PortalFacadeFactory.getLocalInstance(ctx);
        if ("1".equals(sysType)) {
            return iPortalFacade.getDefaultPageNum() + 1;
        }
        return iPortalFacade.getUserPageNum() + 1;
    }

    private TabInfo createTabInfo(Context ctx, PageInfo pageOldInfo, JSONObject tabInfoJson, boolean bFlag) throws EASBizException, BOSException {
        TabInfo tabInfo = new TabInfo();
        if (bFlag) {
            tabInfo.setId(pageOldInfo.getTab().getId());
        }
        PortalUtil.setSuperInfo(tabInfo);
        tabInfo.setMoveable(tabInfoJson.getInt("moveable") == 0 ? 0 : 1);
        tabInfo.setCloseable(tabInfoJson.getInt("closeable") == 0 ? 0 : 1);
        tabInfo.setMaxminable(tabInfoJson.getInt("maxminable") == 0 ? 0 : 1);
        tabInfo.setSinglePortlet(tabInfoJson.getInt("singlePortlet") == 0 ? 0 : 1);
        tabInfo.setBorderVisible(tabInfoJson.getInt("borderVisible") == 0 ? 2 : 1);
        if (tabInfoJson.has("autofreshable")) {
            tabInfo.setAutofreshable(tabInfoJson.getInt("autofreshable") == 0 ? 0 : 1);
        }
        tabInfo.setMaximizedPortlet(null);
        if (tabInfoJson.has("layout")) {
            tabInfo.setLayout(this.createLayoutInfo(ctx, tabInfoJson));
        }
        return tabInfo;
    }

    private LayoutInfo createLayoutInfo(Context ctx, JSONObject tabInfoJson) throws EASBizException, BOSException {
        JSONObject layout = tabInfoJson.getJSONObject("layout");
        JSONObject layoutData = layout.getJSONObject("layoutData");
        String templateId = layout.getString("templateId");
        LayoutTemplateInfo templateInfo = LayoutTemplateFactory.getLocalInstance(ctx).getLayoutTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
        AreaTemplateCollection areaTemplateCollection = templateInfo.getAreaTpls();
        int areaSize = areaTemplateCollection.size();
        AreaTemplateInfo[] areaTemplateInfoArray = new AreaTemplateInfo[areaSize];
        for (int j = 0; j < areaSize; ++j) {
            AreaTemplateInfo areaTemplateInfo;
            areaTemplateInfoArray[areaTemplateInfo.getOrderNum() - 1] = areaTemplateInfo = areaTemplateCollection.get(j);
        }
        JSONArray cols = layoutData.getJSONArray("cols");
        int colsNum = cols.length();
        LayoutInfo layoutInfo = new LayoutInfo();
        layoutInfo.setColNum(colsNum);
        layoutInfo.setTemplate(templateInfo);
        layoutInfo.setLeftHide(templateInfo.getLeftHide());
        layoutInfo.setRightHide(templateInfo.getRightHide());
        if (templateId.equals("Degc49wCFkW1Bm0PBYVWeuEahKQ=")) {
            layoutInfo.setWideColNum(1);
        } else if (templateId.equals("UAZHESRVG0uyVYE+Cw9+FOEahKQ=")) {
            layoutInfo.setWideColNum(2);
        } else if (templateId.equals("Sz3CExkDOEGtD8TYAJjIeeEahKQ=")) {
            layoutInfo.setWideColNum(2);
        } else if (templateId.equals("fTTN+uuUF0ypHBwoy/L+VeEahKQ=")) {
            layoutInfo.setWideColNum(2);
        } else if (templateId.equals("FjbnIyzzu0SXaXUD8JluiOEahKQ=")) {
            layoutInfo.setWideColNum(3);
        } else if (templateId.equals("grQMjiHPxEmb6ZlmaIU8u+EahKQ=")) {
            layoutInfo.setWideColNum(1);
        } else if (templateId.equals("EkmYaBusnkeEMMKXSACMS+EahKQ=")) {
            layoutInfo.setWideColNum(1);
        } else if (templateId.equals("6RsE0BuNIk2AFLoDxOyjEeEahKQ=")) {
            layoutInfo.setWideColNum(1);
        }
        for (int i = 0; i < colsNum; ++i) {
            layoutInfo.getCols().add(this.createColInfo(ctx, i, cols.get(i), areaTemplateInfoArray[i], tabInfoJson));
        }
        PortalUtil.setSuperInfo(layoutInfo);
        return layoutInfo;
    }

    private ColInfo createColInfo(Context ctx, int nCol, Object col, AreaTemplateInfo areaTemplateInfo, JSONObject tabInfoJson) {
        ColInfo colInfo = new ColInfo();
        PortletPreferencesInfo info = null;
        PortalUtil.setSuperInfo(colInfo);
        colInfo.setOrderNum(nCol);
        colInfo.setAdaptive(areaTemplateInfo.getAdaptive());
        colInfo.setAreaWidth(areaTemplateInfo.getAreaWidth());
        colInfo.setAreaFloat(areaTemplateInfo.getAreaFloat());
        colInfo.setMarginLeft(areaTemplateInfo.getMarginLeft());
        colInfo.setMarginRight(areaTemplateInfo.getMarginRight());
        JSONObject colJson = (JSONObject)col;
        JSONArray portlets = (JSONArray)colJson.get("portlets");
        for (int i = 0; i < portlets.length(); ++i) {
            JSONObject portlet = portlets.getJSONObject(i);
            info = new PortletPreferencesInfo();
            info.setPortletID(portlet.getString("portletId"));
            info.setOrderNum(i);
            info.setCol(null);
            info.setAction("view");
            PortalUtil.setSuperInfo(info);
            info.setEnable(1);
            info.setWindowState(WindowState.NORMAL);
            this.setPortletPreferencesInfo(info, tabInfoJson);
            colInfo.getPortlets().add(info);
        }
        colInfo.setLayout(null);
        return colInfo;
    }

    private PortletPreferencesInfo setPortletPreferencesInfo(PortletPreferencesInfo info, JSONObject tabInfoJson) {
        info.setMoveable(tabInfoJson.getInt("moveable") == 0 ? 0 : 1);
        info.setCloseable(tabInfoJson.getInt("closeable") == 0 ? 0 : 1);
        info.setMaxminable(tabInfoJson.getInt("maxminable") == 0 ? 0 : 1);
        return info;
    }
}

