/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.cache;

import com.kingdee.eas.portal.web.cache.CacheConfig;
import com.kingdee.eas.portal.web.cache.CacheResource;
import com.kingdee.eas.portal.web.cache.resource.FileDirContext;
import com.kingdee.eas.portal.web.cache.resource.HttpResourceLoader;
import com.kingdee.eas.portal.web.cache.resource.ProxyDirContext;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheResourceFilter
implements Filter {
    private FilterConfig filterConfig;
    private CacheConfig cacheConfig;
    protected ProxyDirContext resources = null;
    private HttpResourceLoader resourceLoader = null;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.cacheConfig = CacheConfig.getInstance();
        FileDirContext fileContext = new FileDirContext();
        fileContext.setDocBase(this.filterConfig.getServletContext().getRealPath("/"));
        CacheResource.getInstance().setDirContext(fileContext);
        this.resources = new ProxyDirContext(fileContext);
        this.resourceLoader = new HttpResourceLoader(this.resources);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isCache(request)) {
            if (!this.sendResource(request, response)) {
                response.setHeader("Expires", this.cacheConfig.getExpires());
                response.setHeader("Cache-Control", "max-age=" + this.cacheConfig.getMaxAge());
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e) {
                System.out.println("io error at " + request.getRequestURI() + ": " + e.getMessage());
            }
        }
    }

    ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    private boolean sendResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.resourceLoader == null) {
            return false;
        }
        try {
            this.resourceLoader.serveResource(this.getServletContext(), request, response, true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String getRelativePath(HttpServletRequest request) {
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    private boolean isCache(HttpServletRequest request) {
        String resource = request.getRequestURI();
        int index = resource.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String ext = resource.substring(index);
        return this.cacheConfig.isCacheMime(ext);
    }

    public void destroy() {
    }

    protected void defineCaching(HttpServletRequest request, HttpServletResponse response, String resource, long lastModified) {
        response.setDateHeader("Last-Modified", lastModified);
        Calendar expires = Calendar.getInstance();
        expires.add(6, 7);
        response.setDateHeader("Expires", expires.getTimeInMillis());
        response.setHeader("Pragma", "");
    }

    protected void defineContentHeaders(HttpServletRequest request, HttpServletResponse response, String resource, int contentLength, String contentEncoding) {
        if (contentLength > -1) {
            response.setContentLength(contentLength);
        }
        if (resource.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (resource.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".htc")) {
            response.setContentType("text/x-component");
        } else if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (resource.endsWith(".jpg") || resource.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (resource.endsWith(".xml") || resource.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
    }
}

