/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.cache.resource;

import com.kingdee.eas.portal.web.cache.resource.BaseDirContext;
import com.kingdee.eas.portal.web.cache.resource.CacheEntry;
import com.kingdee.eas.portal.web.cache.resource.IDirContext;
import com.kingdee.eas.portal.web.cache.resource.Resource;
import com.kingdee.eas.portal.web.cache.resource.ResourceAttributes;
import com.kingdee.eas.portal.web.cache.resource.ResourceCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;

public class ProxyDirContext
implements IDirContext {
    protected ProxyDirContext proxy = this;
    protected Hashtable env;
    protected IDirContext dirContext;
    protected String vPath = null;
    protected String hostName;
    protected String contextName;
    protected ResourceCache cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 512;

    public ProxyDirContext(IDirContext dirContext) {
        BaseDirContext baseDirContext;
        this.dirContext = dirContext;
        if (dirContext instanceof BaseDirContext && (baseDirContext = (BaseDirContext)dirContext).isCached()) {
            try {
                this.cache = new ResourceCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cache.setCacheMaxSize(baseDirContext.getCacheMaxSize());
            this.cacheTTL = baseDirContext.getCacheTTL();
            this.cacheObjectMaxSize = baseDirContext.getCacheMaxSize() / 20;
        }
    }

    public ResourceCache getCache() {
        return this.cache;
    }

    public IDirContext getDirContext() {
        return this.dirContext;
    }

    public String getDocBase() {
        if (this.dirContext instanceof BaseDirContext) {
            return ((BaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw new NamingException(name + " entry is not exist.");
            }
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        if (object instanceof IDirContext) {
            return object;
        }
        if (object instanceof Resource) {
            return object;
        }
        return new Resource(new ByteArrayInputStream(object.toString().getBytes()));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name);
    }

    @Override
    public List list(String name) throws NamingException {
        return this.dirContext.list(name);
    }

    @Override
    public ResourceAttributes getAttributes(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw new NamingException(name + " entry is not exist.");
            }
            return entry.attributes;
        }
        return this.dirContext.getAttributes(name);
    }

    public CacheEntry lookupCache(String name) {
        CacheEntry entry = this.cacheLookup(name);
        if (entry == null) {
            entry = new CacheEntry();
            entry.name = name;
            try {
                Object object = this.dirContext.lookup(this.parseName(name));
                if (object instanceof InputStream) {
                    entry.resource = new Resource((InputStream)object);
                } else if (object instanceof IDirContext) {
                    entry.context = (IDirContext)object;
                } else {
                    entry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                }
                entry.attributes = this.dirContext.getAttributes(name);
            }
            catch (NamingException e) {
                entry.exists = false;
            }
        }
        return entry;
    }

    protected String parseName(String name) throws NamingException {
        return name;
    }

    protected CacheEntry cacheLookup(String name) {
        CacheEntry cacheEntry;
        if (this.cache == null) {
            return null;
        }
        if (name == null) {
            name = "";
        }
        if ((cacheEntry = this.cache.lookup(name)) == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = name;
            this.cacheLoad(cacheEntry);
        } else {
            if (!this.validate(cacheEntry)) {
                if (!this.revalidate(cacheEntry)) {
                    this.cacheUnload(cacheEntry.name);
                    return null;
                }
                cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
            }
            ++cacheEntry.accessCount;
        }
        return cacheEntry;
    }

    protected boolean validate(CacheEntry entry) {
        return (!entry.exists || entry.context != null || entry.resource != null && entry.resource.getContent() != null) && System.currentTimeMillis() < entry.timestamp;
    }

    protected boolean revalidate(CacheEntry entry) {
        if (!entry.exists) {
            return false;
        }
        if (entry.attributes == null) {
            return false;
        }
        long lastModified = entry.attributes.getLastModified();
        long contentLength = entry.attributes.getContentLength();
        if (lastModified <= 0L) {
            return false;
        }
        try {
            ResourceAttributes attributes = this.dirContext.getAttributes(entry.name);
            long lastModified2 = attributes.getLastModified();
            long contentLength2 = attributes.getContentLength();
            return lastModified == lastModified2 && contentLength == contentLength2;
        }
        catch (NamingException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoad(CacheEntry entry) {
        String name = entry.name;
        boolean exists = true;
        if (entry.attributes == null) {
            try {
                entry.attributes = this.dirContext.getAttributes(entry.name);
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource == null && entry.context == null) {
            try {
                Object object = this.dirContext.lookup(name);
                if (object instanceof InputStream) {
                    entry.resource = new Resource((InputStream)object);
                } else if (object instanceof IDirContext) {
                    entry.context = (IDirContext)object;
                } else {
                    entry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                }
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource != null && entry.resource.getContent() == null && entry.attributes.getContentLength() >= 0L && entry.attributes.getContentLength() < (long)(this.cacheObjectMaxSize * 1024)) {
            int length = (int)entry.attributes.getContentLength();
            entry.size = (int)((long)entry.size + entry.attributes.getContentLength() / 1024L);
            InputStream is = null;
            try {
                int n;
                is = entry.resource.streamContent();
                byte[] b = new byte[length];
                for (int pos = 0; pos < length && (n = is.read(b, pos, length - pos)) >= 0; pos += n) {
                }
                entry.resource.setContent(b);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        entry.exists = exists;
        entry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            if (this.cache.lookup(name) == null && this.cache.allocate(entry.size)) {
                this.cache.load(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheUnload(String name) {
        if (this.cache == null) {
            return false;
        }
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            return this.cache.unload(name);
        }
    }
}

