/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.portal.ColCollection;
import com.kingdee.eas.portal.ColInfo;
import com.kingdee.eas.portal.ContainerPortletFacadeFactory;
import com.kingdee.eas.portal.FlagEnum;
import com.kingdee.eas.portal.IContainerPortletFacade;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.LayoutInfo;
import com.kingdee.eas.portal.PageDescriptionInfo;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPrefParameterCollection;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.TabInfo;
import com.kingdee.eas.portal.ThemeInfo;
import com.kingdee.eas.portal.web.configuration.PortletDefine;
import com.kingdee.eas.portal.web.configuration.PortletMode;
import com.kingdee.eas.portal.web.control.PorletInstanceInfoBean;
import com.kingdee.eas.portal.web.control.PortalContextBean;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.portal.web.util.PortletUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;

public class ContentAssembleAction
extends Action {
    private static final String PORTLETS_ACTION_FORWARDS = "com.kingdee.eas.portal.web.control.PORTLETS_ACTION_FORWARDS";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.web.control.ContentAssembleAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Context _userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
        ThemeInfo themeInfo = (ThemeInfo)session.getAttribute("com.kingdee.portal.control.PORTAL_THEME");
        PortalContextBean portalContextBean = (PortalContextBean)session.getAttribute("com.kingdee.portal.web.control.PORTAL_CONTEXT_BEAN");
        PageInfo currPageInfo = null;
        TabInfo currTabInfo = null;
        String pageIndex = request.getParameter("p_l_id");
        currPageInfo = portalContextBean.getPageInfo(pageIndex);
        PageDescriptionInfo pageDescriptionInfo = currPageInfo.getPageDescription();
        currTabInfo = currPageInfo.getTab();
        ArrayList<PorletInstanceInfoBean> maxPortlet = new ArrayList<PorletInstanceInfoBean>(1);
        String windowState = request.getParameter("p_p_state");
        if ("maximized".equals(windowState)) {
            currPageInfo.getTab().setMaximizedPortlet(request.getParameter("portal_portlet_instance_id"));
        } else if ("normal".equals(windowState)) {
            currPageInfo.getTab().setMaximizedPortlet(null);
            PortalUtil.removeBusinessRequest(request);
        } else if ("minimized".equals(windowState)) {
            currPageInfo.getTab().setMaximizedPortlet(null);
            PortalUtil.removeBusinessRequest(request);
        }
        ComponentContext compCtx = ComponentContext.getContext((ServletRequest)request);
        LayoutInfo layoutInfo = currPageInfo.getTab().getLayout();
        compCtx.putAttribute("layoutInfo", (Object)layoutInfo);
        ColCollection cols = layoutInfo.getCols();
        Iterator iterator = null;
        String pid = null;
        BOSUuid porletInstanceId = null;
        String action = null;
        PortletPreferencesInfo portletInst = null;
        PortletInfo portlet = null;
        PorletInstanceInfoBean portletInstanceInfoBean = null;
        ActionForward forward = null;
        IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
        HashMap portletsHashMap = service.getPortlets();
        ArrayList<ColInfo> areaList = new ArrayList<ColInfo>();
        ArrayList<PorletInstanceInfoBean> valueList = null;
        int areaNum = layoutInfo.getCols().size();
        for (int i = 0; i < areaNum; ++i) {
            valueList = new ArrayList<PorletInstanceInfoBean>();
            areaList.add(cols.get(i));
            iterator = cols.get(i).getPortlets().iterator();
            while (iterator.hasNext()) {
                portletInst = (PortletPreferencesInfo)iterator.next();
                pid = portletInst.getPortletID();
                porletInstanceId = portletInst.getId();
                action = portletInst.getAction();
                portlet = (PortletInfo)portletsHashMap.get(pid);
                if (portlet == null) {
                    logger.info((Object)(action + " porlet not exists!"));
                    continue;
                }
                if (!this.canShow4Runtime(request, portlet, portletInst)) {
                    logger.info((Object)(action + " porlet not runtime permission!"));
                    continue;
                }
                forward = null;
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    HashMap hashMap = (HashMap)session.getAttribute(PORTLETS_ACTION_FORWARDS);
                    if (hashMap != null) {
                        forward = (ActionForward)hashMap.get(porletInstanceId.toString());
                    }
                }
                portletInstanceInfoBean = new PorletInstanceInfoBean();
                portletInstanceInfoBean.setPorletId(pid);
                portletInstanceInfoBean.setInstanceId(porletInstanceId);
                portletInstanceInfoBean.setPorletTitle((String)portlet.get("portletname_" + _userCtx.getLocale().toString()));
                portletInstanceInfoBean.setParams(portlet.getParams());
                if (forward != null) {
                    portletInstanceInfoBean.setTilesName(forward.getPath());
                } else {
                    PortletDefine pDefine = service.getPortletDefine(portlet.getPortletDefineId());
                    if (pDefine != null && pDefine.getModes().get(action) != null) {
                        portletInstanceInfoBean.setTilesName(((PortletMode)pDefine.getModes().get(action)).getValue());
                    } else {
                        logger.info((Object)(action + " porlet request error!"));
                        logger.info((Object)(" cant get porlet definitions from xml for portlet: " + portletInstanceInfoBean.getPorletTitle()));
                        portletInstanceInfoBean.setTilesName("<put the error porlet info>");
                        continue;
                    }
                }
                PortletPrefParameterCollection portletPrefParams = portletInst.getParams();
                PortletExtInfo portletExt = portlet.getPortletExt();
                portletInstanceInfoBean.setInstanceParams(portletPrefParams);
                portletInstanceInfoBean.setPortletExt(portletExt);
                if (porletInstanceId.toString().equals(currPageInfo.getTab().getMaximizedPortlet())) {
                    maxPortlet.add(portletInstanceInfoBean);
                }
                valueList.add(portletInstanceInfoBean);
            }
            if (currPageInfo.getTab().getMaximizedPortlet() != null) continue;
            compCtx.putAttribute("portletList" + i, valueList);
        }
        compCtx.putAttribute("areaList", areaList);
        compCtx.putAttribute("currTabInfo", (Object)currTabInfo);
        compCtx.putAttribute("currPageDescriptionInfo", (Object)pageDescriptionInfo);
        compCtx.putAttribute("pageId", (Object)currPageInfo.getId().toString());
        if (currPageInfo.getTab().getMaximizedPortlet() == null) {
            compCtx.putAttribute("colNum", (Object)Integer.toString(layoutInfo.getColNum()));
        } else {
            compCtx.putAttribute("colNum", (Object)"1");
            compCtx.putAttribute("portletList0", maxPortlet);
        }
        return null;
    }

    private boolean canShow4Runtime(HttpServletRequest request, PortletInfo currentPortlet, PortletPreferencesInfo portletInst) throws Exception {
        if (FlagEnum.CONTAINER_FLAG.equals((Object)currentPortlet.getFlag())) {
            return this.canShow4RuntimeContainerPortlet(request, currentPortlet.getId().toString(), portletInst.getId().toString());
        }
        return PortletUtil.canShow4RuntimePortlet(request, currentPortlet.getId().toString());
    }

    private boolean canShow4RuntimeContainerPortlet(HttpServletRequest request, String currentPortletId, String portletInstId) throws Exception {
        boolean canShow4Container = PortletUtil.canShow4RuntimePortlet(request, currentPortletId);
        if (!canShow4Container) {
            return false;
        }
        Context context = WebContextUtil.getEasContext((HttpServletRequest)request);
        List portletIdList = this.getContainerPortletIdList(context, currentPortletId, portletInstId);
        if (portletIdList != null) {
            for (int i = 0; i < portletIdList.size(); ++i) {
                String portletId = (String)portletIdList.get(i);
                if (!PortletUtil.canShow4RuntimePortlet(request, portletId)) continue;
                return true;
            }
        }
        return false;
    }

    private List getContainerPortletIdList(Context ctx, String portletId, String portletInsId) throws Exception {
        ArrayList portletIdList = new ArrayList();
        HashMap map = this.getContainerPortletAtRuntime(ctx, portletInsId, portletId);
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        List list = containerFacade.getPortletListById((String)map.get("containerPortletId"), false);
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                HashMap rowMap = (HashMap)iterator.next();
                portletIdList.add(rowMap.get("portletid"));
            }
        }
        return portletIdList;
    }

    private HashMap getContainerPortletAtRuntime(Context ctx, String portletInsId, String portletId) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FID, FStyle, FParentID, FEditable from T_Portal_ContainerPortlet where (FPortletPreferencesID=? and FParentID is not null)");
        sb.append(" or ((FParentID is null or FParentID='') and FPortletID=?)");
        Object[] param = new Object[]{portletInsId, portletId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        logger.info((Object)("------------------rs.size()---------------------" + rs.size()));
        try {
            if (rs.size() >= 2) {
                while (rs.next()) {
                    if (StringUtils.isEmpty((String)rs.getString("FParentID"))) continue;
                    map.put("containerPortletId", rs.getString("FID"));
                }
            } else {
                rs.next();
                map.put("containerPortletId", rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

