/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.common.json.simple.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.IPortletCategory;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletCategoryCollection;
import com.kingdee.eas.portal.PortletCategoryFactory;
import com.kingdee.eas.portal.PortletCategoryInfo;
import com.kingdee.eas.portal.PortletCategoryTreeUtil;
import com.kingdee.eas.portal.PortletExtFactory;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPrefParameterCollection;
import com.kingdee.eas.portal.PortletPrefParameterInfo;
import com.kingdee.eas.portal.PortletPreferencesFactory;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.web.control.ManagePortletForm;
import com.kingdee.eas.portal.web.control.PortalContextBean;
import com.kingdee.eas.portal.web.util.JsonObjectUtil;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ManagePortletAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger((String)ManagePortletAction.class.getName());
    private static Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
    private static Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
    private static Locale locale_L3 = LocaleUtils.getLocale((String)"L3");

    public ActionForward getPortletCategoryList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String withCheckBox = request.getParameter("gotCheckBox");
        boolean checked = false;
        if (!StringUtils.isEmpty((String)withCheckBox)) {
            checked = Boolean.valueOf(withCheckBox);
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        PortletCategoryCollection pcc = PortletCategoryTreeUtil.getAllPortletCategory(null);
        Map portletCategoryMap = PortletCategoryTreeUtil.getPortletCategoryMap(pcc);
        JSONArray reply = this.makePortletCategoryTreeData(ctx, portletCategoryMap, "root", checked);
        this.responseWrite(response, reply.toString());
        return null;
    }

    private void responseWrite(HttpServletResponse response, String reply) {
        response.setContentType("text/html; charset=UTF-8");
        try {
            PrintWriter pw = response.getWriter();
            pw.write(reply);
            pw.flush();
        }
        catch (IOException e) {
            logger.error((Object)("write response io error, the reply is: " + reply), (Throwable)e);
        }
    }

    private JSONArray makePortletCategoryTreeData(Context ctx, Map map, String rootLongNumber, boolean withCheckBox) {
        JSONArray reply = new JSONArray();
        if (map.size() == 0) {
            return reply;
        }
        PortletCategoryInfo pcInfo = null;
        JSONObject cells = null;
        ArrayList pcInfos = (ArrayList)map.get(rootLongNumber);
        for (int i = 0; i < pcInfos.size(); ++i) {
            pcInfo = (PortletCategoryInfo)pcInfos.get(i);
            cells = new JSONObject();
            cells.put((Object)"id", (Object)pcInfo.getId().toString());
            cells.put((Object)"text", (Object)pcInfo.getName(ctx.getLocale()));
            if (withCheckBox) {
                cells.put((Object)"checked", (Object)false);
            }
            cells.put((Object)"isStandard", (Object)(pcInfo.getIsStandard() == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true)));
            if (map.containsKey(pcInfo.getLongNumber())) {
                cells.put((Object)"children", (Object)this.makePortletCategoryTreeData(ctx, map, pcInfo.getLongNumber(), withCheckBox));
            } else {
                cells.put((Object)"leaf", (Object)true);
            }
            reply.add((Object)cells);
        }
        return reply;
    }

    public ActionForward savePortletCategory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String json = request.getParameter("json");
        if ((json = URLDecoder.decode(json, "utf-8")) == null) {
            return null;
        }
        IPortletCategory pcf = PortletCategoryFactory.getRemoteInstance();
        String reply = pcf.savePortletCategory(json);
        this.responseWrite(response, reply);
        return null;
    }

    public ActionForward getPortletCategoryByID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String portletCategoryID = request.getParameter("portletCategoryID");
        if (StringUtils.isEmpty((String)portletCategoryID)) {
            logger.error((Object)"getPortletCategoryByID's id is null");
            return null;
        }
        IPortletCategory pcf = PortletCategoryFactory.getRemoteInstance();
        PortletCategoryInfo pcInfo = pcf.getPortletCategoryInfo((IObjectPK)new ObjectUuidPK(portletCategoryID));
        JSONObject pcInfoJSON = new JSONObject();
        pcInfoJSON.put((Object)"portletCategoryNumber", (Object)pcInfo.getPortletCategoryNumber());
        pcInfoJSON.put((Object)"portletCategoryName_L1", (Object)pcInfo.getName(locale_L1));
        pcInfoJSON.put((Object)"portletCategoryName_L2", (Object)pcInfo.getName(locale_L2));
        pcInfoJSON.put((Object)"portletCategoryName_L3", (Object)pcInfo.getName(locale_L3));
        pcInfoJSON.put((Object)"portletCategoryDescription", (Object)pcInfo.getDescription(ctx.getLocale()));
        PortletCategoryInfo parentInfo = pcInfo.getParent();
        String parentPortletCategoryName = "portlet";
        String parentPortletCategoryID = "";
        if (parentInfo != null) {
            parentPortletCategoryID = parentInfo.getId().toString();
            parentInfo = pcf.getPortletCategoryInfo((IObjectPK)new ObjectUuidPK(parentPortletCategoryID));
            parentPortletCategoryName = parentInfo.getName(ctx.getLocale());
        }
        pcInfoJSON.put((Object)"parentPortletCategoryName", (Object)parentPortletCategoryName);
        pcInfoJSON.put((Object)"parentPortletCategoryID", (Object)parentPortletCategoryID);
        this.responseWrite(response, pcInfoJSON.toString());
        return null;
    }

    public ActionForward canDeletePortletCategory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String whereSQL;
        String portletCategoryID = request.getParameter("portletCategoryID");
        if (StringUtils.isEmpty((String)portletCategoryID)) {
            logger.error((Object)"deletePortletCategoryByID's id is null");
            return null;
        }
        JSONObject pcInfoJSON = new JSONObject();
        IPortlet pf = PortletFactory.getRemoteInstance();
        boolean exist = pf.exists(whereSQL = "where portletCategory ='" + portletCategoryID + "'  and enable != " + 3);
        if (exist) {
            pcInfoJSON.put((Object)"canDelete", (Object)false);
        } else {
            pcInfoJSON.put((Object)"canDelete", (Object)true);
        }
        this.responseWrite(response, pcInfoJSON.toString());
        return null;
    }

    public ActionForward deletePortletCategoryByID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletCategoryID = request.getParameter("portletCategoryID");
        if (StringUtils.isEmpty((String)portletCategoryID)) {
            logger.error((Object)"deletePortletCategoryByID's id is null");
            return null;
        }
        IPortletCategory pcf = PortletCategoryFactory.getRemoteInstance();
        pcf.deletePortletCategoryByID(portletCategoryID);
        this.responseWrite(response, "{success:true}");
        return null;
    }

    private IRowSet queryPortlets(Context ctx, String portletCategoryID, boolean isShowLower, String searchType, String searchValue, String pcLongNumber) throws BOSException {
        Locale locale = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fid id, p.fportletnumber portletnumber, p.fportletname_l1 portletname_l1, p.fportletname_l2 portletname_l2, p.fportletname_l3 portletname_l3").append(", p.fflag flag, p.fenable enable, p.fdescription_").append(locale).append(" description").append(", p.fportletextid portletextid").append(", p.FDefineCheck defineCheck").append(", p.FRuntimeCheck runtimeCheck").append(", pxt.ftitle_").append(locale).append(" exttitle").append(", pxt.fbizdefurl extbizdefurl").append(", pxt.fcontentareabgcolor contentareabgcolor").append(", pc.fname_").append(locale).append(" portletcategoryname");
        sb.append(" from t_portal_portlet p left outer join t_portal_portletext pxt on p.fportletextid = pxt.fid");
        sb.append(" left outer join t_portal_portletcategory pc on p.fportletcategoryid = pc.fid");
        sb.append(" where p.fenable != 3 and").append(" (p.fcontrolunitid=? or").append(" p.fcontrolunitid=? or").append(" p.fcontrolunitid=?)");
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        paramsList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        paramsList.add("00000000-0000-0000-0000-000000000000CCE7AED4");
        if (isShowLower) {
            if (StringUtils.isEmpty((String)portletCategoryID)) {
                sb.append(" and (p.fportletcategoryid is null or pc.flongnumber like '").append(pcLongNumber).append("%')");
            } else {
                sb.append(" and pc.flongnumber like '").append(pcLongNumber).append("%'");
            }
        } else if (StringUtils.isEmpty((String)portletCategoryID)) {
            sb.append(" and p.fportletcategoryid is null");
        } else {
            if ("XkGI/dDGlkWJhX5ZEW9lOEPH2a4=".equals(portletCategoryID)) {
                sb.append(" and (p.fportletcategoryid=? or p.fportletcategoryid is null)");
            } else {
                sb.append(" and p.fportletcategoryid=?");
            }
            paramsList.add(portletCategoryID);
        }
        if (!StringUtils.isEmpty((String)searchType) && !StringUtils.isEmpty((String)searchValue)) {
            searchValue = "%" + searchValue + "%";
            if (searchType.equals("0")) {
                sb.append(" and p.fportletnumber like ?");
                paramsList.add(searchValue);
            } else if (searchType.equals("1")) {
                sb.append(" and p.fportletname_").append(locale).append(" like ?");
                paramsList.add(searchValue);
            } else if (searchType.equals("2")) {
                sb.append(" and (pxt.ftitle_").append(locale).append(" like ?");
                sb.append(" or (pxt.ftitle_").append(locale).append(" is null");
                sb.append(" and p.fportletname_").append(locale).append(" like ?))");
                paramsList.add(searchValue);
                paramsList.add(searchValue);
            }
        }
        Object[] params = new Object[paramsList.size()];
        paramsList.toArray(params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
        return rs;
    }

    private JSONObject portletsRs2Json(IRowSet rs) {
        JSONObject jsonResult = new JSONObject();
        JSONArray portletsJsonArray = new JSONArray();
        JSONObject jsonObj = null;
        int currIndex = 1;
        try {
            while (rs.next()) {
                jsonObj = new JSONObject();
                jsonObj.put((Object)"no", (Object)new Integer(currIndex));
                jsonObj.put((Object)"id", (Object)rs.getString("id"));
                jsonObj.put((Object)"number", (Object)rs.getString("portletnumber"));
                jsonObj.put((Object)"name_en", (Object)rs.getString("portletname_l1"));
                jsonObj.put((Object)"name_ch", (Object)rs.getString("portletname_l2"));
                jsonObj.put((Object)"name_tw", (Object)rs.getString("portletname_l3"));
                jsonObj.put((Object)"portletCategoryName", (Object)rs.getString("portletcategoryname"));
                jsonObj.put((Object)"portletType", (Object)rs.getString("flag"));
                jsonObj.put((Object)"enabled", (Object)new Integer(rs.getString("enable")));
                jsonObj.put((Object)"description", (Object)rs.getString("description"));
                String customizedName = null;
                String hasBizDef = null;
                String portletExtID = null;
                boolean isCustomized = false;
                portletExtID = rs.getString("portletextid");
                if (!StringUtils.isEmpty((String)portletExtID)) {
                    customizedName = rs.getString("exttitle");
                    hasBizDef = rs.getString("extbizdefurl");
                    if (!StringUtils.isEmpty((String)rs.getString("contentareabgcolor"))) {
                        isCustomized = true;
                    }
                }
                jsonObj.put((Object)"defineCheck", (Object)rs.getString("defineCheck"));
                jsonObj.put((Object)"runtimeCheck", (Object)rs.getString("runtimeCheck"));
                jsonObj.put((Object)"customizedName", (Object)customizedName);
                jsonObj.put((Object)"hasBizDef", (Object)hasBizDef);
                jsonObj.put((Object)"portletExtID", (Object)portletExtID);
                jsonObj.put((Object)"isCustomized", (Object)isCustomized);
                portletsJsonArray.add((Object)jsonObj);
                ++currIndex;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6portlet\u7ed3\u679c\u96c6\u5408\u65f6\u51fa\u9519", (Throwable)e);
        }
        jsonResult.put((Object)"count", (Object)new Integer(currIndex));
        jsonResult.put((Object)"portlets", (Object)portletsJsonArray);
        return jsonResult;
    }

    public ActionForward getPortlets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String portletCategoryID = request.getParameter("portletCategoryID");
        String isShowLowerPortlet = request.getParameter("isShowLowerPortlet");
        boolean isShow = Boolean.valueOf(isShowLowerPortlet);
        String pcLongNumber = "";
        if (isShow && !StringUtils.isEmpty((String)portletCategoryID)) {
            IPortletCategory pcf = PortletCategoryFactory.getRemoteInstance();
            PortletCategoryInfo pcInfo = pcf.getPortletCategoryInfo((IObjectPK)new ObjectUuidPK(portletCategoryID));
            pcLongNumber = pcInfo.getLongNumber();
        }
        String searchType = request.getParameter("searchType");
        String searchValue = request.getParameter("searchValue");
        IRowSet rs = this.queryPortlets(ctx, portletCategoryID, isShow, searchType, searchValue, pcLongNumber);
        JSONObject jsonResult = this.portletsRs2Json(rs);
        this.responseWrite(response, jsonResult.toString());
        return null;
    }

    public ActionForward enablePortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletID = request.getParameter("portletID");
        IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
        service.enablePortlet(portletID);
        service.refreshPortletCache();
        PrintWriter pw = response.getWriter();
        pw.print("{success:true}");
        return null;
    }

    public ActionForward disablePortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletID = request.getParameter("portletID");
        IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
        service.disablePortlet(portletID);
        service.refreshPortletCache();
        PrintWriter pw = response.getWriter();
        pw.print("{success:true}");
        return null;
    }

    public ActionForward getPortletExt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String portletExtID = request.getParameter("portletExtID");
        PortletExtInfo portletExtInfo = PortletExtFactory.getRemoteInstance().getPortletExtInfo((IObjectPK)new ObjectUuidPK(portletExtID));
        JSONObject jsonResult = new JSONObject();
        jsonResult.put((Object)"success", (Object)new Boolean(true));
        JSONObject jsonPortletExt = JsonObjectUtil.fromPortletExt(ctx, portletExtInfo);
        jsonResult.put((Object)"data", (Object)jsonPortletExt);
        this.responseWrite(response, jsonResult.toString());
        return null;
    }

    public ActionForward savePortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter pw = response.getWriter();
        ManagePortletForm mpForm = (ManagePortletForm)form;
        String portletID = mpForm.getPortletID();
        if (portletID == null) {
            pw.print("{success:false}");
            return null;
        }
        PortletInfo portletInfo = PortletFactory.getRemoteInstance().getPortletInfo((IObjectPK)new ObjectUuidPK(portletID));
        PortletExtInfo portletExtInfo = portletInfo.getPortletExt();
        int restore = mpForm.getRestore();
        if (restore == 1) {
            if (portletExtInfo == null) {
                pw.print("{success:false}");
                return null;
            }
            mpForm.setDefaultPortletExtInfo(portletExtInfo);
            PortalUtil.updateSuperInfo(ctx, portletExtInfo);
            IPortalServiceFacade psf = PortalServiceFacadeFactory.getRemoteInstance();
            psf.update(portletInfo.getId(), portletInfo);
            psf.refreshPortletCache();
            pw.print("{success:true}");
            return null;
        }
        int sizeLimitation = 0x100000;
        ArrayList<String> errorProperties = new ArrayList<String>();
        if (mpForm.getTitleBoxLeft() != null && mpForm.getTitleBoxLeft().getFileSize() > sizeLimitation) {
            errorProperties.add("titleBoxLeft");
        }
        if (mpForm.getTitleBoxBg() != null && mpForm.getTitleBoxBg().getFileSize() > sizeLimitation) {
            errorProperties.add("titleBoxBg");
        }
        if (mpForm.getTitleBoxRight() != null && mpForm.getTitleBoxRight().getFileSize() > sizeLimitation) {
            errorProperties.add("titleBoxRight");
        }
        if (mpForm.getTitleAreaBg() != null && mpForm.getTitleAreaBg().getFileSize() > sizeLimitation) {
            errorProperties.add("titleAreaBg");
        }
        if (mpForm.getTitleIcon() != null && mpForm.getTitleIcon().getFileSize() > sizeLimitation) {
            errorProperties.add("titleIcon");
        }
        if (errorProperties.size() > 0) {
            String errorText = EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"picSizeLimitation");
            StringBuffer exceedJson = new StringBuffer("{success:false,errors:{");
            Iterator it = errorProperties.iterator();
            int index = 0;
            while (it.hasNext()) {
                String errorProperty = (String)it.next();
                if (index != 0) {
                    exceedJson.append(",");
                }
                exceedJson.append(errorProperty).append(":\"").append(errorText).append("\"");
                ++index;
            }
            exceedJson.append("}}");
            pw.print(exceedJson);
            return null;
        }
        boolean hasPortletExt = true;
        if (portletExtInfo == null) {
            hasPortletExt = false;
            portletExtInfo = new PortletExtInfo();
            portletExtInfo.setId(BOSUuid.create((BOSObjectType)portletExtInfo.getBOSType()));
            PortalUtil.setSuperInfo(ctx, portletExtInfo);
        } else {
            PortalUtil.updateSuperInfo(ctx, portletExtInfo);
        }
        try {
            mpForm.setPortletExtInfo(portletExtInfo);
        }
        catch (FileNotFoundException e) {
            pw.print("{success:false}");
        }
        catch (IOException e) {
            pw.print("{success:false}");
        }
        if (!hasPortletExt) {
            portletInfo.setPortletExt(portletExtInfo);
        }
        IPortalServiceFacade psf = PortalServiceFacadeFactory.getRemoteInstance();
        psf.update(portletInfo.getId(), portletInfo);
        psf.refreshPortletCache();
        JSONObject jsonResult = new JSONObject();
        jsonResult.put((Object)"success", (Object)new Boolean(true));
        JSONObject jsonPortletExtPartial = JsonObjectUtil.fromPortletExtPartial(portletExtInfo);
        jsonResult.put((Object)"data", (Object)jsonPortletExtPartial);
        pw.print(jsonResult);
        return null;
    }

    public ActionForward savePortletInstanceParams(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletInstanceId = request.getParameter("portletInstanceId");
        String portletInstanceHeightStr = request.getParameter("portletInstanceHeight");
        Integer portletInstanceHeight = new Integer(0);
        if (portletInstanceId == null) {
            throw new Exception("request parameters error. parameters needed: portletInstanceId:String.");
        }
        if (portletInstanceHeightStr != null) {
            try {
                portletInstanceHeight = Integer.valueOf(portletInstanceHeightStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("request parameter portletInstanceHeight should be an integer");
            }
        }
        portletInstanceHeightStr = portletInstanceHeight.toString();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        PortletPreferencesInfo portletInstance = PortletPreferencesFactory.getRemoteInstance().getPortletPreferencesInfo((IObjectPK)new ObjectUuidPK(portletInstanceId));
        PortletPrefParameterInfo newPortletInstanceParam = new PortletPrefParameterInfo();
        newPortletInstanceParam.setParamName("height");
        newPortletInstanceParam.setParamValue(portletInstanceHeightStr);
        this.setPortletInstanceParam(ctx, portletInstance, newPortletInstanceParam);
        PortletPreferencesFactory.getRemoteInstance().save((CoreBaseInfo)portletInstance);
        PortalContextBean portalContextBean = (PortalContextBean)request.getSession().getAttribute("com.kingdee.portal.web.control.PORTAL_CONTEXT_BEAN");
        this.setPortletInstanceParam(ctx, portalContextBean.getPortletPreferencesInfo(portletInstance.getId()), newPortletInstanceParam);
        PrintWriter pw = response.getWriter();
        pw.print("{success:true}");
        return null;
    }

    private void setPortletInstanceParam(Context ctx, PortletPreferencesInfo portletInstance, PortletPrefParameterInfo newPortletInstanceParam) {
        PortletPrefParameterCollection portletInstanceParams = portletInstance.getParams();
        boolean hasThisParam = false;
        Iterator it = portletInstanceParams.iterator();
        PortletPrefParameterInfo portletInstanceParam = null;
        while (it.hasNext()) {
            portletInstanceParam = (PortletPrefParameterInfo)it.next();
            if (!portletInstanceParam.getParamName().equals(newPortletInstanceParam.getParamName())) continue;
            portletInstanceParam.setParamValue(newPortletInstanceParam.getParamValue());
            PortalUtil.updateSuperInfo(ctx, portletInstanceParam);
            hasThisParam = true;
        }
        if (!hasThisParam) {
            portletInstanceParam = new PortletPrefParameterInfo();
            PortalUtil.setSuperInfo(ctx, portletInstanceParam);
            portletInstanceParam.setParamName(newPortletInstanceParam.getParamName());
            portletInstanceParam.setParamValue(newPortletInstanceParam.getParamValue());
            portletInstanceParams.add(portletInstanceParam);
        }
    }

    public ActionForward getPic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward downloadSkinPic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward _addPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward _refreshPortletDefCache(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPortalServiceFacade psf = PortalServiceFacadeFactory.getRemoteInstance();
        psf.refreshPortletCache();
        return null;
    }
}

