/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.portal.web.util.Md5Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PortletExtPic {
    public static final int BOX_LEFT = 0;
    public static final int BOX_BG = 1;
    public static final int BOX_RIGHT = 2;
    public static final int AREA_BG = 3;
    public static final int ICON = 4;
    private static final String SAVE_DIR = "/resource/portletextpics/";
    private static String REAL_SAVE_DIR = null;
    private String fileName;
    private String fileFullPath;
    private int type;
    private String suffix;
    private byte[] bytes;
    private static Map contentTypeMapping = new HashMap();
    private String portletExtId;
    private long lastModified;
    private HttpServletRequest request;

    public PortletExtPic(HttpServletRequest request, String portletExtId, int picType, String suffix, long lastModified) throws EASBizException, BOSException {
        this.portletExtId = portletExtId;
        this.type = picType;
        this.suffix = suffix;
        this.lastModified = lastModified;
        this.request = request;
        this.initRealSavePath();
        this.initFileName();
        this.initFileFullPath();
        this.initBytes();
    }

    private void initFileName() {
        this.fileName = PortletExtPic.generateFileName(this.portletExtId, this.type, this.lastModified);
    }

    private void initFileFullPath() {
        this.fileFullPath = REAL_SAVE_DIR + this.fileName + "." + this.suffix;
    }

    private static void initContentTypeMapping() {
        contentTypeMapping.put("gif", "image/gif");
        contentTypeMapping.put("jpg", "image/jpeg");
        contentTypeMapping.put("jpeg", "image/jpeg");
        contentTypeMapping.put("jpe", "image/jpeg");
        contentTypeMapping.put("bmp", "image/bmp");
        contentTypeMapping.put("png", "image/png");
    }

    private void initRealSavePath() {
        if (REAL_SAVE_DIR == null) {
            REAL_SAVE_DIR = this.request.getSession().getServletContext().getRealPath("") + SAVE_DIR;
        }
    }

    private void initBytes() throws EASBizException, BOSException {
    }

    private void clearOldFile(File saveDir) {
        String[] fileNames = saveDir.list();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            if (!fileName.startsWith(this.getPrefix())) continue;
            File delFile = new File(saveDir.getPath() + File.separator + fileName);
            delFile.delete();
        }
    }

    private void createFile() {
    }

    private String getPrefix() {
        return PortletExtPic.getPrefix(this.portletExtId, this.type);
    }

    private static String getPrefix(String portletExtId, int picType) {
        return Md5Util.encode(portletExtId + picType) + "-";
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getContentType() {
        if (contentTypeMapping.containsKey(this.suffix)) {
            return contentTypeMapping.get(this.suffix).toString();
        }
        return "image/jpeg";
    }

    public String getFileName() {
        return this.fileName;
    }

    public static String getContentType(String suffix) {
        if (contentTypeMapping.containsKey(suffix)) {
            return contentTypeMapping.get(suffix).toString();
        }
        return "image/jpeg";
    }

    public static String generateFileName(String portletExtId, int picType, long lastModified) {
        return PortletExtPic.getPrefix(portletExtId, picType) + lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2Bytes(String fileFullPath) {
        BufferedInputStream in = null;
        ByteArrayOutputStream out = null;
        byte[] returnBytes = new byte[]{};
        try {
            out = new ByteArrayOutputStream(5120);
            byte[] buff = new byte[5120];
            int size = 0;
            while (in != null && (size = in.read(buff)) != -1) {
                out.write(buff, 0, size);
            }
            returnBytes = out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnBytes;
    }

    static {
        PortletExtPic.initContentTypeMapping();
    }
}

