/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.portlet;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.portal.WindowState;
import com.kingdee.eas.portal.web.configuration.PortletMode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PortletURLImpl {
    protected final String ACTION_FALSE = "0";
    protected final String ACTION_TRUE = "1";
    private String _portletID;
    private BOSUuid _portletInstanceId;
    private String _layoutId;
    private String _tabIndex;
    private String _portletAreaId;
    private boolean _action;
    private WindowState _windowState;
    private PortletMode _portletMode;
    private Map _params;

    public PortletURLImpl(BOSUuid portletInstanceId, String layoutId, String tabIndex, String portletID, boolean action) {
        this._portletInstanceId = portletInstanceId;
        this._portletID = portletID;
        this._layoutId = layoutId;
        this._action = action;
        this._tabIndex = tabIndex;
        this._params = new LinkedHashMap();
    }

    public void setWindowState(WindowState windowState) {
        this._windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) {
        this._portletMode = portletMode;
    }

    public void setPortletAreaId(String areaId) {
        this._portletAreaId = areaId;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new IllegalArgumentException();
        }
        this._params.put(name, values);
    }

    public void setParameters(Map parameters) {
        if (this._params == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap newParams = new LinkedHashMap();
        for (Map.Entry entry : this._params.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (value == null) {
                throw new IllegalArgumentException();
            }
            if (value instanceof String[]) {
                newParams.put(key, value);
                continue;
            }
            throw new IllegalArgumentException();
        }
        this._params = newParams;
    }

    public void setSecure(boolean secure) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/layout.do?");
        sb.append("p_l_id");
        sb.append("=");
        sb.append(StringUtil.encoder((String)this._layoutId));
        sb.append("&");
        sb.append("p_t_index");
        sb.append("=");
        sb.append(this._tabIndex);
        sb.append("&");
        if (this._portletID != null) {
            sb.append("p_p_id");
            sb.append("=");
            sb.append(StringUtil.encoder((String)this._portletID));
            sb.append("&");
            sb.append("p_p_action");
            sb.append("=");
            sb.append(this._action ? this.ACTION_TRUE : this.ACTION_FALSE);
            sb.append("&");
            sb.append("p_p_a_id");
            sb.append("=");
            sb.append(StringUtil.encoder((String)this._portletAreaId));
            sb.append("&");
            sb.append("portal_portlet_instance_id");
            sb.append("=");
            sb.append(StringUtil.encoder((String)this._portletInstanceId.toString()));
            sb.append("&");
            if (this._windowState != null) {
                sb.append("p_p_state");
                sb.append("=");
                sb.append(this._windowState.getValue());
                sb.append("&");
            }
            if (this._portletMode != null) {
                sb.append("p_p_mode");
                sb.append("=");
                sb.append(this._portletMode.getValue());
                sb.append("&");
            }
            Iterator itr = this._params.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    sb.append(name);
                    sb.append("=");
                    sb.append(StringUtil.encoder((String)values[i]));
                    if (i + 1 >= values.length && !itr.hasNext()) continue;
                    sb.append("&");
                }
            }
        }
        return sb.toString();
    }
}

