/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.listener.IMExtendListenerManager;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.cp.common.json.simple.JSONArray;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.pc.web.cmcontent.ICMContent;
import com.kingdee.eas.portal.web.util.ProductService;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class LoginWebService
extends BuffaloService {
    Logger logger = Logger.getLogger((String)LoginWebService.class.getName());

    public String changePassword(String strOldPwd, String strNewPwd) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String str = "";
        try {
            strOldPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strOldPwd);
            strNewPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strNewPwd);
            IUser iUser = UserFactory.getRemoteInstance();
            iUser.updatePass(ctx.getCaller(), strOldPwd, strNewPwd);
            request.getSession().setAttribute("updatePasswordAlready", (Object)"Y");
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                UserException ue = (UserException)e;
                UserException.PASSWORD_NOT_MATCH.getCode().equals(ue.getSubCode());
                str = "kingdee.portal.i18n.oldpassworderror";
            } else {
                str = e.getMessage();
            }
            this.logger.info((Object)"\u4fee\u6539\u5bc6\u7801\u51fa\u9519\ue1e4", (Throwable)e);
        }
        return str;
    }

    public String getOnLineServiceURL() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        String ip = null;
        ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String onLineServiceUrl = null;
        try {
            if (ip != null && !ip.equals("")) {
                onLineServiceUrl = ProductService.getProductService(ip);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"\u83b7\u5f97\u5728\u7ebf\u670d\u52a1\u5730\u5740\u5f02\u5e38", (Throwable)e);
            return onLineServiceUrl;
        }
        return onLineServiceUrl;
    }

    public JSONArray getCMContentNoticeMsg() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        JSONArray msgArray = new JSONArray();
        try {
            SPInfo spInfo;
            Object cmContentObject;
            ICMContent cmContent;
            List columnList;
            if (SPManager.isSPInstalled((String)"CMContentImpl") && (columnList = (cmContent = (ICMContent)(cmContentObject = (spInfo = SPManager.getInstance().getSeviceProvider("CMContentImpl")).getProviderClass().newInstance())).getAllAuthorizedColumnByNotice(ctx)) != null && columnList.size() > 0) {
                Iterator ite = columnList.iterator();
                while (ite.hasNext()) {
                    msgArray.add((Object)((String)ite.next()));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u83b7\u53d6\u5185\u5bb9\u7ba1\u7406\u901a\u77e5\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return msgArray;
    }

    public JSONArray getIMService(String personID) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] imInfo = IMExtendListenerManager.getIMInfo((Context)ctx);
        if (imInfo == null || imInfo.length < 3 || StringUtils.isEmpty((String)imInfo[0]) || StringUtils.isEmpty((String)imInfo[1])) {
            return null;
        }
        String iconUrl = this.processIconUrl(request, personID);
        if (StringUtils.isEmpty((String)iconUrl)) {
            return null;
        }
        JSONArray json = new JSONArray();
        json.add((Object)true);
        json.add((Object)iconUrl);
        json.add((Object)Integer.valueOf(imInfo[2]));
        return json;
    }

    private String processIconUrl(HttpServletRequest request, String personID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] icon = IMExtendListenerManager.getIMIcon((Context)ctx, (String)personID);
        if (icon != null && icon.length > 0 && !StringUtils.isEmpty((String)icon[0]) && !"7".equals(icon[0])) {
            String iconUrl = "/html/portlet/cp/images/" + icon[0] + ".png";
            return WebContextUtil.render((HttpServletRequest)request, (String)iconUrl);
        }
        return null;
    }

    public String getIMIconUrl(String personID) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return this.processIconUrl(request, personID);
    }
}

