/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.ui.ChangedListener;
import com.kingdee.bos.formula.kscript.debug.ui.DebugManager;
import com.kingdee.bos.formula.kscript.debug.ui.DebugPanel;
import com.kingdee.bos.formula.kscript.debug.ui.IScript;
import com.kingdee.bos.formula.kscript.debug.ui.IScriptProvider;
import com.kingdee.bos.formula.kscript.debug.ui.Props;
import com.kingdee.bos.formula.kscript.debug.ui.RemoteDialog;
import com.kingdee.bos.formula.kscript.debug.ui.ScriptManager;
import com.kingdee.bos.formula.kscript.debug.ui.SourcePage;
import com.kingdee.bos.formula.kscript.debug.ui.StatusPanel;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.kscript.runtime.Interpreter;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DebugUI
extends JFrame {
    public static final int ACTION_STEP_OVER = 1;
    public static final int ACTION_STEP_INTO = 2;
    public static final int ACTION_STEP_OUT = 4;
    public static final int ACTION_RESUME = 8;
    public static final int ACTION_PAUSE = 16;
    public static final int ACTION_STOP = 32;
    public static final int ACTION_DROP_TO_FRAME = 64;
    public static final int ACTION_RUN = 128;
    public static final int ACTION_CLOSE_FILE = 256;
    public static final int ACTION_STOP_DEBUG = 512;
    static final Logger logger = Logger.getLogger(DebugUI.class);
    public static final Props props = new Props(DebugUI.class);
    public final DebugManager debugManager = new DebugManager();
    public DebugPanel debugPanel = new DebugPanel(this);
    public JToolBar toolBar = new JToolBar();
    public StatusPanel status = new StatusPanel();
    public JMenuBar menuBar = new JMenuBar();
    private volatile boolean immediatelyPause = props.getBoolean("immediatelyPause", true);
    private JCheckBox immediatelyPauseButton = new JCheckBox("ImmediatelyPause", this.immediatelyPause);
    private JComboBox debugList;
    private HashMap actions;
    private RemoteDialog dlgRemote;
    private volatile boolean inRemove;
    private IDebugContext lastDebug;
    private int lastState;
    private volatile boolean inExceptionHandler;
    public volatile boolean disableExceptionHandler;

    public DebugManager getDebugManager() {
        return this.debugManager;
    }

    public boolean isBreakImmediately() {
        return this.immediatelyPause;
    }

    public DebugUI() {
        super("KScript Debuger");
        this.immediatelyPauseButton.setToolTipText("pause immediately when a script is running.");
        this.immediatelyPauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUI.this.immediatelyPause = DebugUI.this.immediatelyPauseButton.isSelected();
                DebugUI.this.debugPanel.sourcePanel.refreshBreakPoints(DebugUI.this.immediatelyPause);
                props.set("immediatelyPause", "" + DebugUI.this.immediatelyPause, true);
            }
        });
        this.debugList = new JComboBox<Object>(new Object[0]);
        this.debugList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!DebugUI.this.inRemove) {
                        DebugUI.this.selectCurrentDebugContext();
                    }
                }
                catch (Exception ex) {
                    DebugUI.this.handleException(ex);
                }
            }
        });
        this.actions = new HashMap();
        this.dlgRemote = new RemoteDialog(this);
        this.inRemove = false;
        this.lastDebug = null;
        this.lastState = 0;
        this.inExceptionHandler = false;
        this.disableExceptionHandler = false;
        super.setBounds(0, 0, 800, 600);
        super.setState(6);
        this.addAction(128, "Run", "eval script in a new local thread", null, 0);
        this.addSeperator();
        this.addAction(8, "Resume", "resume last paused script", null, 0);
        this.addAction(16, "Pause", "pause script running", null, 0);
        this.addAction(32, "Stop", "manual stop script,this cause a DebugStopException", null, 0);
        this.addSeperator();
        this.addAction(512, "StopDebug", "stop debug the script,the script will eval continue", null, 0);
        this.addSeperator();
        this.addAction(1, "StepOver", "step over", null, 0);
        this.addAction(2, "StepInto", "step into", null, 0);
        this.addAction(4, "StepOut", "step out", null, 0);
        this.addAction(64, "DropTo", "drop to current running line", null, 0);
        this.addSeperator();
        this.toolBar.add(this.debugList);
        this.addSeperator();
        this.toolBar.add(this.immediatelyPauseButton);
        JMenu f = new JMenu("File");
        f.setMnemonic('F');
        IScriptProvider[] ps = ScriptManager.getProviders();
        for (int i = 0; i < ps.length; ++i) {
            final IScriptProvider p = ps[i];
            f.add(new AbstractAction(p.getMenuText(), null){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugUI.this.debugPanel.sourcePanel.loadScript(p);
                }
            });
            f.addSeparator();
        }
        f.add(new AbstractAction("Reload current script", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcePage page = DebugUI.this.debugPanel.sourcePanel.getActivedPage();
                if (page != null) {
                    page.reload();
                }
            }
        });
        f.addSeparator();
        JMenuItem closeFile = f.add(new AbstractAction("Close Current Script", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUI.this.debugPanel.actionPerformed(256);
            }
        });
        this.actions.put(new Integer(256), closeFile);
        f.addSeparator();
        f.add(new AbstractAction("Exit", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DebugUI.this.getDefaultCloseOperation() == 3) {
                    DebugUI.this.dispose();
                } else if (DebugUI.this.debugList.getItemCount() == 0) {
                    DebugUI.this.setVisible(false);
                }
            }
        });
        this.menuBar.add(f);
        JMenu rm = new JMenu("Remote");
        rm.setMnemonic('R');
        rm.add(new AbstractAction("Connect ...", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUI.this.connectRemote();
            }
        });
        this.menuBar.add(rm);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add(this.debugPanel.getComponent(), "Center");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.status, "South");
        this.refreshState();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                try {
                    DebugUI.this.debugPanel.sourcePanel.checkSourceChanged();
                }
                catch (Exception ex) {
                    DebugUI.this.handleException(ex);
                }
            }
        });
        props.traceComponent("mainui", this);
        this.debugManager.addChangedListener(new ChangedListener(){

            @Override
            public void notifyChanged(Object source, Object args) {
                DebugUI.this.removeStopedDebug(null);
            }
        });
    }

    public void connectRemote() {
        try {
            this.dlgRemote.setVisible(true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void dispose() {
        this.getDebugManager().terminateAll();
        super.dispose();
    }

    private void addSeperator() {
        this.toolBar.addSeparator();
    }

    private void addAction(final int action, String text, String tip, Icon icon, int hotKey) {
        JButton btn = this.toolBar.add(new AbstractAction(text, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUI.this.debugPanel.actionPerformed(action);
            }
        });
        if (tip != null) {
            btn.setToolTipText(tip);
        }
        this.actions.put(new Integer(action), btn);
    }

    public boolean isDebugEnabled(Source source) {
        SourcePage page = this.debugPanel.sourcePanel.getSourcePage(source);
        return page != null;
    }

    public static String getStateName(int state) {
        if (state == 1) {
            return "Error";
        }
        if (state == 2) {
            return "Running";
        }
        if (state == 8) {
            return "Stoped";
        }
        if (state == 4) {
            return "Paused";
        }
        return "(" + state + ")";
    }

    private IDebugContext selectDebug(int state) {
        for (int i = 0; i < this.debugList.getItemCount(); ++i) {
            ContextItem x = (ContextItem)this.debugList.getItemAt(i);
            if (x.debug.getState() != state) continue;
            this.debugList.setSelectedIndex(i);
            return x.debug;
        }
        return null;
    }

    private IDebugContext selectDebug() {
        IDebugContext r = this.selectDebug(4);
        if (r == null) {
            r = this.selectDebug(1);
        }
        if (r == null) {
            r = this.selectDebug(2);
        }
        return r;
    }

    private int indexOfDebugList(IDebugContext debug) {
        for (int i = 0; i < this.debugList.getItemCount(); ++i) {
            ContextItem x = (ContextItem)this.debugList.getItemAt(i);
            if (x.debug != debug) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeStopedDebug(IDebugContext removed) {
        if (this.inRemove) {
            return;
        }
        this.inRemove = true;
        try {
            for (int i = this.debugList.getItemCount() - 1; i >= 0; --i) {
                ContextItem x = (ContextItem)this.debugList.getItemAt(i);
                if (x.debug != removed && !this.isDebugNeedRemove(x.debug) || i < 0 || i >= this.debugList.getItemCount() || this.debugList.getItemAt(i) != x) continue;
                this.debugList.removeItemAt(i);
            }
        }
        finally {
            this.inRemove = false;
        }
    }

    private boolean isDebugNeedRemove(IDebugContext debug) {
        try {
            if (DebugManager.isRemoteConnectionClosed(debug)) {
                return true;
            }
            if (!debug.isDebugEnabled()) {
                return true;
            }
            int s = debug.getState();
            return s == 8;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public synchronized void removeDebug(IDebugContext debug) {
        try {
            this.removeStopedDebug(debug);
            this.setCurrentDebugContext(this.selectDebug());
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void debugOutput(IDebugContext debug, Object value, int state) {
        try {
            SourcePage page;
            Source source = debug.getMainSource();
            if (source != null && (page = this.debugPanel.sourcePanel.getSourcePage(source)) != null) {
                page.console.output(debug, value, state);
            }
        }
        catch (Exception ex) {
            this.handleDebugContextException(ex);
        }
    }

    public synchronized void debugNotify(IDebugContext debug, int state, IValue value) {
        if (state == -4) {
            this.debugOutput(debug, value, state);
            return;
        }
        IDebugContext debug0 = debug;
        if (state == -2 || state == -3) {
            if (state == -2) {
                this.debugOutput(debug, "eval finished, return value is " + String.valueOf(value) + "\r\n", state);
            }
            this.debugPanel.sourcePanel.notifyChanged();
            return;
        }
        this.removeStopedDebug(null);
        if (this.isDebugNeedRemove(debug)) {
            debug = null;
            ContextItem cur = (ContextItem)this.debugList.getSelectedItem();
            debug = cur == null ? this.selectDebug() : cur.debug;
        } else {
            int index = this.indexOfDebugList(debug);
            if (index < 0) {
                index = this.debugList.getItemCount();
                this.debugList.addItem(new ContextItem(debug));
            }
            if (debug.getState() == 2) {
                ContextItem cur = (ContextItem)this.debugList.getSelectedItem();
                if (cur != null && cur.debug.getState() == 4) {
                    debug = cur.debug;
                } else {
                    this.debugList.setSelectedIndex(index);
                }
            } else {
                this.debugList.setSelectedIndex(index);
            }
        }
        this.setCurrentDebugContext(debug);
        if (state == 1) {
            this.debugOutput(debug, debug.getReturnValue().getStackTrace(), state);
        }
    }

    void selectCurrentDebugContext() {
        ContextItem cur = (ContextItem)this.debugList.getSelectedItem();
        if (cur == null) {
            this.setCurrentDebugContext(null);
        } else {
            this.setCurrentDebugContext(cur.debug);
        }
    }

    private void setCurrentDebugContext(IDebugContext debug) {
        int state;
        int n = state = debug == null ? 0 : debug.getState();
        if (state != 4 && this.lastDebug == debug && this.lastState == state) {
            return;
        }
        this.lastDebug = debug;
        this.lastState = state;
        this.debugPanel.setDebugContext(debug);
        this.refreshState();
        this.debugPanel.sourcePanel.setTitle();
    }

    private void initScriptFiles() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugUI.this.debugPanel.sourcePanel.loadSourcePages();
            }
        });
    }

    public void setSubTitle(String title) {
        if (title == null || title.trim().length() == 0) {
            this.setTitle("KScript Debuger");
        } else {
            this.setTitle("KScript Debuger - " + title);
        }
    }

    public void enableActions() {
        for (Map.Entry ent : this.actions.entrySet()) {
            int action = (Integer)ent.getKey();
            Component btn = (Component)ent.getValue();
            btn.setEnabled(this.debugPanel.isActionEnabled(action));
        }
    }

    public void refreshState() {
        this.enableActions();
        this.status.setStatus(this.debugPanel);
    }

    public void handleDebugContextException(final Throwable ex) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.handleException(ex);
            if (this.debugPanel.debug != null) {
                this.removeDebug(this.debugPanel.debug);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugUI.this.handleDebugContextException(ex);
            }
        });
    }

    public void handleException(final Throwable ex0) {
        if (this.disableExceptionHandler) {
            return;
        }
        if (this.inExceptionHandler) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugUI.this.handleException(ex0);
                }
            });
            return;
        }
        this.inExceptionHandler = true;
        Throwable ex = ex0;
        logger.error((Object)ex, ex);
        String title = ex.getClass().getName();
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(ex);
            for (ex = ex.getCause(); ex != null; ex = ex.getCause()) {
                sb.append("\r\n\tcause by: " + ex);
            }
        }
        catch (Exception ex2) {
            logger.error((Object)ex2);
        }
        this.alert(title, sb.toString(), true);
        this.inExceptionHandler = false;
    }

    public void alert(final String title, final String msg, final boolean isError) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugUI.this.alert(title, msg, isError);
                }
            });
            return;
        }
        JOptionPane.showMessageDialog(this, msg, title, isError ? 0 : 1);
    }

    public boolean confirm(String title, String msg) {
        int r = JOptionPane.showConfirmDialog(this, msg, title, 0, 2);
        return r == 0;
    }

    public void alert(String msg) {
        this.alert("Alert", msg, true);
    }

    public void debugScript(final Source source, final Map context) {
        new Thread(){

            @Override
            public void run() {
                Interpreter r = new Interpreter();
                try {
                    r.eval(source.getText(), context);
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
        }.start();
    }

    private static boolean setFont(Component c, String name, int size) {
        try {
            c.setFont(new Font(name, 0, size));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setTextFont(Component c) {
        if (!DebugUI.setFont(c, "\u5b8b\u4f53", 14)) {
            DebugUI.setFont(c, "Courier New", 12);
        }
    }

    public void loadScript(IScript script) {
        try {
            this.debugPanel.sourcePanel.loadScript(script);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ContextItem {
        IDebugContext debug;

        public ContextItem(IDebugContext debug) {
            this.debug = debug;
        }

        public String toString() {
            try {
                Source source = this.debug.getMainSource();
                return "[" + DebugManager.getDebugRuntimeName(this.debug) + "][" + DebugUI.getStateName(this.debug.getState()) + "]" + this.debug.getRunningThread() + " " + source.getName();
            }
            catch (Exception _) {
                return null;
            }
        }
    }
}

