/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.util.lightremote;

import com.kingdee.bos.formula.kscript.util.lightremote.ICloseListener;
import com.kingdee.bos.formula.kscript.util.lightremote.IObjectFactory;
import com.kingdee.bos.formula.kscript.util.lightremote.IObjectStub;
import com.kingdee.bos.formula.kscript.util.lightremote.LocalRef;
import com.kingdee.bos.formula.kscript.util.lightremote.ProxyKey;
import com.kingdee.bos.formula.kscript.util.lightremote.RemoteEnv;
import com.kingdee.bos.formula.kscript.util.lightremote.RemoteException;
import com.kingdee.bos.formula.kscript.util.lightremote.RemoteRef;
import com.kingdee.bos.formula.kscript.util.lightremote.RemoteResult;
import com.kingdee.bos.kscript.debug.UniqueKey;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class RemoteContext
extends ClassLoader
implements IObjectFactory {
    static final Logger logger = Logger.getLogger(RemoteContext.class);
    public static final int INVOKE = 1;
    public static final int RELEASE = 2;
    public static final int RESULT = 3;
    public static final int CREATE = 4;
    public static final Object[] EMPTY_ARGS = new Object[0];
    public static final Class[] EMPTY_TYPES = new Class[0];
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private Socket sock;
    private volatile boolean isClosed = false;
    protected ArrayList remoteClasses = new ArrayList();
    protected ArrayList closeListeners = new ArrayList();
    protected HashMap proxyRefs = new HashMap();
    protected HashMap proxyObjects = new HashMap();
    protected final ReferenceQueue stubQueue = new ReferenceQueue();
    protected final HashMap stubs = new HashMap();
    private final HashMap results = new HashMap();
    private HashMap remoteMethods = new HashMap();
    private final HashMap methods = new HashMap();

    public RemoteContext(String address) throws Exception {
        this(RemoteContext.connect(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseListener(ICloseListener l) {
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCloseListener(ICloseListener l) {
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireClosed() {
        ICloseListener[] ls;
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            ls = new ICloseListener[this.closeListeners.size()];
            this.closeListeners.toArray(ls);
        }
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].onClosed(this);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static Socket connect(String address) throws Exception {
        String host = "127.0.0.1";
        int port = 11111;
        if (address != null && address.length() > 0) {
            int i = address.indexOf(58);
            if (i > 0) {
                host = address.substring(0, i);
                port = Integer.parseInt(address.substring(i + 1));
            } else {
                host = address;
            }
        }
        return new Socket(host, port);
    }

    public RemoteContext(Socket sock) throws Exception {
        super(RemoteContext.class.getClassLoader());
        this.sock = sock;
        this.out = new ObjectOutputStream(new BufferedOutputStream(sock.getOutputStream())){
            {
                super.enableReplaceObject(true);
            }

            @Override
            protected Object replaceObject(Object obj) throws IOException {
                obj = RemoteContext.this.replaceOutputObject(obj);
                return super.replaceObject(obj);
            }
        };
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(sock.getInputStream())){
            {
                super.enableResolveObject(true);
            }

            @Override
            protected Object resolveObject(Object obj) throws IOException {
                obj = RemoteContext.this.replaceInputObject(obj);
                return super.resolveObject(obj);
            }
        };
        this.registerRemoteClass(IObjectFactory.class);
    }

    protected void registerRemoteClass(Class model) {
        if (!this.remoteClasses.contains(model)) {
            this.remoteClasses.add(model);
        }
    }

    protected boolean isRemoteClass(Class cls) {
        if (!cls.isInterface()) {
            return false;
        }
        for (int i = 0; i < this.remoteClasses.size(); ++i) {
            Class model = (Class)this.remoteClasses.get(i);
            if (cls != model && !cls.isAssignableFrom(model)) continue;
            return true;
        }
        return false;
    }

    protected Class getRemoteObjectModel(Object obj) {
        for (int i = 0; i < this.remoteClasses.size(); ++i) {
            Class model = (Class)this.remoteClasses.get(i);
            if (!model.isInstance(obj)) continue;
            return model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteRef createProxy(Object obj, Class model) {
        HashMap hashMap = this.proxyRefs;
        synchronized (hashMap) {
            ProxyKey key = new ProxyKey(obj, model);
            RemoteRef ref = (RemoteRef)this.proxyRefs.get(key);
            if (ref != null) {
                return ref;
            }
            ref = new RemoteRef(model, obj);
            this.proxyRefs.put(key, ref);
            this.proxyObjects.put(ref.id, key);
            return ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProxyObject(LocalRef ref) {
        HashMap hashMap = this.proxyRefs;
        synchronized (hashMap) {
            ProxyKey key = (ProxyKey)this.proxyObjects.get(ref.id);
            return key.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean releaseProxyObject(Object id) {
        HashMap hashMap = this.proxyRefs;
        synchronized (hashMap) {
            ProxyKey key = (ProxyKey)this.proxyObjects.remove(id);
            this.proxyRefs.remove(key);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createObjectStub(RemoteRef ref) {
        HashMap hashMap = this.stubs;
        synchronized (hashMap) {
            WeakReference r = (WeakReference)this.stubs.get(ref);
            Object stub = null;
            if (r != null) {
                stub = r.get();
            }
            if (stub == null) {
                stub = Proxy.newProxyInstance(this, new Class[]{IObjectStub.class, ref.model}, (InvocationHandler)new Stub(ref));
                this.stubs.put(ref, new WeakReference<Object>(stub, this.stubQueue));
            }
            return stub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStub(RemoteRef ref) throws Exception {
        Object object = this.stubs;
        synchronized (object) {
            this.stubs.remove(ref);
        }
        if (this.isClosed) {
            return;
        }
        try {
            object = this.out;
            synchronized (object) {
                this.out.writeInt(2);
                this.out.writeObject(ref.id);
            }
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    protected Object replaceOutputObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IObjectStub) {
            RemoteRef ref = ((IObjectStub)obj)._getRemoteRef();
            return ref.getLocalRef();
        }
        Class model = this.getRemoteObjectModel(obj);
        if (model != null) {
            return this.createProxy(obj, model);
        }
        return obj;
    }

    protected Object replaceInputObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof RemoteRef) {
            return this.createObjectStub((RemoteRef)obj);
        }
        if (obj instanceof LocalRef) {
            return this.getProxyObject((LocalRef)obj);
        }
        return obj;
    }

    protected abstract void finalClose() throws Exception;

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RemoteContext remoteContext = this;
        synchronized (remoteContext) {
            this.notifyAll();
        }
        try {
            this.finalClose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireClosed();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected synchronized RemoteResult waitForResult(Object key) throws Exception {
        while (!this.results.containsKey(key)) {
            this.checkClosed();
            this.wait();
        }
        return (RemoteResult)this.results.remove(key);
    }

    protected synchronized void notifyResult(Object key, RemoteResult value) {
        this.results.put(key, value);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRemoteMethod(RemoteRef ref, Method method) {
        HashMap hashMap = this.remoteMethods;
        synchronized (hashMap) {
            Boolean r = (Boolean)this.remoteMethods.get(method);
            if (r != null) {
                return r;
            }
            try {
                Method m = ref.model.getMethod(method.getName(), method.getParameterTypes());
                r = new Boolean(true);
            }
            catch (Exception _) {
                r = new Boolean(this.isRemoteClass(method.getDeclaringClass()));
            }
            this.remoteMethods.put(method, r);
            return r;
        }
    }

    protected Object resolveObject(Object obj, Class type) {
        if (obj == null) {
            return null;
        }
        if (this.isRemoteClass(type)) {
            return this.createProxy(obj, type);
        }
        return obj;
    }

    protected Object[] resolveArgs(Object[] args, Class[] types) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] ar = new Object[args.length];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = this.resolveObject(args[i], types[i]);
        }
        return ar;
    }

    public void startServiceLoop() {
        RemoteEnv.startThread(new Runnable(){

            @Override
            public void run() {
                RemoteContext.this.serviceLoop();
            }
        });
    }

    protected abstract boolean handShake() throws Exception;

    public void serviceLoop() {
        try {
            if (this.handShake()) {
                while (!this.isClosed && this.service()) {
                }
            }
        }
        catch (Exception ex) {
            RemoteEnv.logException(logger, ex);
        }
        this.close();
    }

    protected void checkClosed() {
        if (this.isClosed) {
            throw new RemoteException("Connection has closed.");
        }
    }

    private boolean service() throws Exception {
        int cmd = this.in.readInt();
        switch (cmd) {
            case 1: {
                this.serviceInvoke();
                break;
            }
            case 2: {
                this.serviceRelease();
                break;
            }
            case 3: {
                this.serviceResult();
                break;
            }
            case 4: {
                this.serviceCreateObject();
                break;
            }
            default: {
                throw new RemoteException("invalid cmd(" + cmd + ")");
            }
        }
        return true;
    }

    @Override
    public Object createObject(String className, Class model) {
        return this.createObject(className, model, null, null);
    }

    protected Object createServerObject(String className, Class model, Class[] types, Object[] args) throws Exception {
        Class<?> cls = Class.forName(className);
        Object obj = cls.getConstructor(types).newInstance(args);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceCreateObject(Object invokeId, String className, Class model, Class[] types, Object[] args) {
        try {
            if (types == null) {
                types = EMPTY_TYPES;
            }
            if (args == null) {
                args = EMPTY_ARGS;
            }
            RemoteResult r = null;
            try {
                Object obj = this.createServerObject(className, model, types, args);
                RemoteRef ref = this.createProxy(obj, model);
                r = new RemoteResult(ref, 2);
            }
            catch (Exception ex) {
                r = new RemoteResult(ex, 1);
            }
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeInt(3);
                this.out.writeObject(invokeId);
                this.out.writeObject(r);
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.close();
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void serviceCreateObject() throws Exception {
        final Object invokeId = this.in.readObject();
        final String className = (String)this.in.readObject();
        final Class model = (Class)this.in.readObject();
        final Class[] types = (Class[])this.in.readObject();
        final Object[] args = (Object[])this.in.readObject();
        RemoteEnv.startThread(new Runnable(){

            @Override
            public void run() {
                RemoteContext.this.serviceCreateObject(invokeId, className, model, types, args);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createObject(String className, Class model, Class[] types, Object[] args) {
        Long invokeId = UniqueKey.next();
        try {
            args = this.resolveArgs(args, types);
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeInt(4);
                this.out.writeObject(invokeId);
                this.out.writeObject(className);
                this.out.writeObject(model);
                this.out.writeObject(types);
                this.out.writeObject(args);
                this.out.flush();
            }
        }
        catch (Exception ex) {
            this.close();
            throw new RemoteException(ex);
        }
        RemoteResult r = null;
        try {
            r = this.waitForResult(invokeId);
        }
        catch (Exception ex) {
            throw new RemoteException(ex);
        }
        return RemoteResult.getResult(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method lookupMethod(Object obj, String name, int argCount) {
        Class<?> cls = obj.getClass();
        HashMap hashMap = this.methods;
        synchronized (hashMap) {
            String key;
            HashMap<String, Method> map = (HashMap<String, Method>)this.methods.get(cls);
            if (map == null) {
                map = new HashMap<String, Method>();
                this.methods.put(cls, map);
            }
            if (map.containsKey(key = name + "(" + argCount + ")")) {
                return (Method)map.get(key);
            }
            Method[] ms = cls.getMethods();
            for (int i = 0; i < ms.length; ++i) {
                if (Modifier.isStatic(ms[i].getModifiers()) || !ms[i].getName().equals(name) || ms[i].getParameterTypes().length != argCount) continue;
                map.put(key, ms[i]);
                return ms[i];
            }
            logger.error((Object)("no method matched " + key + " in class " + cls.getName()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceInvoke(Object invokeId, Object obj, String method, Object[] args) {
        try {
            if (args == null) {
                args = EMPTY_ARGS;
            }
            Method md = this.lookupMethod(obj, method, args.length);
            RemoteResult r = null;
            if (md == null) {
                r = new RemoteResult(new NoSuchMethodException(method), 1);
            } else {
                try {
                    Object val = md.invoke(obj, args);
                    val = this.resolveObject(val, md.getReturnType());
                    if (val != null) {
                        r = new RemoteResult(val, 2);
                    }
                }
                catch (InvocationTargetException ie) {
                    r = new RemoteResult(ie.getTargetException(), 1);
                }
                catch (Exception ex) {
                    r = new RemoteResult(ex, 1);
                }
            }
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeInt(3);
                this.out.writeObject(invokeId);
                this.out.writeObject(r);
                this.out.flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.close();
        }
    }

    private void serviceInvoke() throws Exception {
        final Object invokeId = this.in.readObject();
        final Object obj = this.in.readObject();
        final String method = (String)this.in.readObject();
        final Object[] args = (Object[])this.in.readObject();
        RemoteEnv.startThread(new Runnable(){

            @Override
            public void run() {
                RemoteContext.this.serviceInvoke(invokeId, obj, method, args);
            }
        });
    }

    private void serviceRelease() throws Exception {
        Object id = this.in.readObject();
        this.releaseProxyObject(id);
    }

    private void serviceResult() throws Exception {
        Object id = this.in.readObject();
        RemoteResult value = (RemoteResult)this.in.readObject();
        this.notifyResult(id, value);
    }

    public static IObjectStub getStubInterface(Object stub) {
        if (stub == null || !(stub instanceof IObjectStub)) {
            return null;
        }
        return (IObjectStub)stub;
    }

    public static boolean isStubObject(Object stub) {
        return RemoteContext.getStubInterface(stub) != null;
    }

    public static boolean isStubConnectionClosed(Object stub) {
        IObjectStub x = RemoteContext.getStubInterface(stub);
        return x != null && x._isConnectionClosed();
    }

    class Stub
    implements InvocationHandler,
    IObjectStub {
        final RemoteRef ref;

        public Stub(RemoteRef ref) {
            this.ref = ref;
        }

        @Override
        public RemoteContext _getRemoteContext() {
            return RemoteContext.this;
        }

        @Override
        public RemoteRef _getRemoteRef() {
            return this.ref;
        }

        @Override
        public boolean _isConnectionClosed() {
            return RemoteContext.this.isClosed;
        }

        public int hashCode() {
            return this.ref.hashCode;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            if (x instanceof IObjectStub) {
                x = ((IObjectStub)x)._getRemoteRef();
            }
            if (x instanceof RemoteRef) {
                return this.ref.equals(x);
            }
            return false;
        }

        protected void finalize() throws Throwable {
            RemoteContext.this.releaseStub(this.ref);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!RemoteContext.this.isRemoteMethod(this.ref, method)) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException ie) {
                    throw ie.getTargetException();
                }
            }
            args = RemoteContext.this.resolveArgs(args, method.getParameterTypes());
            Long invokeId = UniqueKey.next();
            try {
                ObjectOutputStream objectOutputStream = RemoteContext.this.out;
                synchronized (objectOutputStream) {
                    RemoteContext.this.out.writeInt(1);
                    RemoteContext.this.out.writeObject(invokeId);
                    RemoteContext.this.out.writeObject(this.ref.getLocalRef());
                    RemoteContext.this.out.writeObject(method.getName());
                    RemoteContext.this.out.writeObject(args);
                    RemoteContext.this.out.flush();
                }
            }
            catch (Exception ex) {
                RemoteContext.this.close();
                throw ex;
            }
            return RemoteResult.getResult(RemoteContext.this.waitForResult(invokeId));
        }
    }
}

