/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.api;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclItem;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.service.formula.api.IFormulaVarInfos;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.api.KScriptFormulaParser;
import com.kingdee.bos.service.formula.api.VarInfo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FormulaVarInfoParser
implements IFormulaVarInfos {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.formula.api.FormulaVarInfoParser");
    private static Hashtable parsedFormulas = new Hashtable();

    @Override
    public IVarInfo[] getFormulaVars(String formulaStr) {
        if (formulaStr == null) {
            return null;
        }
        Object obj = parsedFormulas.get(formulaStr);
        if (obj != null && obj instanceof IVarInfo[]) {
            return (IVarInfo[])obj;
        }
        Vector<VarInfo> vars = new Vector<VarInfo>();
        LineNumberReader lnr = new LineNumberReader(new StringReader(formulaStr));
        String line = null;
        try {
            line = lnr.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (line != null) {
            int pos = line.indexOf("//{bos_formula_comments_var");
            if (pos > -1) {
                String newLine = line.substring(pos);
                VarInfo varInfo = new VarInfo("", "", "", "", "", "");
                String varName = this.innerDealVarComments("var_name", newLine);
                if (varName != null && varName.length() > 0) {
                    varInfo.setVarName(varName);
                    varInfo.setVarScope(this.innerDealVarComments("var_scope", newLine));
                    if (varName.equals("formula_result")) {
                        varInfo.setVarScope("return");
                    }
                    varInfo.setVarDesc(this.innerDealVarComments("var_desc", newLine));
                    String varType = this.innerDealVarComments("var_type", newLine);
                    String varAlias = this.innerDealVarComments("var_alias", newLine);
                    varInfo.setVarType(varType);
                    varInfo.setVarAlias(varAlias);
                }
                vars.add(varInfo);
            }
            try {
                line = null;
                line = lnr.readLine();
            }
            catch (IOException newLine) {}
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            if (parser == null) {
                logger.error((Object)"script is illegal ,parser is null");
                return null;
            }
            List stmtList = parser.stmtList;
            for (int i = 0; i < stmtList.size(); ++i) {
                CodeStmt currStmt = (CodeStmt)stmtList.get(i);
                if (!(currStmt instanceof VarDeclStmt)) continue;
                VarDeclStmt vdStmt = (VarDeclStmt)currStmt;
                for (int k = 0; k < vdStmt.varDeclList.size(); ++k) {
                    VarDeclItem vdItem = (VarDeclItem)vdStmt.varDeclList.get(k);
                    boolean exists = false;
                    for (int m = 0; m < vars.size(); ++m) {
                        if (!((IVarInfo)vars.get(m)).getVarName().equals(vdItem.name)) continue;
                        ((VarInfo)vars.get(m)).setVarInitval(KScriptFormulaParser.getConstantExprStr(vdItem.initExpr));
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    vars.add(new VarInfo(vdItem.name, "", "", KScriptFormulaParser.getConstantExprStr(vdItem.initExpr), "local", ""));
                }
            }
        }
        catch (ParserException pe) {
            logger.error((Object)"parse formula error", (Throwable)pe);
            return null;
        }
        IVarInfo[] varArr = new VarInfo[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            varArr[i] = (VarInfo)vars.get(i);
        }
        parsedFormulas.put(formulaStr, varArr);
        return varArr;
    }

    private String innerDealVarComments(String commentLeft, String commentLine) {
        int pos1 = commentLine.indexOf(commentLeft + "=");
        if (pos1 < 0) {
            return "";
        }
        int pos2 = commentLine.indexOf("|", pos1);
        if (pos2 < 0 && (pos2 = commentLine.indexOf("}", pos1)) < 0) {
            return "";
        }
        String retStr = commentLine.substring(pos1 + (commentLeft + "=").length(), pos2);
        return retStr.trim();
    }
}

