/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WFLinkNoticeAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFLinkNoticeAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum messageModel = null;
    Map<String, Object> contents = null;

    @Override
    public boolean isNeedSendXT() {
        return true;
    }

    public WFLinkNoticeAdapter(Message message) {
        this.message = message;
        this.ctx = WFLinkNoticeAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    @Override
    public MessageModelEnum getModel() {
        return this.messageModel;
    }

    @Override
    public Map<String, Object> getContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        contents.put("appid", appId);
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.messageModel)) {
            MsgBizType bizType = MsgBizType.getEnum((int)this.message.getIntHeader("bizType"));
            String tagId = MsgBizType.FORWARN == bizType ? "alarm" : "notify";
            contents.put("tagId", tagId);
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", new Locale("L2")));
            contents.put("text", this.message.getLocaleStringHeader("body", new Locale("L2")));
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        } else {
            contents.put("text", this.parseContent());
        }
        contents.put("todo", "0");
        contents.put("wxtitle", "\u6d88\u606f\u901a\u77e5");
        contents.put("url", this.message.getStringHeader("url"));
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("procinstid", this.message.getStringHeader("ProcessInstId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        return contents;
    }

    private String parseContent() {
        String msgContent = null;
        if (msgContent == null || msgContent.equals("")) {
            msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u6d88\u606f\u5185\u5bb9\uff1a" + this.message.getLocaleStringHeader("body", new Locale("L2"));
        }
        logger.info((Object)("XT ForWarn parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return msgContent;
    }

    @Override
    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message ForWarn getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message ForWarn getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ForWarn getUsers() error!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Date getUpdateTime() {
        return new Date();
    }

    @Override
    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            String initiatorId;
            String quarySql;
            IRowSet rowSet;
            String procinstid = this.message.getStringHeader("ProcessInstId");
            if ("flowcenter".equalsIgnoreCase(apiVersion) && !StringUtils.isEmpty((String)procinstid) && (rowSet = DbUtil.executeQuery((Context)this.ctx, (String)(quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? "), (Object[])new Object[]{initiatorId = this.message.getStringHeader("initiatorId"), initiatorId})).next()) {
                ifInit = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ForWarn ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.messageModel = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }
}

