/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.lightapp.dingtalk.DingtalkMessagePusher;
import com.kingdee.lightapp.dingtalk.DingtalkNoticeMessagePusher;
import com.kingdee.lightapp.dingtalk.DingtalkTaskPusher;
import com.kingdee.lightapp.kcclight.KccLightMessagePusher;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.welink.WeLinkMessagePusher;
import com.kingdee.lightapp.wx.WXMessagePusher;
import com.kingdee.lightapp.xt.MultiAppPusher;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJFlowCenterPusher;
import com.kingdee.lightapp.xt.YZJMessagePusher;
import com.kingdee.lightapp.xt.YZJMessageTokenPusher;
import com.kingdee.util.ConfigurationItem;

public class WFMessagePusherFactory {
    private static int APITYPE;

    public static IMessagePusher getWFMessagePusher(String version) {
        if (APITYPE == 0) {
            WFMessagePusherFactory.InitApiType();
        }
        IMessagePusher messagePusher = null;
        int type = APITYPE;
        switch (type) {
            case 1: {
                messagePusher = new YZJMessageTokenPusher("WFMessage");
                break;
            }
            case 2: {
                messagePusher = new YZJMessagePusher("WFMessage");
                break;
            }
            case 3: {
                messagePusher = new WXMessagePusher(version);
                break;
            }
            case 4: {
                messagePusher = new DingtalkMessagePusher(version);
                break;
            }
            case 5: {
                messagePusher = new WeLinkMessagePusher(version);
                break;
            }
            case 6: {
                messagePusher = new DingtalkNoticeMessagePusher(version);
                break;
            }
            case 7: {
                messagePusher = new YZJFlowCenterPusher(version);
                break;
            }
            case 8: {
                messagePusher = new DingtalkTaskPusher(version);
                break;
            }
            case 10: {
                messagePusher = new MultiAppPusher(version);
                break;
            }
            case 11: {
                messagePusher = new KccLightMessagePusher(version);
            }
        }
        return messagePusher;
    }

    private static void InitApiType() {
        XTServiceConfig configInstance = XTServiceConfig.getInstance();
        ConfigurationItem wxItem = configInstance.getConfigurationItem("WX");
        boolean isDingtalkApp = configInstance.checkIsDingtalkApp();
        boolean isWeLink = configInstance.checkIsWeLink();
        String apiVersion = configInstance.getXTInfoProperties().get("apiVersion");
        String dingtalkApiType = configInstance.getDingtalkApiType();
        ConfigurationItem otherAppItem = configInstance.getConfigurationItem("OtherApp");
        boolean isMultiApp = configInstance.checkIsMultiApp();
        ConfigurationItem KccAPIItem = configInstance.getConfigurationItem("KccAPI");
        APITYPE = KccAPIItem != null ? 11 : (isMultiApp ? 10 : (otherAppItem != null ? 9 : (isDingtalkApp && "3".equals(dingtalkApiType) ? 8 : ("flowcenter".equalsIgnoreCase(apiVersion) ? 7 : (isDingtalkApp && "2".equals(dingtalkApiType) ? 6 : (isWeLink ? 5 : (isDingtalkApp ? 4 : (wxItem != null ? 3 : ("old".equalsIgnoreCase(apiVersion) ? 2 : 1)))))))));
    }
}

